#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.

from .massive_change_field import MassiveChangeField
from .massive_change_plus_property import MassiveChangePlusProperty
from .massive_change_returns import MASSIVE_CHANGE_RETURNS
from .massive_change_status import MASSIVE_CHANGE_STATUS


class MassiveChangeProperty(MassiveChangeField):
    
    def __init__(self, name, item_type, category, has_plus, item_id, action):
        super(MassiveChangeProperty, self).__init__(name, item_type, item_id, category, action.is_protected, action)
        
        # Plus
        self.has_plus = has_plus
        self._plus = MassiveChangePlusProperty('plus', item_type, self.item_id, category, action.is_protected, action) if self.has_plus else None
    
    
    def get_plus(self):
        return self._plus
    
    
    def is_plus_modified(self):
        return self._plus.is_modified() if self.has_plus else None
    
    
    def set_previous_value(self, value, app, datamanagerV2):
        super(MassiveChangeProperty, self).set_previous_value(value, app, datamanagerV2)
        
        if self.has_plus:
            if value:
                self._plus.set_previous_value(value['has_plus'], app, datamanagerV2)
            else:
                self._plus.set_previous_value(None, app, datamanagerV2)
    
    
    def set_actual_value(self, value, modified, app, datamanagerV2, plus_modified=MASSIVE_CHANGE_STATUS.UNMODIFIED):
        super(MassiveChangeProperty, self).set_actual_value(value, modified, app, datamanagerV2)
        
        if self.has_plus:
            if value:
                self._plus.set_actual_value(value['has_plus'], plus_modified, app, datamanagerV2)
            else:
                self._plus.set_actual_value(None, plus_modified, app, datamanagerV2)
    
    
    def get_filter_state(self):
        return 'OK' if self.message == MASSIVE_CHANGE_RETURNS.OK else 'NOK'
    
    
    def get_html_action(self, app, step):
        if self.message == MASSIVE_CHANGE_RETURNS.OK:
            text = app._('mass-change.step-%s.table-summary.results.possible' % (step))
        else:
            text = '''<span onmouseenter="SHINKEN_TOOLTIP.showTooltip(this)" onmouseleave="SHINKEN_TOOLTIP.hideTooltip()" shi-tip-html="%s">%s</span>''' % (
                self.get_message_to_html(app, step, in_tooltip=True),
                app._('mass-change.step-%s.table-summary.results.not_possible' % (step))
            )
        
        _to_return = []
        _to_return.append('''<table class="shinken-width-100 shinken-action-cell-table">''')
        _to_return.append('''   <tr>''')
        _to_return.append('''       <td class="shinken-icon-cell">''')
        _to_return.append(self.get_state_in_html())
        _to_return.append('''       </td>''')
        _to_return.append('''       <td class="shinken-label-cell">''')
        _to_return.append('''           <div>''')
        _to_return.append('''               <span class="shinken-label">%s<span>''' % text)
        _to_return.append('''           </div>''')
        _to_return.append('''       </td>''')
        _to_return.append('''       <td class="shinken-icon-more-cell">''')
        _to_return.append('''           <div class="shinken-mass-change-show-more" onmouseenter="SHINKEN_TOOLTIP.showTooltip(this)" onmouseleave="SHINKEN_TOOLTIP.hideTooltip()" shi-tip-text="%s">%s</div>''' % (
            app._('mass-change.step-%s.messages.show_more' % (step)), app.helper.helper_object.get_button_html(label='...')))
        _to_return.append('''       </td>''')
        _to_return.append('''   </tr>''')
        _to_return.append('''</table>''')
        
        return ''.join(_to_return)
    
    
    def get_result_in_html(self, app, step):
        if self.message == MASSIVE_CHANGE_RETURNS.OK:
            if self.has_plus:
                if self._plus.message == MASSIVE_CHANGE_RETURNS.OK:
                    return self._html_actual_value
                else:
                    return self._plus.get_message_to_html(app, step)
            else:
                return self._html_actual_value
        else:
            return self.get_message_to_html(app, step)
