#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.
from shinken.log import logger


class CollapsedContent(object):
    def __init__(self, content, header=None, number_display=8, label_more="", label_less=""):
        self.content = content
        self.number_display = number_display
        self.label_more = label_more or "+"
        self.label_less = label_less or "-"
        self.header = header
    
    
    def get_html(self):
        _to_return = ['''<div class="shinken-toggle-parent shinken-collapsed">''', '''<table>''']
        if self.header:
            _to_return.append('''<tr><th>%s</th></tr>''' % ('</th><th>'.join(self.header)))
        _to_return_collapse = []
        table_lentgh = 0
        for index, _current in enumerate(self.content):
            table_lentgh = max(table_lentgh, len(_current))
            if index < self.number_display:
                _to_return.append('<tr><td>%s</td></tr>' % ('</td><td>'.join(_current)))
            else:
                _to_return_collapse.append('<tr><td>%s</td></tr>' % ('</td><td>'.join(_current)))
        
        if len(_to_return_collapse):
            _to_return.insert(1, '''<div class="shinken-button-more shinken-user-select-none" onclick="MANAGER.EventManager.clickOnToggleCollapse(this)">''')
            _to_return.insert(2, '''<span class="shinken-not-toggled">%s</span><span class="shinken-toggled">%s</span>''' % (self.label_more, self.label_less))
            _to_return.insert(3, '''</div>''')
            _to_return_collapse.insert(0, '''<tbody class="shinken-toggled">''')
            _to_return_collapse.append('</tbody>')
            _to_return.extend(_to_return_collapse)
            _text = '''<td onmouseenter="SHINKEN_TOOLTIP.showTooltip(this)" onclick="MANAGER.EventManager.clickOnToggleCollapse(this)" onmouseleave="SHINKEN_TOOLTIP.hideTooltip()" shi-tip-html="%s"><div class="shinken-text-vertical"></div></td>''' % self.label_more
            _to_return.append('<tr class="shinken-not-toggled">%s</tr>' % (_text * table_lentgh))
        
        _to_return.append('</table>')
        _to_return.append('</div>')
        
        return "".join(_to_return)
