//__lib__ lib_external
'use strict';

COMPONENT.Button           = function ( dom_element, name ) {
    // dom_element
    // value
    // state
    // label
    // name
    this.state = COMPONENT.CONST.BTN_STATE.OFF;
    this.name  = name;
    this.init( dom_element );
};
COMPONENT.Button.prototype = {
    init             : function ( dom_element ) {
        this.dom_element = dom_element;
        this.value       = this.dom_element.value;
        this._computeState();
    },
    setState         : function ( to_set ) {
        this.state = to_set;
        switch ( this.state ) {
            case COMPONENT.CONST.BTN_STATE.OFF:
                this.dom_element.classList.remove( COMPONENT.CONST.BTN_RADIO.CLASS.SHINKEN_BUTTON_ACTIVE );
                this.dom_element.classList.remove( COMPONENT.CONST.BTN_RADIO.CLASS.SHINKEN_BUTTON_DISABLED );
                break;
            case COMPONENT.CONST.BTN_STATE.ON:
                this.dom_element.classList.add( COMPONENT.CONST.BTN_RADIO.CLASS.SHINKEN_BUTTON_ACTIVE );
                break;
            case COMPONENT.CONST.BTN_STATE.DISABLED:
                this.dom_element.classList.add( COMPONENT.CONST.BTN_RADIO.CLASS.SHINKEN_BUTTON_DISABLED );
                break;
        }
    },
    getValue         : function () {
        return this.value;
    },
    getState         : function () {
        return this.state;
    },
    isOn             : function () {
        return this.state === COMPONENT.CONST.BTN_STATE.ON;
    },
    _computeState    : function () {
        if ( this.state === COMPONENT.CONST.BTN_STATE.DISABLED ) {
            return;
        }
        if ( this.dom_element.classList.contains( COMPONENT.CONST.BTN_RADIO.CLASS.SHINKEN_BUTTON_ACTIVE ) ) {
            this.setState( COMPONENT.CONST.BTN_STATE.ON );
        }
    },
    setInheritedLabel: function ( to_set ) {
        this.dom_element.querySelector( '.shinken-inherited-value' ).innerHTML = to_set;
    },
    appendToHtml     : function ( _dom_value_to_append ) {
        //TODO GREG A RENDRE OBSOLETE
        this.dom_element.appendChild( _dom_value_to_append );
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.Button, SHINKEN.OBJECT.CounterInterface );