//__lib__ lib_external

'use strict';

SHINKEN_LIST.Filters           = function ( dom_element, type ) {
    //contents
    this.type = type;
    this.init( dom_element );
};
SHINKEN_LIST.Filters.prototype = {
    init                 : function ( dom_element ) {
        this.initContents( dom_element.querySelectorAll( '.shinken-list-filter' ) );
    },
    initContents         : function ( dom_elements ) {
        this.contents = {};
        var _current;
        for ( var i = 0, _size_i = dom_elements.length; i < _size_i; i++ ) {
            _current = new SHINKEN_LIST.Filter( dom_elements[ i ], this.type );
            if ( _current.isValid() ) {
                this.contents[ _current.getName() ] = _current;
            }
        }
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getFilter            : function ( name ) {
        return this.contents[ name ];
    },
    getActiveFilters     : function () {
        var _to_return = [];
        var _keys      = Object.keys( this.contents );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            if ( this.contents[ _current_key ].isSet() ) {
                _to_return.push( this.contents[ _current_key ] );
            }
        }
        return _to_return;
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    askComputeAfterChange: function ( dom_element, parent ) {
        var _parent_dom_element = DOM.Service.findParentElementWithDataSet( dom_element, 'name', 10 );
        var _type               = _parent_dom_element.dataset.objectType;
        switch ( _type ) {
            case 'shinken-list-filter':
                this.getFilter( _parent_dom_element.dataset.name ).askComputeAfterChange( dom_element, parent || this, { 'type': _type } );
                break;
        }
    },
    clickOnSelector      : function ( event ) {
        var _parent_dom_element = DOM.Service.findParentElementWithDataSet( event.target, 'name', 10 );
        var _type               = _parent_dom_element.dataset.objectType;
        switch ( _type ) {
            case 'shinken-list-filter':
                var _to_return = this.getFilter( _parent_dom_element.dataset.name );
                _to_return.clickOnSelector( _parent_dom_element );
                return _to_return;
        }
    },
    clickOnItemSelector  : function ( event ) {
        var _option             = DOM.Service.findParentElementWithDataSet( event.target, 'keyName', 10 );
        var _parent_dom_element = DOM.Service.findParentElementWithDataSet( event.target, 'name', 20 );
        var _type               = _parent_dom_element.dataset.objectType;
        switch ( _type ) {
            case 'shinken-list-filter':
                this.getFilter( _parent_dom_element.dataset.name ).clickOnItemSelector( _option.dataset.keyName, _parent_dom_element, false, event );
                break;
        }
    },
    //********************************************  OTHERS *****************************************************//
    hidePopup            : function ( exception ) {
        var _keys = Object.keys( this.contents );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            if ( exception !== this.contents[ _keys[ i ] ] ) {
                this.contents[ _keys[ i ] ].hidePopup();
            }
        }
    }
};