'use strict';

MANAGER.DistributorButtonManager           = function () {
    this.buttons = {};
};
MANAGER.DistributorButtonManager.prototype = {
    createButton: function ( name ) {
        var _id          = 'id-shinken-btn-' + name;
        var _dom_element = document.getElementById( _id );
        if ( !_dom_element ) {
            return;
        }
        var _to_return = new COMPONENT.Button( _dom_element, name );
        _to_return.initCounters();
        this.setButton( name, _to_return );
        return _to_return;
    },
    delete      : function ( name ) {
        delete this.buttons[ name ];
    },
    findButton  : function ( name ) {
        if ( !name ) {
            return;
        }
        var _to_return = this.getButton( name );
        if ( !_to_return ) {
            _to_return = this.createButton( name );
        }
        return _to_return;
    },
    setButton   : function ( name, button ) {
        this.buttons[ name ] = button;
    },
    getButton   : function ( name ) {
        return this.buttons[ name ];
    },
    reset       : function () {
        this.buttons        = {};
    }
};
MANAGER.__instance_button_distributor      = new MANAGER.DistributorButtonManager();