'use strict';

MANAGER.DistributorCounterManager           = function () {
    this.counters = {};
};
MANAGER.DistributorCounterManager.prototype = {
    createCounter: function ( name ) {
        var _id          = 'id-shinken-' + name + '-counter';
        var _dom_element = document.getElementById( _id );
        if ( !_dom_element ) {
            return;
        }
        var _to_return = new SHINKEN.OBJECT.Counter();
        _to_return.init( _dom_element );
        this.setCounter( name, _to_return );
        return _to_return;
    },
    delete       : function ( name ) {
        delete this.counters[ name ];
    },
    findCounter  : function ( name, reset ) {
        if ( !name ) {
            return;
        }
        var _to_return = this.getCounter( name );
        if ( reset && _to_return ){
            delete this.counters[ name ];
            _to_return= null;
        }
        if ( !_to_return ) {
            _to_return = this.createCounter( name );
        }
        return _to_return;
    },
    setCounter   : function ( name, button ) {
        this.counters[ name ] = button;
    },
    getCounter   : function ( name ) {
        return this.counters[ name ];
    },
    reset        : function () {
        this.counters = {};
    }
};
MANAGER.__instance_counter_distributor      = new MANAGER.DistributorCounterManager();