'use strict';

OBJECT.CONST.STEP = {
    ERROR: -1,
    _0   : 0,
    _1   : 1,
    _2   : 2,
    _3   : 3,
    _4   : 4,
    _5   : 5
};

OBJECT.Steps           = function ( nb_step ) {
    this.init( nb_step );
};
OBJECT.Steps.prototype = {
    init           : function ( nb_step ) {
        this.max_step = nb_step;
        this.contents = [];
        this.current  = 0;
        for ( var i = 0; i <= this.max_step; i++ ) {
            this.contents[ i ] = new OBJECT.Step( i );
        }
    },
    initDomElements: function ( shinken_id ) {
        this.dom_element = document.getElementById( shinken_id );
        for ( var i = 0; i <= this.max_step; i++ ) {
            this.get( i ).initDomElement( shinken_id );
        }
    },
    setDomReady    : function ( to_set ) {
        this.get( this.current ).setDomReady( to_set );
    },
    isDomReady     : function () {
        return this.get( this.current ).is_dom_ready;
    },
    setCurrent     : function ( index ) {
        this.previous = this.current;
        this.current  = index;
        DOM.Service.setDataSet( this.dom_element, 'currentStep', this.current );
    },
    get            : function ( index ) {
        if ( index === undefined ) {
            index = this.current;
        }
        return this.contents[ index ];
    },
    getNextButton  : function () {
        return this.get( this.current ).button_next;
    }
};

OBJECT.Step           = function ( index ) {
    this.index        = index;
    this.button_next  = null;
    this.is_dom_ready = false;
    this.dom_element  = null;
    this.dom_id       = null;
};
OBJECT.Step.prototype = {
    init          : function () {
    },
    setDomReady   : function ( to_set ) {
        this.is_dom_ready = to_set;
        if ( this.is_dom_ready ) {
            this.dom_element = document.getElementById( this.dom_id );
            this.button_next = MANAGER.__instance_button_distributor.findButton( "step" + this.index + "-next" );
        }
        else {
            this.setHtmlContent( document.querySelector( ".shinken-loading-div" ) );
        }
    },
    setHtmlContent: function ( dom_element_target ) {
        if ( this.dom_element && dom_element_target ) {
            this.dom_element.innerHTML = dom_element_target.outerHTML;
        }
    },
    initDomElement: function ( shinken_id ) {
        this.dom_id = shinken_id + "-step" + this.index;
    }
};
