'use strict';

PROPERTY.StringInputWithDropDown           = function ( dom_element ) {
    // dom_element
    // name
    // value
    // type
    // component_input
    // component_btn_inheritance
    // state
    // state_inheritance
    // state_problem
    // inherited_label
    // custom_selected
    // tab_parent_id
    // has_warning_value
    // has_error_value
    // timeout_compute_value
    // help_content
    this.timeout_ask_compute_after_change;
    this.init( dom_element );
};
PROPERTY.StringInputWithDropDown.prototype = {
    init                      : function ( dom_element ) {
        this.initDomElement( dom_element );
        this.component_input                           = new COMPONENT.InputWithDropDown( dom_element.querySelector( ".shinken-input-with-dropdown" ), this );
        this.selectors[ PROPERTY.CONST.SELECTOR.MAIN ] = this.component_input;
        this.component_btn_inheritance                 = new COMPONENT.BtnInheritance( this.name, dom_element, this.type );
        if ( this.getName() === PROPERTY.CONST.NAME.PREFIX ) {
            this.component_input.setExtraTooltip( _( "sync.extra_tooltip_rename_prefix" ) );
        }
    },
    //********************************************  EVENT LISTENER  **************************************************//
    askComputeAfterChange     : function ( dom_element ) {
        if ( this.is_disabled ) {
            return;
        }
        this.component_input.askComputeAfterChange( dom_element, this );
    },
    doActionAfterChange       : function ( args ) {
        this.component_input.doActionAfterChange();
        this._computeState();
        if ( this.is_mass_change ) {
            MANAGER.ListenerEventManager.askAfterActionProperty( this );
        }
        fire_element_is_modifie();
    },
    clickOnInput              : function () {
        this.component_input.clickOnInput();
    },
    ___clickOnItemSelector    : function ( target_component, key_name ) {
        this.component_input.clickOnItemSelector( this.name, key_name );
        this._computeState();
    },
    ___hidePopup              : function ( exception ) {
        if ( exception !== this.component_input ) {
            this.component_input.hidePopup();
        }
    },
    //********************************************  KEY EVENT   ******************************************************//
    keydown                   : function ( event, key_code ) {
        this.component_input.keydown( event, key_code );
    },
    //********************************************  COMPUTE  (PRIVATE) ***********************************************//
    _computeBtnInheritance    : function () {
        if ( this.state && this.component_btn_inheritance.getState() !== COMPONENT.CONST.BTN_STATE.INIT ) {
            return;
        }
        var _is_inheritable = !this.getValue();
        this.setStateInheritance( _is_inheritable );
    },
    _computeState             : function () {
        var _to_set            = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
        this.state_inheritance = (this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON);
        if ( this.is_mass_change ) {
            _to_set     = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
            var _action = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getValue();
            switch ( _action ) {
                case PROPERTY.CONST.MASS_CHANGE.ACTION.NONE:
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                    break;
                case PROPERTY.CONST.MASS_CHANGE.ACTION.EMPTY:
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
                    break;
                case PROPERTY.CONST.MASS_CHANGE.ACTION.FORCE_TO_DEFAULT:
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT;
                    break;
                default:
                    if ( this.getValue() ) {
                        _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
                    }
            }
        }
        else if ( this.state_inheritance ) {
            _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        else if ( !this.getValue() ) {
            _to_set = this.component_btn_inheritance.isSet() ? PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT : PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
        }
        this.setState( _to_set );
        this.checkErrorWarning();
    },
    //********************************************  VIEW    **********************************************************//
    ___updateView             : function () {
        this._computeState();
    },
    //********************************************  VALIDATION      **************************************************//
    computeErrorsSpecifics    : function () {
        this.component_input.validateValueInput();
    },
    setErrorsSpecific         : function () {
        this.counter_temp_error   = this.component_input.error_number;
        this.counter_temp_warning = this.component_input.warning_number;
    },
    //********************************************  SETTER GETTER   **************************************************//
    getSelector               : function () {
        return this.selectors[ PROPERTY.CONST.SELECTOR.MAIN ];
    },
    setStateProblem           : function ( _to_set ) {
        this.state_problem = _to_set;
        DOM.Service.setDataSet( this.dom_element, 'stateProblem', this.state_problem );
    },
    getStateProblem           : function () {
        return this.state_problem;
    },
    ___unset                  : function () {
        this.setValueFromUser( "" );
        if ( this.is_mass_change ) {
            var _action = this.selectors[ PROPERTY.CONST.MASS_CHANGE.SELECTOR.ACTION ].getLastSelectedElement().element.name;
            switch ( _action ) {
                case PROPERTY.CONST.MASS_CHANGE.ACTION.EMPTY:
                case PROPERTY.CONST.MASS_CHANGE.ACTION.FORCE_TO_DEFAULT:
                    this.component_input.input.setPlaceholder();
                    break;
                default:
                    this.component_input.input.setPlaceholder( _( "mass-change.label.enter_a_value" ) );
                    break;
            }
        }
    },
    setValueFromUser          : function ( value ) {
        this.component_input.dom_element.value = value;
        this.askComputeAfterChange();
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    getValueInherited         : function () {
        return this.component_btn_inheritance.getValueFinal();
    },
    getValue                  : function () {
        return this.component_input.getValue();
    },
    //********************************************  INHERITANCE     **************************************************//
    updateWithTemplateSpecific: function () {
        this._computeState();
    },
    cleanBeforeUpdate         : function () {
        this.component_input.setPlaceholder();
    },
    //********************************************  SAVE     *********************************************************//
    getDataToSaveFinal        : function () {
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                return this.is_mass_change ? PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE : "";
            case PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT:
            case PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT:
                return PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
            default:
                if ( this.is_protected && this.component_input.hasBeenChanged() ) {
                    return SHINKEN.TOOLS.STRING.b64Encode( this.getValue() );
                }
                return this.getValue();
        }
    }
    
};

SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.StringInputWithDropDown, PROPERTY.Interface );