SHINKEN.TRY_CHECK = (function ( self ) {
    "use strict";
    
    self.tryCheck                    = function ( check_in_page_host, is_exec, is_on_poller ) {
        var _id = check_in_page_host.getDomUUID();
        get_spinner( 'spinner-check-run-' + _id );
        var _current_obj              = get_current_object();
        var _macromodulations_on_host = MANAGER.__instance_property_distributor.getElement( 'macromodulations' );
        _current_obj.macromodulations = _macromodulations_on_host.getValueAndValueInherited();
        
        var _dfe = "";
        if ( check_in_page_host.key_dfe ) {
            _dfe = check_in_page_host.dfe_object;
            delete _dfe[ "_messages" ];
        }
        
        var _obj_string = JSON.stringify( _current_obj );
        var _host_type  = MANAGER.__instance_element_distributor.current_element.getType();
        
        $.ajax( {
            type   : "POST",
            data   : {
                host     : _obj_string,
                item_type: _host_type,
                check_id : check_in_page_host.uuid,
                do_exec  : is_exec,
                on_poller: is_on_poller,
                dfe      : JSON.stringify( _dfe )
            },
            url    : '/element/run?ts=' + Date.now(),
            success: function ( results ) {
                _displayTryCheckResult( check_in_page_host, results, is_exec );
            },
            error  : function ( data, txt ) {
                var _dom_element_content_try_check = document.getElementById( 'result-check-run-' + _id );
                var _dom_element_spinner           = document.getElementById( 'spinner-check-run-' + _id );
                DOM.Service.empty( _dom_element_spinner );
                check_in_page_host.dom_element_try_check_container.classList.remove( 'shinken-hidden' );
                check_in_page_host.dom_element.querySelector( '.shinken-hide-eval' ).classList.remove( 'shinken-hidden' );
                var _text = data.statusText;
                if ( !data.status ) {
                    _text = _( 'element.backend_unreacheable' );
                }
                _dom_element_content_try_check.innerHTML = '<span class="span12 alert alert-error">' + _text + '</span>';
            }
        } );
    };
    var _displayTryCheckResult       = function ( check_in_page_host, results, _is_exec ) {
        var _id                            = check_in_page_host.getDomUUID();
        var _dom_element_tr_try_check      = document.getElementById( 'tr-check-run-' + _id );
        var _dom_element_tr_check_line     = document.getElementById( 'id-shinken-check-line-' + _id );
        var _dom_element_content_try_check = document.getElementById( 'result-check-run-' + _id );
        var _dom_element_spinner           = document.getElementById( 'spinner-check-run-' + _id );
        DOM.Service.empty( _dom_element_spinner );
        
        var _macros = results.macros;
        
        _dom_element_tr_try_check.classList.remove( 'shinken-hidden' );
        _dom_element_tr_check_line.querySelector( '.shinken-hide-eval' ).classList.remove( 'shinken-hidden' );
        DOM.Service.empty( _dom_element_content_try_check );
        
        if ( results.error ) {
            _dom_element_content_try_check.innerHTML = '<span class="span12 alert alert-error">' + results.error + '</span>';
            return;
        }
        
        var $commandContainer = $( '<div class="shinken-block-container-try-check shinken-try-check-command-container">' );
        var $commandContent   = $( '<div class="content">' );
        $commandContainer.append( '<h4>' + _( 'element.command_line' ) + ': </h4>' );
        /***************************
         * EVALUATION
         ***************************/
        var $evaluationContainer = $( '<div class="shinken-block-container-try-check shinken-try-check-evaluation-container">' );
        var $evaluationContent   = $( '<div class="content">' );
        $evaluationContent.append( '<span class="title">' + _( 'element.args' ) + ':</span>' );
        
        if ( _macros.length > 0 ) {
            $evaluationContainer.append( '<h4>' + _( 'element.evaluation' ) + ': </h4>' );
            var $tableData = _createMacroEvaluationTable( _macros );
            $evaluationContent.append( $tableData );
            
            var cmd_line_expanded                   = results.expanded_command_line;
            var password_protected_display          = '<span class="shinken-protected-password">' + _( 'element.password_protected' ) + '</span>';
            var __missing_argn_display              = '';
            var __unknown_data_display              = '';
            var __missing_duplicate_foreach_display = '<span class="missing-evaluated-value">' + _( 'element.missing_dfe' ) + '</span>';
            var __missing_global_display            = '<span class="missing-evaluated-value">' + _( 'element.missing_global' ) + '</span>';
            
            cmd_line_expanded = cmd_line_expanded.replace( REGEXS.MISSING_ARGN, __missing_argn_display )
                                                 .replace( REGEXS.UNKNOWN_DATA, __unknown_data_display )
                                                 .replace( REGEXS.MISSING_DFE, __missing_duplicate_foreach_display )
                                                 .replace( REGEXS.MISSING_GLOBAL, __missing_global_display );
            cmd_line_expanded = SHINKEN.TOOLS.STRING.uncleanBeforecleanXss( cmd_line_expanded );
            cmd_line_expanded = cmd_line_expanded.replace( REGEXS.PROTECTED_PASSWORD, password_protected_display );
            
            if ( results.command_line !== cmd_line_expanded ) {
                $evaluationContent.append( '<span class="title">' + _( 'element.command_line_data' ) + ':</span>' );
                $evaluationContent.append( '<div class="code"><p>' + cmd_line_expanded + '</p></div>' );
            }
            
            $evaluationContainer.append( $evaluationContent );
        }
        else {
            $evaluationContainer.append( '<h4>' + _( 'element.evaluation' ) + ': <span>' + _( 'element.evaluation_no_data' ) + '</span></h4>' );
        }
        
        var raw_command_line_html = _create_raw_command_line( results.command_line, _macros );
        $commandContent.append( raw_command_line_html );
        $commandContainer.append( $commandContent );
        _dom_element_content_try_check.appendChild( $commandContainer[ 0 ] );
        
        _dom_element_content_try_check.appendChild( $evaluationContainer[ 0 ] );
        
        /***************************
         * EXECUTION
         ***************************/
        
        _dom_element_content_try_check.appendChild( _createExecutionContainer( results, _is_exec ) );
        
        _dom_element_tr_try_check.classList.remove( 'shinken-hidden' );
        
    };
    var _createExecutionContainer    = function ( results, _is_exec ) {
        var _to_return = DOM.Service.createElement( "div", { class: "shinken-block-container-try-check" } );
        if ( !_is_exec ) {
            _to_return.appendChild( DOM.Service.createElement( "h4", {}, _( 'element.execution' ) + ' : <span>' + _( 'element.not_asked' ) + '</span>' ) );
            return _to_return;
        }
        
        
        results.execution.stdout = results.execution.stdout
                                          .replace( REGEXS.MISSING_ARGN, '' )
                                          .replace( REGEXS.UNKNOWN_DATA, '' )
                                          .replace( REGEXS.MISSING_DFE, '' )
                                          .replace( REGEXS.MISSING_GLOBAL, '' );
        
        _to_return.appendChild( DOM.Service.createElement( "h4", {}, _( 'element.execution' ) + _( 'element.execution_on_the_' + results.execution.executor_type ) + '[ <span class="executor_name">' + results.execution.executor_name + '</span> ] :' ) );
        
        var _has_result_modulation   = !!results[ 'resultmodulations' ];
        var _has_matching_modulation = _has_result_modulation && !!results[ 'applied_resultmodulation' ][ 'name' ];
        
        var _content = DOM.Service.createElement( "div", { class: "content" } );
        
        
        if ( _has_result_modulation ) {
            _content.appendChild( DOM.Service.createElement( "div", { class: "title" }, _( 'element.normal_execution' ) ) );
        }
        _content.appendChild( drawExecutionTable( results.execution.rc, results.execution.stdout, results.execution.shell_execution, results.execution.execution_time.toFixed( 3 ), results.execution.output, results.execution.long_output, results.execution.perf_data, 'shinken-execution-table' )[ 0 ] );
        if ( !_has_result_modulation ) {
            _to_return.appendChild( _content );
            return _to_return;
        }
        var _trad_modulation_matching;
        if ( _has_matching_modulation ) {
            _trad_modulation_matching = results[ 'applied_resultmodulation' ][ 'origin' ] === 'hosts' ? _( 'element.resultmodulation_match_on_host' ) : _( 'element.resultmodulation_match' );
        }
        else {
            _trad_modulation_matching = results[ 'applied_resultmodulation' ][ 'origin' ] === 'hosts' ? _( 'element.resultmodulation_no_match_on_host' ) : _( 'element.resultmodulation_no_match' );
        }
        
        _content.appendChild( DOM.Service.createElement( "div", { class: "title" }, _( 'type.resultmodulation' ) + ': <span class="high">' + _trad_modulation_matching + '</span>' ) );
        _createResultModulationTable( results, _has_matching_modulation, _content );
        
        if ( _has_matching_modulation ) {
            _content.appendChild( DOM.Service.createElement( "div", { class: "title" }, _( 'element.execution_with_modulation' ) + ':' ) );
            _content.appendChild( drawExecutionTable( results.applied_resultmodulation.rc, results.execution.stdout, results.execution.shell_execution, results.execution.execution_time.toFixed( 3 ), results.execution.output, results.execution.long_output, results.execution.perf_data, 'shinken-matching-modulation' )[ 0 ] );
        }
        _to_return.appendChild( _content );
        return _to_return;
    };
    var _createTagTimePeriod         = function ( time_period, modulation ) {
        var _tooltip = {};
        if ( time_period.isNew() ) {
            _tooltip[ 'shi-tip-html' ] = _( 'element.tooltip_timeperiod_new' );
            modulation._class_try_check_period += ' shinken-new';
        }
        else if ( modulation._class_try_check_period === 'shinken-inactive' ) {
            _tooltip[ 'shi-tip-html' ] = _( 'element.tooltip_timeperiod_out_time' );
        }
        else {
            _tooltip[ 'shi-tip-html' ]      = time_period.getName();
            _tooltip[ 'shi-tip-condition' ] = SHINKEN_TOOLTIP.CONDITION.ELLIPSIS;
            _tooltip[ 'shi-tip-class' ]     = 'shinken-space';
        }
        var _title = DOM.Service.createElement( 'span', { class: 'tag-timeperiod tag-block ' + modulation._class_try_check_period } );
        var _link  = DOM.Service.createElement( 'span', { class: 'shinken-link-title' }, time_period.getName() );
        DOM.Service.addTooltip( _link, _tooltip );
        _title.appendChild( DOM.Service.createElement( 'i', { class: 'icon-time' } ) );
        _title.appendChild( _link );
        return SHINKEN.TOOLS.buildLinkShinkenElement( time_period, _title.outerHTML );
    };
    var _createResultModulationTable = function ( results, modulationHasMatch, $executionContent ) {
        var _current_modulation;
        var _current_modulation_from_result;
        var _current_time_period;
        var _current_name;
        
        var _to_return = DOM.Service.createElement( "div", { class: 'shinken-content-modulation' } );
        for ( var i = 0, _size = results[ PROPERTY.CONST.NAME.RESULT_MODULATIONS ].length; i < _size; i++ ) {
            _current_modulation_from_result = results[ PROPERTY.CONST.NAME.RESULT_MODULATIONS ][ i ];
            _current_name                   = _current_modulation_from_result.item[ 'resultmodulation_name' ];
            _current_modulation             = MANAGER.__instance_element_distributor.getElementByName( _current_name );
            _current_time_period            = MANAGER.__instance_element_distributor.getElementByName( _current_modulation[ 'modulation_period' ] );
            
            _current_modulation._class_try_check          = '';
            _current_modulation.is_try_check_table_active = true;
            if ( results[ 'applied_resultmodulation' ][ 'name' ] === _current_modulation.getName() ) {
                _current_modulation._class_try_check = 'active';
            }
            else {
                _current_modulation.is_try_check_table_active = false;
            }
            
            var nbr        = _size > 1 ? 50 : 100;
            var marginSize = (i + 1 == _size) ? 0 : 10;
            var _block_mod = DOM.Service.createElement( "div", { class: 'block-modulation', style: 'width: calc(' + nbr + '% - ' + marginSize + 'px); margin-right: ' + marginSize + 'px;' } );
            
            if ( !_current_modulation.is_enabled ) {
                _current_modulation._class_try_check          = 'shinken-disabled';
                _current_modulation.is_try_check_table_active = false;
            }
            else if ( _current_modulation.is_new ) {
                _current_modulation._class_try_check = 'new';
            }
            
            var hasMissingModulation = !!_current_modulation_from_result[ 'missing' ];
            
            var rules = _current_modulation_from_result.rules || [];
            
            if ( _current_time_period ) {
                if ( _current_modulation_from_result[ 'timeperiod' ][ 'eval' ] ) {
                    _current_modulation._class_try_check_period = 'active';
                }
                else {
                    _current_modulation._class_try_check_period   = 'shinken-inactive';
                    _current_modulation.is_try_check_table_active = false;
                }
            }
            var _class = "table-rule-result table-hover table-striped table-bordered";
            if ( !_current_modulation.is_try_check_table_active ) {
                _class += " opacity";
            }
            var _table_rules      = DOM.Service.createElement( "table", { class: _class } );
            var _table_rules_head = DOM.Service.createElement( "thead", { style: 'background-color: #C2C2C2;' }, '' );
            _table_rules_head.appendChild( DOM.Service.createElement( "th", { class: 'col-status', colspan: 2 }, _( 'resultmodulations.status_match' ) ) );
            _table_rules_head.appendChild( DOM.Service.createElement( "th", { class: 'col-pattern', colspan: 2 }, _( 'resultmodulations.output_re_match' ) ) );
            _table_rules_head.appendChild( DOM.Service.createElement( "th", { class: 'col-status-out', colspan: 2 }, _( 'resultmodulations.status_result' ) ) );
            var _table_rules_body = DOM.Service.createElement( "tbody" );
            
            var _tag;
            if ( !hasMissingModulation ) {
                _tag = DOM.Service.createElement( 'div', {
                    class: 'shinken-tag-modulation tag-block shinken-space ' + _current_modulation._class_try_check
                }, _current_modulation.getName() );
                if ( !_current_modulation.is_enabled ) {
                    DOM.Service.addTooltip( _tag, { 'shi-tip-html': _( 'element.tooltip_resultmodulation_disabled' ) } );
                }
                else if ( _current_modulation.is_new ) {
                    DOM.Service.addTooltip( _tag, { 'shi-tip-html': _( 'element.tooltip_resultmodulation_new' ) } );
                }
                else {
                    DOM.Service.addTooltip( _tag, { 'shi-tip-html': _current_modulation.getName(), 'shi-tip-condition': SHINKEN_TOOLTIP.CONDITION.ELLIPSIS, 'shi-tip-class': 'shinken-space' } );
                }
                //else if ( hasTimePeriod && classTimeperiod === '' ) {
                //    modulationMessage = _( 'element.tooltip_resultmodulation_out_time' );
                //}
                //else if ( !results[ 'applied_resultmodulation' ][ 'name' ] ) {
                //    _tag.setAttribute( 'shi-tip-html', _current_modulation.getName() + ' => ' + _( 'element.tooltip_resultmodulation_no_match' ) );
                //    _tag.removeAttribute( 'shi-tip-condition' );
                //}
                var _link = SHINKEN.TOOLS.buildLinkShinkenElement( _current_modulation, _tag.outerHTML );
                _block_mod.appendChild( _link );
                if ( _current_time_period ) {
                    _block_mod.appendChild( _createTagTimePeriod( _current_time_period, _current_modulation ) );
                }
                for ( var k = 0, kl = rules.length; k < kl; k++ ) {
                    var rule = rules[ k ];
                    
                    rule.in_state  = changeNbStatusToLabel( rule.in_state );
                    rule.out_state = changeNbStatusToLabel( rule.out_state );
                    rule.pattern   = (rule.pattern != null) ? rule.pattern : '';
                    
                    var hasMatch = '';
                    if ( rule.in_state_eval === 'true' && rule.pattern_eval === 'true' ) {
                        hasMatch                 = 'active';
                        rule[ 'out_state_eval' ] = true;
                    }
                    else {
                        rule[ 'out_state_eval' ] = false;
                    }
                    
                    var _rule_dom = DOM.Service.createElement( "tr", { class: hasMatch } );
                    _rule_dom.appendChild( DOM.Service.createElement( "td", { class: "col-icon " + getIconClass( rule.in_state_eval ) }, getIcon( rule.in_state_eval ) ) );
                    _rule_dom.appendChild( DOM.Service.createElement( "td", { class: "col-status" }, rule.in_state ) );
                    _rule_dom.appendChild( DOM.Service.createElement( "td", { class: "col-icon " + getIconClass( rule.pattern_eval ) }, getIcon( rule.pattern_eval ) ) );
                    _rule_dom.appendChild( DOM.Service.createElement( "td", { class: "col-pattern" }, SHINKEN.TOOLS.STRING.cleanXss( rule.pattern ) ) );
                    _rule_dom.appendChild( DOM.Service.createElement( "td", { class: "col-icon" }, '<i class="icon-arrow-right"></i>' ) );
                    _rule_dom.appendChild( DOM.Service.createElement( "td", { class: "col-status-out" }, rule.out_state ) );
                    _table_rules_body.appendChild( _rule_dom );
                }
                
                if ( kl !== 0 ) {
                    _table_rules.appendChild( _table_rules_head );
                    _table_rules.appendChild( _table_rules_body );
                    _block_mod.appendChild( _table_rules );
                }
                else {
                    _block_mod.appendChild( DOM.Service.createElement( "p", { class: "default-property" }, _( 'element.no_mod_rule' ) ) );
                }
            }
            else {
                _tag = DOM.Service.createElement( "span", { class: "shinken-tag-modulation tag-block error " }, _current_modulation.getName() );
                _block_mod.appendChild( _tag );
                _block_mod.appendChild( DOM.Service.createElement( "p", { class: "error-property" }, _( 'element.resultmodulation_missing' ) ) );
            }
            _to_return.appendChild( _block_mod );
        }
        
        $executionContent.appendChild( _to_return );
    };
    var _createMacroEvaluationTable  = function ( macros ) {
        var table_data = DOM.Service.createElement( 'table', { class: 'table-try-check-data-eval table-striped table-bordered' } );
        var thead_data = DOM.Service.createElement( 'thead', { class: 'shinken-macro-eval-table-thead' } );
        
        thead_data.appendChild( DOM.Service.createElement( 'th', { class: 'shinken-macro-eval-table-name' }, _( 'element.name' ) ) );
        thead_data.appendChild( DOM.Service.createElement( 'th', { class: 'shinken-macro-eval-table-raw-value' }, _( 'element.value_to_evaluate' ) ) );
        thead_data.appendChild( DOM.Service.createElement( 'th', { class: 'shinken-macro-eval-table-value' }, _( 'element.expanded_value' ) ) );
        thead_data.appendChild( DOM.Service.createElement( 'th', { class: 'shinken-macro-eval-table-from' }, _( 'element.found_into_type' ) ) );
        table_data.appendChild( thead_data );
        
        var tbody_data                          = DOM.Service.createElement( 'tbody' );
        var _size                               = macros.length;
        var __missing_duplicate_foreach_display = DOM.Service.createElement( 'span', { class: 'missing-evaluated-value' }, _( 'element.missing_dfe' ) );
        var macro;
        var orig_macro;
        var class_to_add;
        var macro_infos;
        var macro_value;
        var raw_value;
        var macro_from_info_translated;
        var new_line;
        var cell_name;
        var cell_value;
        var cell_raw_value;
        var _macro_name;
        for ( var i = 0; i < _size; i++ ) {
            macro       = macros[ i ];
            orig_macro  = macro[ 0 ];
            macro_infos = macro[ 1 ];
            macro_value = macro_infos[ 'value' ];
            raw_value   = macro_infos[ 'raw_value' ];
            
            if ( _containsMacro( raw_value ) ) {
                for ( var j = 0; j < _size; j++ ) {
                    var macro_possible_name = '$' + macros[ j ][ 0 ] + '$';
                    class_to_add            = '';
                    if ( _macroIsEmpty( macros[ j ][ 1 ][ 'raw_value' ] ) ) {
                        class_to_add = 'shinken-macro-is-missing';
                    }
                    raw_value = SHINKEN.TOOLS.STRING.replaceAll( raw_value, macro_possible_name, '<span class="shinken-macro-in-data ' + class_to_add + '">' + macro_possible_name + '</span>' );
                }
            }
            class_to_add = '';
            if ( _macroIsEmpty( raw_value ) ) {
                class_to_add = 'shinken-macro-is-missing';
            }
            _macro_name = orig_macro;
            _macro_name += macro_infos[ 'data_modulation' ] ? '<span class="shinken-macro-data-modulation">' + _( 'element.modulation' ) + '</span>' : '';
            cell_name   = DOM.Service.createElement( 'td', { class: 'shinken-macro-eval-table-name ' + class_to_add }, _macro_name );
            
            cell_raw_value = _getMacroValueTranslated( raw_value, orig_macro, macro_infos, true );
            
            macro_value = macro_value.replace( REGEXS.MISSING_DFE, __missing_duplicate_foreach_display );
            cell_value  = _getMacroValueTranslated( macro_value, orig_macro, macro_infos, false );
            
            macro_from_info_translated = _getMacroFromInfoTranslated( macro_infos.from );
            if ( macro_infos[ 'from_info' ] && macro_infos[ 'from_info' ][ 'uuid' ] ) {
                var _template = MANAGER.__instance_element_distributor.list_templates.getTemplateByUuid( macro_infos[ 'from_info' ][ 'uuid' ] );
                if ( _template ) {
                    macro_from_info_translated += SHINKEN.TOOLS.buildLinkShinkenElement( _template, '', 'shinken-tag-check hide-if-collapse shinken-space' ).outerHTML;
                }
                else {
                    macro_from_info_translated += " " + macro_infos[ 'from_info' ][ 'name' ];
                }
            }
            if ( macro_infos[ 'data_modulation' ] ) {
                var _macro_modulation = MANAGER.__instance_element_distributor.getElementByName( macro_infos[ 'data_modulation' ] );
                var _link             = SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin( _macro_modulation.type, _macro_modulation.uuid, _macro_modulation.macromodulation_name ).outerHTML;
                macro_from_info_translated += _( 'element.modulate_by' ) + ' <span class="shinken-macro-data-modulation">' + _link + '</span>';
            }
            var cell_from = DOM.Service.createElement( 'td', { class: 'shinken-macro-eval-table-from' }, macro_from_info_translated );
            
            new_line = DOM.Service.createElement( 'tr' );
            new_line.appendChild( cell_name );
            new_line.appendChild( cell_raw_value );
            new_line.appendChild( cell_value );
            new_line.appendChild( cell_from );
            tbody_data.appendChild( new_line );
        }
        table_data.appendChild( tbody_data );
        return table_data;
    };
    var _getMacroFromInfoTranslated  = function ( macro_from ) {
        var data;
        switch ( macro_from ) {
            case 'global':
                data = _( 'element.global_data' );
                break;
            case 'host':
                data = _( 'element.local_host_data' );
                break;
            case 'check':
                data = _( 'element.local_check_data' );
                break;
            case 'template':
                data = _( 'element.from_host_template' );
                break;
            case 'argn':
                data = _( 'element.command_argument' );
                break;
            default:
                data = _( 'element.unknown' );
        }
        return data;
    };
    var _getMacroValueTranslated     = function ( value, macro_name, macro_infos, is_raw_value ) {
        var to_return;
        var generic_class = "shinken-macro-eval-table-raw-value";
        var missing_class = generic_class + ' missing-evaluated-value';
        var _class        = generic_class;
        var _tag_label    = is_raw_value ? _( 'element.try_check_before_modulation' ) : _( 'element.try_check_after_modulation' );
        var span_protected_password;
        var _value;
        
        if ( value ) {
            value = value.replace( REGEXS.DOUBLEDOLLAR, '$' );
        }
        switch ( value ) {
            case '__PROTECTED_PASSWORD__':
                _class                  = generic_class;
                span_protected_password = DOM.Service.createElement( 'span', { class: 'shinken-protected-password' }, '(' + _( 'element.password_protected' ) + ')' );
                _value                  = span_protected_password.outerHTML;
                break;
            case '__MISSING_ARGN__':
                _class = missing_class;
                _value = _( 'element.missing_argument' );
                break;
            case '__MISSING_DFE__':
                _class    = missing_class;
                _value    = _( 'element.missing_dfe' );
                to_return = DOM.Service.createElement( 'td', { class: missing_class }, _( 'element.missing_dfe' ) );
                break;
            case '__MISSING_HOST__':
                _class = missing_class;
                _value = SHINKEN.TOOLS.STRING.format( _( 'element.macro_missing_from_host' ), macro_name );
                break;
            case '__MISSING_CHECK__':
                _class = missing_class;
                _value = SHINKEN.TOOLS.STRING.format( _( 'element.macro_missing_from_check' ), macro_name );
                break;
            case '__MISSING_GLOBAL__':
                _class = missing_class;
                _value = _( 'element.macro_missing_global' );
                break;
            case '__NOT_IMPLEMENTED__':
                _class = missing_class;
                _value = _( 'element.macro_not_implemented' );
                break;
            case null:
            case 'null':
                _class = missing_class;
                _value = _( 'element.missing_value' );
                break;
            default:
                if ( SHINKEN.TOOLS.STRING.contains( value, '__PROTECTED_PASSWORD__' ) ) {
                    span_protected_password = DOM.Service.createElement( 'span', { class: 'shinken-protected-password' }, '(' + _( 'element.password_protected' ) + ')' );
                    _value                  = SHINKEN.TOOLS.STRING.replaceAll( value, '__PROTECTED_PASSWORD__', span_protected_password.outerHTML );
                }
                else {
                    _value = value;
                }
                _class = generic_class;
                break;
        }
        to_return           = DOM.Service.createElement( 'td', { class: _class } );
        to_return.innerHTML = macro_infos[ 'data_modulation' ] ? "<span class='shinken-tag-before-after-data-modulated'>" + _tag_label + "</span>" + _value : _value;
        return to_return;
    };
    var _containsMacro               = function ( value ) {
        if ( value && value.indexOf( '$' ) !== -1 ) {
            return true;
        }
        return false;
    };
    var _macroIsEmpty                = function ( marco_value ) {
        var is_empty = false;
        switch ( marco_value ) {
            case 'null':
            case '__MISSING_ARGN__':
            case '__MISSING_GLOBAL__':
            case '__MISSING_DFE__':
            case '__MISSING_HOST__':
            case '__MISSING_CHECK__':
            case '__NOT_IMPLEMENTED__':
                is_empty = true;
                break;
        }
        return is_empty;
        
    };
    var _create_raw_command_line     = function ( command_line, macros ) {
        command_line = SHINKEN.TOOLS.STRING.cleanXss( command_line );
        var _size = macros.length;
        var replace_by;
        var macro_name;
        for ( var i = 0; i < _size; i++ ) {
            if ( _macroIsEmpty( macros[ i ][ 1 ].raw_value ) ) {
                macro_name   = '$' + macros[ i ][ 0 ] + '$';
                replace_by   = '<span class="missing-evaluated-value">$' + macro_name + '$</span>';
                command_line = command_line.replace( macro_name, replace_by );
            }
        }
        return '<div class="code"><p>' + command_line + '</p></div>';
    };
    var drawExecutionTable           = function ( result, stdout, shell, time, output, long_output, perf_data, extra_class ) {
        var __ret   = getContextById( result );
        var rStatus = __ret.rStatus;
        var rLabel  = __ret.rLabel;
        
        var _formatted_stdout = stdout;
        if ( output ) {
            _formatted_stdout = '<div class="shinken-output-frame shinken-output-short"><div class="shinken-title">' + _( 'element.result' ) + '</div><div class="shinken-content-try-check">' + output + '</div></div>';
        }
        
        if ( long_output ) {
            _formatted_stdout = _formatted_stdout + '<div class="shinken-output-frame shinken-output-long"><div class="shinken-title">' + _( 'element.long_result' ) + '</div><div class="shinken-content-try-check">' + long_output + '</div></div>';
        }
        if ( perf_data.trim()[ 0 ] === '|' ) {
            _formatted_stdout = _formatted_stdout + getPerformanceRowHtml(perf_data.trim().substr( 1 ));
        }
        
        var $tableExecution = $( '<table class="table-execution table-hover table-striped table-bordered ' + extra_class + '" style="width: 100%;">' );
        var $theadExecution = $( '<thead style="background-color: #C2C2C2;">' +
                                 '<th class="col-result word-break-keep-all">' + _( 'element.status' ) + '</th>' +
                                 '<th class="col-output word-break-keep-all">' + _( 'element.result' ) + '</th>' +
                                 '<th class="col-shell word-break-keep-all">' + _( 'element.with_shell' ) + '</th>' +
                                 '<th class="col-time word-break-keep-all">' + _( 'element.execution_time' ) + '</th>' +
                                 '</thead>' );
        var $tbodyExecution = $( '<tbody>' +
                                 '<tr>' +
                                 '<td class="col-result"></td>' +
                                 '<td class="col-output cell-iFrame" ><div class="shinken-container">' + _formatted_stdout + '</div></td>' +
                                 '<td class="col-shell">' + shell + '</td>' +
                                 '<td class="col-time">' + time + '</td>' +
                                 '</tr>' +
                                 '</body>' );
        $tbodyExecution.find( ".col-result" ).append( App.Scope.Tags.create( rLabel, { context: rStatus } ).get( 0 ) );
        $tableExecution.append( $theadExecution ).append( $tbodyExecution );
        return $tableExecution;
    };
    var getPerformanceRowHtml = function ( perf_data ) {
        var _value_to_split = perf_data;
        var _to_return      = "";
        
        var _messages    = new OBJECT.Messages();
        var _index_comma = SHINKEN.TOOLS.STRING.indexesOf( _value_to_split, "," );
        if ( _index_comma.length ) {
            _messages.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'validator_js.perf_data.no_comma' ) );
            _value_to_split = SHINKEN.TOOLS.STRING.replaceAll( _value_to_split, ",", "" );
        }
        var _index_quotes = SHINKEN.TOOLS.STRING.indexesOf( _value_to_split, "'" );
        var _splitted_metrics = [];
        if ( _index_quotes.length % 2 ) {
            _messages.addMessage( COMPONENT.CONST.STATUS.ERROR, _( 'validator_js.perf_data.nb_quotes_odd' ) );
        }
        else {
            var _indexes_spaces   = SHINKEN.TOOLS.STRING.indexesOfNotBetween( _value_to_split, " ", _index_quotes );
            var _perf_metrics_row = SHINKEN.TOOLS.STRING.splitWithIndexes( _value_to_split, _indexes_spaces, 1 );
            var _current;
            for ( var i = 0, _size_i = _perf_metrics_row.length; i < _size_i; i++ ) {
                _current = _perf_metrics_row[ i ];
                if ( SHINKEN.TOOLS.STRING.isEmpty( _current ) ) {
                    continue;
                }
                var _current_quotes = SHINKEN.TOOLS.STRING.indexesOf( _current, "'" );
                var _index_equals = SHINKEN.TOOLS.STRING.indexesOfNotBetween( _current, "=", _current_quotes );
                if ( _index_equals.length === 0 ){
                    _messages.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format(_( 'validator_js.perf_data.nb_equals_missing' ), _current ));
                    continue;
                }
                else if ( _index_equals.length !== 1 ){
                    _messages.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format(_( 'validator_js.perf_data.nb_equals_unique' ), _current ));
                    continue;
                }
                var splited_equals = SHINKEN.TOOLS.STRING.splitWithIndexes( _current, _index_equals );
                var _current_name = "";
                if ( _current_quotes.length ){
                    _current_name = _current.substring(_current_quotes[0] + 1, _current_quotes[_current_quotes.length-1]);
                } else {
                    _current_name = splited_equals[0];
                }
                var _split_semi_colon = splited_equals[ 1 ].split( ';' );
                if ( _split_semi_colon.length > 5){
                    _messages.addMessage( COMPONENT.CONST.STATUS.ERROR, SHINKEN.TOOLS.STRING.format(_( 'validator_js.perf_data.too_much_data' ), _current ));
                }
                _splitted_metrics.push(SHINKEN.TOOLS.ARRAY.concat([_current_name], _split_semi_colon ))
            }
            
        }
        if ( !_messages.hasMessage() ) {
            _to_return += "<div class='shinken-output-frame shinken-metric-html'><div class='shinken-title'>" + _( 'element.metrics' ) + "</div><div class='shinken-content-try-check'><table class='shinken-metrics-table'>";
            _to_return += "<tr><th>" + _( 'element.metric' ) + "</th><th>" + _( 'element.value' ) + "</th><th>" + _( 'element.warning_threshold' ) + "</th><th>" + _( 'element.critical_threshold' ) + "</th></tr>";
            for ( var _metric_index = 0; _metric_index < _splitted_metrics.length; _metric_index++ ) {
                _to_return += "<tr><td class='metric-name'>" + _splitted_metrics[ _metric_index ][ 0 ] + "</td>";
                _to_return += "<td class='metric-value'>" + _splitted_metrics[ _metric_index ][ 1 ] + "</td>";
                _to_return += "<td class='metric-value'>" + (_splitted_metrics[ _metric_index][ 2 ] || "");
                _to_return += "<td class='metric-value'>" + (_splitted_metrics[ _metric_index ][ 3 ] || "");
                _to_return += "</tr>";
            }
            _to_return += "</table></div></div>";
        }
        _to_return += "<div class='shinken-output-frame shinken-metric-flat'><div class='shinken-title'>" + _( 'element.raw_metrics' ) + "</div><div class='shinken-content-try-check shinken-div-inline-block'>" + perf_data + "</div>";
        if ( _messages.hasMessage() ) {
            _to_return += _messages.buildMessage();
        }
        _to_return += "</div>";
        return _to_return;
    };
    var getContextById               = function ( id ) {
        var rStatus = 'unknown',
            rLabel  = _( 'element.unknown' );
        if ( id == 0 ) {
            rStatus = 'success';
            rLabel  = _( 'element.ok' );
        }
        else if ( id == 1 ) {
            rStatus = 'warning';
            rLabel  = _( 'element.warning' );
        }
        else if ( id == 2 ) {
            rStatus = 'error';
            rLabel  = _( 'element.critical' );
        }
        return { rStatus: rStatus, rLabel: rLabel };
    };
    var getIcon                      = function ( value ) {
        return (value == true || value == 'true') ? '<i class="icon-ok"></i>' : (value == false || value == 'false') ? '<i class="icon-remove"></i>' : '-';
    };
    var getIconClass                 = function ( value ) {
        return (value == true || value == 'true') ? 'success' : (value == false || value == 'false') ? 'error' : 'default';
    };
    var changeNbStatusToLabel        = function ( statusNbr ) {
        return (statusNbr.length === 0) ? _( 'element.any_status' ) : getContextById( statusNbr ).rLabel;
    };
    return self;
})
( SHINKEN.TRY_CHECK || {} );

