'use strict';

WINDOW.DataGroups           = function ( dom_element, type ) {
    //current_element
    //dom_element
    //contents
    //data_mapping
    this.type = type;
    this.init( dom_element );
};
WINDOW.DataGroups.prototype = {
    init                 : function ( dom_element ) {
        this.dom_element = dom_element;
        this.initDataGroup( this.dom_element.querySelectorAll( '.shinken-data-group' ) );
    },
    initDataGroup        : function ( dom_elements ) {
        this.contents     = [];
        this.data_mapping = {};
        var _to_add;
        var _uuid;
        for ( var i = 0, _size_i = dom_elements.length; i < _size_i; i++ ) {
            _uuid   = dom_elements[ i ].dataset.uuid;
            _to_add = new WINDOW.DataGroup( this.type, '', dom_elements[ i ], this );
            _to_add.setUUID( _uuid );
            _to_add.computeLabel();
            _to_add.computeDataList();
            this.data_mapping[ _uuid ] = i;
            if ( _to_add.is_active ) {
                this.setCurrent( _to_add );
            }
            this.contents[ i ] = _to_add;
        }
    },
    clickOnRadioBtn      : function ( event ) {
        var _parent_dom_element = DOM.Service.findParentElementWithDataSet( event.target, 'uuid', 10 );
        var _uuid               = _parent_dom_element.dataset.uuid;
        var _target             = this.getElementByID( _uuid );
        CONTROLLER.MassChange.filterListData( _target );
        this.setCurrent( _target );
    },
    getElementByID       : function ( uuid ) {
        return this.contents[ this.data_mapping[ uuid ] ];
    },
    setCurrent           : function ( to_set ) {
        if ( this.current_element ) {
            this.current_element.setActive( false );
        }
        this.current_element = to_set;
        this.current_element.setActive( true );
    },
    addData              : function ( uuid ) {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].addData( uuid );
        }
    },
    removeData           : function ( uuid ) {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].removeData( uuid );
        }
    },
    updateDataUserCounter: function ( uuid, value ) {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].updateDataUserCounter( uuid, value );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.DataGroups, SHINKEN.OBJECT.CounterInterface );


WINDOW.DataGroup           = function ( type, label, dom_element, parent, uuid ) {
    //dom_element;
    //dom_element_warning;
    this.dom_element = dom_element;
    this.type        = type;
    this.label       = label;
    this.group_name  = label ? label : type;
    this.uuid        = SHINKEN.TOOLS.STRING.buildUUID();
    this.initCounters( parent || MANAGER.__instance_window_distributor.findWindow( WINDOW.CONST.ELEMENT.DATAS, false, MANAGER.__instance_element_distributor.current_element.uuid ) );
    if ( this.dom_element ) {
        this.is_active = this.dom_element.classList.contains( "shinken-active" );
    }
};
WINDOW.DataGroup.prototype = {
    updateDataUserCounter: function ( uuid, value ) {
        if ( SHINKEN.TOOLS.ARRAY.contains( this.data_list, uuid ) ) {
            this.setUserSet( uuid, value );
        }
    },
    addData              : function ( uuid ) {
        switch ( this.uuid ) {
            case CONTROLLER.CONST.MASS_CHANGE.GROUP_DATA.ALL:
            case CONTROLLER.CONST.MASS_CHANGE.GROUP_DATA.LOCAL:
                this.data_list.push( uuid );
                this.setTotal( uuid, 1 );
                break;
        }
    },
    removeData           : function ( uuid ) {
        switch ( this.uuid ) {
            case CONTROLLER.CONST.MASS_CHANGE.GROUP_DATA.ALL:
            case CONTROLLER.CONST.MASS_CHANGE.GROUP_DATA.LOCAL:
                this.setTotal( uuid, 0 );
                this.setUserSet( uuid, 0 );
                SHINKEN.TOOLS.ARRAY.removeElement( this.data_list, uuid );
                break;
        }
    },
    getDataList          : function () {
        if ( this.uuid === CONTROLLER.CONST.MASS_CHANGE.GROUP_DATA.ALL ) {
            return "";
        }
        return this.data_list.join( ',' );
    },
    setUUID              : function ( to_set ) {
        this.uuid = to_set;
        switch ( this.uuid ) {
            case CONTROLLER.CONST.MASS_CHANGE.GROUP_DATA.ALL:
            case CONTROLLER.CONST.MASS_CHANGE.GROUP_DATA.LOCAL:
                this.getCounterTotal()._askUpdateHTML();
                break;
        }
    },
    getUUID              : function () {
        return this.uuid;
    },
    setActive            : function ( to_set ) {
        this.is_active = to_set;
        if ( this.is_active ) {
            this.dom_element.classList.add( "shinken-active" );
        }
        else {
            this.dom_element.classList.remove( "shinken-active" );
        }
    },
    computeLabel         : function () {
        this.label = this.dom_element.dataset.paneName;
    },
    
    computeDataList  : function () {
        this.data_list = JSON.parse( this.dom_element.dataset.dataList );
        for ( var i = 0, _size_i = this.data_list.length; i < _size_i; i++ ) {
            this.setTotal( this.data_list[ i ], 1 );
        }
    },
    /////////////////////////////////////////////// PROPERTY DATA EDITION ELEMENT  /////////////////////////////////////
    _build_title_name: function () {
        if ( this.label ) {
            return this.label;
        }
        return _( 'element.local_element' );
    },
    _build_class_nav : function () {
        var _to_return = "shinken-data-nav-container";
        if ( this.type === PROPERTY.CONST.DATA.GROUP.LOCALE ) {
            _to_return += " shinken-active";
        }
        return _to_return;
    },
    buildHTMLNav     : function () {
        var _title_name              = this._build_title_name();
        this.dom_element             = DOM.Service.createElement( "li", { class: this._build_class_nav() } );
        var _to_add_a                = DOM.Service.createElement( "div", {
            class: "shinken-data-nav-link",
            "data-type": this.type,
            "onclick": "MANAGER.EventManager.clickOnDataNavigation('" + this.uuid + "')",
            "data-name": _title_name + "-" + this.type
        } );
        var _to_add_error            = DOM.Service.createElement( "span", {
            class: "shinken-error-counter shinken-counter shinken-counter-label", title: _( 'element.title_panel_errors' ), 'data-number': ''
        }, '<span class="shinken-counter-label"></span>' );
        var _to_add_warning          = DOM.Service.createElement( "span", {
            class: "shinken-warning-counter shinken-counter shinken-counter-label", title: _( 'element.title_panel_warnings' ), 'data-number': ''
        }, '<span class="shinken-counter-label"></span>' );
        var _to_add_user_set_counter = DOM.Service.createElement( "span", { class: "shinken-user-counter-container shinken-counter shinken-user-set-counter", 'data-number': '' }, '<span class="shinken-counter-label"></span>' );
        
        var _to_add_total = DOM.Service.createElement( "span", { class: "shinken-window-total-counter shinken-counter", 'data-number': '0', 'data-show-if-null' : '1' }, '<span class="shinken-counter-label">0</span>' );
        var _title        = DOM.Service.createElement( "span", { class: "shinken-label" }, _title_name );
        var _brackets     = DOM.Service.createElement( "span", { class: "shinken-between-bracket" } );
        _brackets.appendChild( _to_add_user_set_counter );
        _brackets.appendChild( _to_add_total );
        var _to_counter_ele = DOM.Service.createElement( "span", { class: "shinken-data-nav-bar-counter" } );
        _to_counter_ele.appendChild( _brackets );
        
        _to_add_a.appendChild( _to_add_error );
        _to_add_a.appendChild( _to_add_warning );
        _to_add_a.appendChild( _title );
        _to_add_a.appendChild( _to_counter_ele );
        
        this.dom_element.appendChild( _to_add_a );
        return this.dom_element;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.DataGroup, SHINKEN.OBJECT.CounterInterface );