%import re
%from ...dao.def_items import ITEM_TYPE, DEF_ITEMS

%if 'is_new_object' not in locals():
    %is_new_object=False
%end

%if 'working_area' not in locals():
    %working_area=False
%end

%title="%s %s" % (app._('type.%s'%item_type), item.get(DEF_ITEMS[item_type]['key_name'], app._('element.unknown')))
%rebase( "elements_base", title=title,  css=['elements/css/jquery-ui.css', 'elements/css/elements.css'], js=[])

%presence_protection = item.get('presence_protection', '0') == '1'

%# is the element globaly editable or just the name that is restricted
%is_disabled = item.get('editable', '1') == '0'
%is_disabled_name = True if is_disabled or presence_protection else False

%is_admin = user.is_admin()
%group_not_editable = True if is_disabled or not is_admin else False

%display_changes = is_admin and changes

%list_tab_for_element = ['generic','datas']
%if is_admin:
    %list_tab_for_element.append('authorization')
%end
%list_tab_for_element.append('direct')
%if display_changes:
    %list_tab_for_element.append('changes')
%end

%selected_tab = app.request.GET.get('tab', 'generic')
%if selected_tab not in list_tab_for_element :
    %selected_tab = list_tab_for_element[0]
%end
<script>
    var shinken_link_tpl = '{{ITEM_TYPE.CONTACTTPLS}}';
    var is_tag_exist = [];

    %for use in item.get("use", "" ).split(','):
        is_tag_exist["{{use}}"] = {{"true" if app.is_tag_exist(use) else "false"}};
    %end

</script>

%if working_area:
    %data_redir = 'working_area/' + item_type
%elif is_tpl:
    %data_redir = 'contacttpls'
%else:
    %data_redir = 'contacts'
%end

%admin_hide= '' if is_admin else 'hide'
%have_changes = (is_admin and changes)

<div id="left-column" data-type={{item_type}}>
    %include( "__print_element_left_buttons",pending=pending, is_disabled=is_disabled, data_redir=data_redir, changes=display_changes, is_new_object=is_new_object, presence_protection=presence_protection, app=app)
    %include( "__print_right_help_bloc",changes=display_changes, app=app)
</div>


<div id="right-column">
    %include( "__print_saving_log")
    <div id="loading_page"></div>
    <div class="container_host_info shinken-container-host-info">
        %include( "__print_top_title_item" )
        %include( "edition_element_form/%s" % item_type )
    </div>
</div>


