%placeholder = app._("mass-change.place_holder_no_filter")
<div id="id-shinken-mass-change-list" class="shinken-list-container">
    <table class="shinken-width-100 shinken-mass-change-checks-table ">
        <thead>
        <tr class="shinken-mass-change-header shinken-parent-target-click shinken-header-line">
            <td class="shinken-list-header shinken-check-box-cell shinken-check-box-cell-with-setter"></td>
            <th class="shinken-list-header shinken-parent-name-cell">{{!app._('mass-change.step-2.table-checks.headers.parent_name')}}</th>
            <th class="shinken-list-header shinken-service-name-cell">{{!app._('mass-change.step-2.table-checks.headers.service_name')}}</th>
            <th class="shinken-list-header shinken-dfe-key-cell">{{!app._('mass-change.step-2.table-checks.headers.dfe_key')}}</th>
            <th class="shinken-list-header shinken-action-cell">{{!app._('mass-change.step-2.table-checks.headers.action')}}</th>
        </tr>
        <tr class="shinken-mass-change-filter shinken-filter-line" >
            %if type_modification == MASSIVE_CHANGE_TYPE.EXCLUDES:
                {{!helper_object.get_check_box_buttons_cell_html('shinken-all-elements',class_to_add='mass-change-list shinken-check-box-cell-with-setter', label_button_off=app._('mass-change.step-2.service_exclude.change_all'), label_button_on=app._('mass-change.step-2.service_exclude.back_to_past'))}}
            %else:
                {{!helper_object.get_check_box_cell_html(0,-1,'shinken-all-elements', class_to_add='mass-change-list shinken-all-elements-check-box shinken-check-box-cell-with-setter')}}
            %end

            <td class="shinken-list-filter shinken-parent-name-cell" data-name="parent_name" data-object-type="shinken-list-filter"  data-type="input_string">{{!helper.helper_component.get_input_html('input', '', placeholder=placeholder)}}</td>
            <td class="shinken-list-filter shinken-service-name-cell" data-name="service_name" data-object-type="shinken-list-filter"  data-type="input_string">{{!helper.helper_component.get_input_html('input', '', placeholder=placeholder)}}</td>
            <td class="shinken-list-filter shinken-dfe-key-cell" data-name="dfe_key" data-object-type="shinken-list-filter"  data-type="input_string">{{!helper.helper_component.get_input_html('input', '', placeholder=placeholder)}}</td>
            {{!helper.mass_change_helper.get_cell_mass_change_action_filter_html(step)}}
        </tr>
        </thead>
        <tbody>
        %for check in massive_change_step_2_checks:
            %extra_class = ''
            %original_selection = '0'
            %if type_modification == MASSIVE_CHANGE_TYPE.EXCLUDES:
                %selected = 'shinken-selected-original' if check['is_exclude']  else ''
                %future_by_id = app._('mass-change.step-2.service_exclude.not_exclude_by_id_future') if selected else app._('mass-change.step-2.service_exclude.exclude_by_id_future')
                %current_by_id = app._('mass-change.step-2.service_exclude.exclude_by_id_past') if selected else ''
                %off_label = app._('mass-change.step-2.service_exclude.remove_exclude') if selected else app._('mass-change.step-2.service_exclude.add_exclude')
                %on_label = app._('mass-change.step-2.service_exclude.add_exclude') if selected else app._('mass-change.step-2.service_exclude.remove_exclude')
                %extra_class = 'shinken-selected-disabled' if check['dfe_key'] else ''
                %original_selection = '1' if selected else '0'
            %end
            %uuid = "%s%s" % (check['uuid'], check['dfe_key'])
            <tr class="shinken-mass-change-data shinken-parent-target-click shinken-list-line {{extra_class}}"
                data-type-check="{{check['service_type']}}"
                data-type-parent="{{check['parent_type']}}"
                data-uuid-item="{{check['item_id']}}"
                data-type-item="{{check['item_type']}}"
                data-uuid-parent="{{check['parent_id']}}"
                data-uuid-check="{{check['service_id']}}"
                data-dfe-key="{{check['dfe_key']}}"
                data-exclude-by-name="0"
                data-original-selected="{{original_selection}}"
                data-uuid="{{uuid}}">
                %if type_modification == MASSIVE_CHANGE_TYPE.EXCLUDES:
                    %if check['dfe_key']:
                        <td>
                            <div class="shinken-check-tag shinken-check-exclude-tag shinken-not-exclude-dfe"
                                 onmouseenter="SHINKEN_TOOLTIP.showTooltip(this)"
                                 onmouseleave="SHINKEN_TOOLTIP.hideTooltip()"
                                 shi-tip-placement="left"
                                 shi-tip-html="{{app._('element.check_exclude_tooltip-dfe')}}">
                                <div class="shinken-label-exclude">
                                    <span class="shinken-label">{{!app._('element.to_exclude_dfe')}}</span>
                                </div>
                            </div>
                        </td>
                    %else:
                        {{!helper_object.get_check_box_buttons_cell_html(uuid,class_to_add='mass-change-list shinken-check-box-cell-with-setter', label_button_off=off_label, label_button_on=on_label)}}
                    %end
                %else:
                    {{!helper_object.get_check_box_cell_html(0,-1,uuid,class_to_add='mass-change-list shinken-check-box-cell-with-setter')}}
                %end
                <td class="shinken-list-cell shinken-parent-name-cell" data-filter="parent_name">{{!helper_object.build_link_dom_element_depend_if_admin(check['item_type'],check['item_id'],check['item_name'])}}</td>
                <td class="shinken-list-cell shinken-service-name-cell" data-filter="service_name">{{!helper_object.build_link_dom_element_depend_if_admin(check['service_type'],check['service_id'],check['service_name'])}}</td>
                <td class="shinken-list-cell shinken-dfe-key-cell" data-filter="dfe_key">{{!check['dfe_key']}}</td>
                %if type_modification == MASSIVE_CHANGE_TYPE.EXCLUDES:
                    <td class="shinken-list-cell shinken-action-cell {{selected}}" data-filter="action" data-filter-value="">
                        <div class="shinken-exclude-by-id" data-type="exclude-in-future">{{future_by_id}}</div>
                        <div class="shinken-exclude-by-id" data-type="exclude-in-past">{{current_by_id}}</div>
                        <div class="shinken-exclude-by-name">{{app._('mass-change.step-2.service_exclude.exclude_by_name')}}</div>
                    </td>
                %end
            </tr>
        %end
        </tbody>
    </table>
</div>

