#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.
from shinken.misc.type_hint import NoReturn


class OPTIONS_CONSTANT(object):
    SHINKEN_ELEMENT = "shinken-element"
    SHINKEN_INHERITANCE_OPTION = "shinken-inheritance-option"
    SHINKEN_NO_CHANGE = "__NO_CHANGE__"
    SHINKEN_DEFAULT_LABEL = "__DEFAULT_LABEL__"
    SHINKEN_IS_ALWAYS_VISIBLE = "shinken-is-always-visible-option"


class OptionSelectComp(object):
    def __init__(self, group, value, option_type, label=''):
        # type: (str, str, str, str)-> NoReturn
        self._group = group
        self._value = value
        self._id = "%s__%s" % (self._group, self._value)
        self._label = label or self._value
        self._text = self._label
        self._parents = []
        self._extra_class = ''
        self._type = option_type
    
    
    # *****************************   GETTER SETTER  ************************************************************#
    def get_value(self):
        return self._value
    
    
    def set_text(self, to_set):
        self._text = to_set
    
    
    def set_label(self, to_set):
        self._label = to_set
    
    
    def get_label(self):
        return self._label
    
    
    def get_id(self):
        return self._id
    
    
    def add_parent(self, to_add):
        self._parents.append(to_add)
    
    
    def set_extra_class(self, to_set):
        # type: (str)-> NoReturn
        self._extra_class = to_set
    
    
    def is_shinken_element_option(self):
        # type: ()-> bool
        if self._type == OPTIONS_CONSTANT.SHINKEN_ELEMENT:
            return True
        return False
    
    
    # *****************************   HTML  ************************************************************#
    def get_html(self, class_to_add=""):
        _data_list = 'data-parents="%s"' % ','.join(self._parents) if len(self._parents) else ''
        
        _to_return = '<div class="shinken-option %s %s"' \
                     ' data-group="%s"' \
                     ' data-key-name="%s"' \
                     ' data-key-label="%s"' \
                     ' data-type="%s"' \
                     ' %s ' \
                     ' onmouseenter="MANAGER.EventManager.mouseEnter(event)"' \
                     ' onclick="MANAGER.EventManager.clickOnItemSelector(event, this)" >' \
                     '<div class="shinken-selector-label shinken-space">%s</div>' \
                     '</div>' \
                     % (
                         class_to_add,
                         self._extra_class,
                         self._group,
                         self._value,
                         self._label,
                         self._type,
                         _data_list,
                         self._text
                     )
        return _to_return
