%value = item.get(name, '')
%if 'placeholder' not in locals():
    %placeholder=''
%end
%if 'is_required' not in locals():
    %is_required=''
%end
%if 'type_input' not in locals():
    %type_input='text'
%end
%if 'is_text_area' not in locals():
    %is_text_area=False
%end
<tr onmouseenter="MANAGER.EventManager.mouseEnter(this)"
    onmouseleave="MANAGER.EventManager.mouseLeave(this)"
    class="shinken-element-property-line"
    data-type="input_string"
    data-is-required="{{is_required}}"
    data-name="{{name}}"
    data-state="user-set"
    data-state-input=""
    data-is-protected="0">
    <td class="shinken-prop-cell-label">
        <div class="shinken-div-inline-block">
            <table>
                <tbody>
                <tr>
                    <td class="shinken-property-label">
                        <span class="shinken-counter shinken-error-counter" data-number="">
                            <span class="shinken-counter-label"></span>
                        </span>
                        <span class="shinken-counter shinken-warning-counter" data-number="">
                            <span class="shinken-counter-label"></span>
                        </span>
                        <span>{{label}}
                            %if is_required:
                                <span style="color:red">*</span>
                            %end
                        </span>
                    </td>
                </tr>
                <tr>
                    <td>
                        <span class="shinken-information-tag"
                              onmouseenter="SHINKEN_TOOLTIP.showTooltip(this)"
                              onmouseleave="SHINKEN_TOOLTIP.hideTooltip()"
                              shi-tip-html="">
                            <span class="shinken-label-information"></span>
                            <span class="shinken-tag-mark">?</span>
                        </span>
                    </td>
                </tr>
                </tbody>
            </table>
        </div>
        <span class="shinken-tag-help" onclick="MANAGER.EventManager.clickOnForcedHelpButton(event,this)">?</span></td>
    <td class="shinken-prop-cell-action">
        <table class="shinken-width-100">
            <tbody>
            <tr>
                <td class="shinken-input-container-cell">
                    %if is_text_area:
                    <textarea rows="5" cols="80"
                              class="shinken-input"
                              data-name="{{name}}"
                              data-type="string"
                              type="{{type_input}}"
                              value="{{value}}"
                              placeholder="{{placeholder}}"
                              data-status="shinken-no-status"
                              onmouseenter="SHINKEN_TOOLTIP.showTooltip(this)"
                              onmouseleave="SHINKEN_TOOLTIP.hideTooltip()"
                              shi-tip-type="shinken-success-border"
                              shi-tip-text="">
                    </textarea>
                    %else:
                    <input class="shinken-input shinken-input-readonly"
                           type="{{type_input}}"
                           value="{{value}}"
                           placeholder="{{placeholder}}"
                           data-status="shinken-no-status"
                           onmouseenter="SHINKEN_TOOLTIP.showTooltip(this)"
                           onmouseleave="SHINKEN_TOOLTIP.hideTooltip()"
                           shi-tip-type="shinken-success-border"
                           shi-tip-text=""
                           readonly>
                    %end
                </td>
            </tr>
            </tbody>
        </table>
    </td>
</tr>