%from datetime import datetime
%from shinken.log import PartLogger

<!--<meta http-equiv="refresh" content="2"/>-->

<style>
    table, th, td {
        border : 1px solid black;
    }
    .shinken-debug {
        max-height : 60px !important;
        height     : 60px !important;
        overflow   : hidden;
    }
</style>

<h1>Generate at {{ datetime.now().strftime('%H:%M:%S %d-%m-%Y') }} </h1>

<h2>
    Pagination info page_index:[{{page_index}}] page_size:[{{page_size}}] <br>
    <a href="/event-container-debug"> go live </a> <br>
    <a href="/event-container-debug?range=page_size:5"> go live page size 5</a> <br>
</h2>
<h2>
    %if page_index:
    <a href="/event-container-debug?range=first_ordering_uuid:{{first_ordering_uuid}}~page_size:{{page_size}}~page:{{page_index-1}}"> &lt; prev </a>
    %end
    - [{{page_index}}] -
    %if have_next:
    <a href="/event-container-debug?range=first_ordering_uuid:{{first_ordering_uuid}}~page_size:{{page_size}}~page:{{page_index+1}}"> next &gt; </a>
    %end
</h2>

first_ordering_uuid:[{{first_ordering_uuid}}] <br>

<table>
    <tr>
        <td>i</td>
        <td>ordering_uuid</td>
        <td>event_uuid</td>
        <td>since</td>
        <td>item_uuid</td>
        <td>host_name</td>
        <td>service_description</td>
        <td>context</td>
        <td>status</td>
        <td>type</td>
        <td>is_status_confirmed</td>
        <td>hard_since</td>
        <td>active_downtime_uuids</td>
        <td>output</td>
        <td>long_output</td>
        <td>realm</td>
    </tr>
    %for i, d in enumerate(data):
    <tr>
        <td>
            <div class="shinken-debug">{{i+1}}</div>
        </td>
        <td>
            <div class="shinken-debug">{{d['ordering_uuid']}}</div>
        </td>
        <td>
            <div class="shinken-debug">{{d['event_uuid']}}</div>
        </td>
        <td>
            <div class="shinken-debug">{{PartLogger.format_time(d['event_since'])}}</div>
        </td>
        <td>
            <div class="shinken-debug">{{d['item_uuid']}}</div>
        </td>
        <td>
            <div class="shinken-debug">{{d['host_name']}}</div>
        </td>
        <td>
            <div class="shinken-debug">{{d.get('service_description','')}}</div>
        </td>
        <td>
            <div class="shinken-debug">{{d['context']}}</div>
        </td>
        <td>
            <div class="shinken-debug">{{d['status']}}</div>
        </td>
        <td>
            <div class="shinken-debug">{{d['type']}}</div>
        </td>
        <td>
            <div class="shinken-debug">{{d['is_status_confirmed']}}</div>
        </td>
        <td>
            <div class="shinken-debug">{{PartLogger.format_time(d['event_hard_since'])}}</div>
        </td>
        <td>
            <div class="shinken-debug">{{d['active_downtime_uuids']}}</div>
        </td>
        <td>
            <div class="shinken-debug">{{!d['output']}}</div>
        </td>
        <td>
            <div class="shinken-debug">{{!d['long_output']}}</div>
        </td>
        <td>
            <div class="shinken-debug">{{d['realm']}}</div>
        </td>
    </tr>
    %end
</table>

