DETAIL_GRAPH.Check = function ( dom_element, host_uuid, host_name ) {
    //dom_element
    //host_uuid
    //host_name
    //mapping_metrics
    this.mapping_metrics = {};
    this.init( dom_element, host_uuid, host_name );
};

DETAIL_GRAPH.Check.prototype = {
    init                 : function ( dom_element, host_uuid, host_name ) {
        this.dom_element = dom_element;
        this.host_uuid   = host_uuid;
        this.host_name   = host_name;
        this.name        = this.dom_element.dataset.checkName;
        this.uuid        = this.dom_element.dataset.checkUuid;
        this._id         = this.dom_element.dataset.checkId;
        this.has_metrics = !this.dom_element.classList.contains( 'shinken-not-has-metrics' );
        this.initMetrics();
    },
    initMetrics          : function () {
        var _metric_lines = this.dom_element.querySelectorAll( '.shinken-metric-line' );
        var _current;
        var data          = {
            'uuid_host'          : this.host_uuid,
            'host_name'          : this.host_name,
            'service_description': this.name
        };
        for ( var i = 0, _size = _metric_lines.length; i < _size; i++ ) {
            _current = new SHINKEN_METRIC.Object();
            _current.initWithDomElement( _metric_lines[ i ], data );
            _current.initThresholds( this.dom_element );
            this.mapping_metrics[ _current.getMetricId() ] = _current;
        }
    },
    //********************************************  EVENT LISTENER  **************************************************//
    addCheckDetail       : function () {
        this.dom_element.classList.add( 'active-metrics-line' );
    },
    removeCheckDetail    : function () {
        remove_check( this.host_name, this.name );
        this.dom_element.classList.remove( 'active-metrics-line' );
        this.cleanMetricSelection();
    },
    removeMetricDetail   : function ( metric_id ) {
        this.getMetric( metric_id ).removeMetricDetail();
    },
    addMetricDetail      : function ( metric_id ) {
        this.getMetric( metric_id ).addMetricDetail( this.uuid );
    },
    addThresholdDetail   : function ( metric_id, threshold_type ) {
        this.getMetric( metric_id ).addThresholdDetail( this.uuid, threshold_type );
    },
    removeThresholdDetail: function ( metric_id, threshold_type ) {
        this.getMetric( metric_id ).removeThresholdDetail( threshold_type );
    },
    addSelectedMetric    : function ( selected_metric ) {
        var _metric = this.getMetricByName( selected_metric.metric );
        if ( !_metric ) {
            return;
        }
        if ( selected_metric.threshold_type ) {
            _metric.addThresholdDetail( this.uuid, selected_metric.threshold_type );
        }
        else {
            _metric.addMetricDetail( this.uuid );
        }
    },
    reInit               : function () {
        var _keys = Object.keys( this.mapping_metrics );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.mapping_metrics[ _keys[ i ] ].reInit();
        }
    },
    //********************************************  SETTER GETTER   **************************************************//
    getName              : function () {
        return this.name;
    },
    getID                : function () {
        return this._id;
    },
    getUuid              : function () {
        return this.uuid;
    },
    
    getMetric           : function ( metric_id ) {
        return this.mapping_metrics[ metric_id ];
    },
    getMetricByName     : function ( metric_name ) {
        var _keys = Object.keys( this.mapping_metrics );
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.mapping_metrics[ _keys[ i ] ];
            if ( _current.getMetric() === metric_name ) {
                return _current;
            }
        }
        return false;
    },
    //********************************************  COMPUTE  (PRIVATE) ***********************************************//
    cleanMetricSelection: function () {
        var _keys = Object.keys( this.mapping_metrics );
        for ( var i = 0, size = _keys.length; i < size; i++ ) {
            this.mapping_metrics[ _keys[ i ] ].removeMetricDetail();
        }
    },
    hasActiveMetric     : function () {
        var _keys = Object.keys( this.mapping_metrics );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            if ( this.mapping_metrics[ _keys[ i ] ].isActive() ) {
                return true;
            }
        }
        return false;
    },
    hasMetrics          : function () {
        return this.has_metrics;
    },
    computeSelected     : function ( uuid ) {
        if ( this.has_metrics && this.uuid === uuid ) {
            this.addCheckDetail();
        }
    }
};
