%if code_http != 200:
<body>
<div class="unauthorized">
    %if code_http == 403:
    <div>{{app._('unauthorized.403_text')}}</div>
    <i class="shinkon-lock"></i>
    %elif code_http == 404:
    <div>{{app._('unauthorized.404_text')}}</div>
    <i class="shinkon-warning"></i>
    %elif code_http == 401:
    <div>{{app._('unauthorized.401_text')}}</div>
    <i class="shinkon-warning"></i>
    %elif code_http == 500:
    <div>{{app._('unauthorized.500_text')}}</div>
    <i class="shinkon-warning"></i>
    %elif code_http == 512:
    <div>{{app._('unauthorized.512_text')}}</div>
    <i class="shinkon-warning"></i>
    %elif code_http == 513:
    <div>{{app._('unauthorized.513_text')}}</div>
    <i class="shinkon-warning"></i>
    %end
</div>
</body>
%else:
%import json
<script>
    var colors    = {{!json.dumps(colors_graphics)}}.split(',');
    var __selected_metric = '{{metric_selected}}';
</script>
% style_host_container = "width: %spx; max-width: %spx" % (width_host, width_host);
<body>
    <link href="/static/{{app.http_start_time}}/graphs/css/detail_graphs.css" rel="stylesheet">
    <link href="/static/{{app.http_start_time}}/graphs/css/shinken-tooltip.css" rel="stylesheet">

    <script src="/static/{{app.http_start_time}}/graphs/js/metric/base.js"></script>
    <script src="/static/{{app.http_start_time}}/graphs/js/metric/serie.js"></script>
    <script src="/static/{{app.http_start_time}}/graphs/js/metric/object.js"></script>

    <script src="/static/{{app.http_start_time}}/graphs/js/detail-graph/_base-detail-graph.js"></script>

    <script src="/static/{{app.http_start_time}}/graphs/js/detail-graph/graph-container.js"></script>
    <script src="/static/{{app.http_start_time}}/graphs/js/detail-graph/check.js"></script>
    <script src="/static/{{app.http_start_time}}/graphs/js/detail-graph/separator.js"></script>
    <script src="/static/{{app.http_start_time}}/graphs/js/detail_graphs.js"></script>
    <script src="/static/{{app.http_start_time}}/graphs/js/shinken-tooltip.js"></script>
    <script src="/static/{{app.http_start_time}}/graphs/js/detail-graph/host.js"></script>

    <div id='cv_graphics_cont' onmousemove="separatorDragging(event)" onmouseup="separatorDragEnd(event)">
        %_host_name = data['hname']
        <table class="shinken-graph-table">
            <tr>
                <td class="shinken-list-checks-container-cell" data-uuid="{{uuid}}" data-host-name="{{_host_name}}" style="{{style_host_container}}">
                    <div class='shinken-list-checks-container'>
                        <div class="graph_check_header">
                            %if len(data['services']) == 0:
                            <span class='label'>{{app._('graphics.noCheck')}}</span>
                            %end
                        </div>
                        <div class="check_list">
                            <table class="shinken-list-checks-tab">
                                %tmp_switch_no_metrics = True
                                %for service in data['services']:
                                    %extra_class = ''
                                    %_check_name = service['sdesc']
                                    %_state = service['state']
                                    %_check_id = service['_id']
                                    %_check_uuid = service['uuid']
                                    %_has_metrics = service['have_metrics']
                                    %extra_margin = ''
                                    %if not _has_metrics:
                                        %extra_class = 'shinken-not-has-metrics'
                                    %end

                                <tbody class="shinken-check-container {{extra_class}}" data-check-name="{{_check_name}}" data-check-id="{{_check_id}}" data-check-uuid="{{_check_uuid}}">
                                <tr class="shinken-check-line ">
                                    <td class="shinken-remove-element-cell">
                                        <div class='shinkon-broom remove_serie_column' onclick='removeCheckDetail("{{_check_id}}")'></div>
                                    </td>
                                    <td>
                                        <div class="shinken-check-line-name-and-status">
                                            <span class="status_icon" style="background-image: url(/static/{{app.http_start_time}}/img/icons/state_{{_state}}.png)"></span>
                                            <div class="shinken-check-name" onclick="addCheckDetail('{{_check_id}}')">{{_check_name}}</div>
                                        </div>
                                    </td>
                                </tr>
                                %if _has_metrics:
                                %for _metric in service['metrics']:
                                    % metric_name = _metric['name'];
                                    % threshold_crit = _metric['crit'];
                                    % threshold_warn = _metric['warn'];
                                    % metric_SLASH = metric_name.replace ( '/', 'SLASH' );
                                    % metric_id = _check_id + '-' + metric_SLASH;
                                    <tr class="shinken-metric-line" data-check-uuid="{{_check_uuid}}" data-metric-id="{{metric_id}}" data-metric-name="{{metric_name}}" data-threshold-warn="{{threshold_warn}}" data-threshold-crit="{{threshold_crit}}">
                                        <td class="shinken-remove-element-cell">
                                            <div class="remove_metric_column shinkon-broom" onclick='removeMetricDetail("{{_check_id}}", "{{metric_id}}")'></div>
                                        </td>
                                        <td>
                                            <div class="shinken-metric-label-container" onclick="addMetricDetail('{{_check_id}}', '{{metric_id}}')"><div class="shinken-metric-label">{{metric_name}}</div></div>
                                        </td>
                                    </tr>
                                    %if threshold_warn :
                                    <tr class="shinken-threshold-line" data-metric-id="{{metric_id}}" data-threshold-type="warning">
                                        <td class="shinken-remove-element-cell">
                                            <div class="remove_metric_column shinkon-broom" onclick='removeThresholdDetail("{{_check_id}}", "{{metric_id}}", "warning")'></div>
                                        </td>
                                        <td>
                                            <div class="shinken-metric-label-container" onclick="addThresholdDetail('{{_check_id}}', '{{metric_id}}', 'warning')">
                                                <span class="shinken-line is-threshold-warning"></span>
                                                <div class="shinken-metric-label shinken-metric-warning">{{app._('graphics.threshold_warning')}}</div>
                                            </div>
                                        </td>
                                    </tr>
                                    %end
                                    %if threshold_crit :
                                    <tr class="shinken-threshold-line" data-metric-id="{{metric_id}}" data-threshold-type="critical">
                                        <td class="shinken-remove-element-cell">
                                            <div class="remove_metric_column shinkon-broom" onclick='removeThresholdDetail("{{_check_id}}", "{{metric_id}}", "critical")'></div>
                                        </td>
                                        <td>
                                            <div class="shinken-metric-label-container" onclick="addThresholdDetail('{{_check_id}}', '{{metric_id}}', 'critical')">
                                                <span class="shinken-line is-threshold-critical"></span>
                                                <div class="shinken-metric-label shinken-metric-critical">{{app._('graphics.threshold_critical')}}</div>
                                            </div>
                                        </td>
                                    </tr>
                                    %end
                                %end
                            %end
                        </tbody>
                    %end
                </table>
            </div>
        </div>
                <td>
                    <div class="shinken-graphics-separator"
                         onmousedown="separatorDragStart(event)">
                        <div class="shinken-graphics-separator-icon"
                             onmouseenter="SHINKEN_TOOLTIP.showTooltip(this)"
                             onmouseleave="SHINKEN_TOOLTIP.hideTooltip()"
                             shi-tip-class="shinken-tooltip-graphics-separator"
                             shi-tip-placement="right"
                             shi-tip-text="{{app._('graphics.resize_metric_panel')}}">
                        </div>
                    </div>
                </td>
                <td class="shinken-detail-graph-container-cell">
                    <div id="error-div" class='shinken-detail-graph-container'>
                        <div class='block_right_header'>
                            <div class="option">
                                %_hide_trending = 'hide'
                                %if app.show_trending:
                                %_hide_trending = ''
                                %end
                                <label id="label-precision">
                                    <div class="">
                                        <span>{{app._('graphics.precision')}} : </span>
                                        <span id="label-precision-value"></span>
                                        <br>
                                        <span id="label-precision-approximation">
                                            {{app._('graphics.approximation_activate')}} <span class="shinkon-question-circle" title="{{app._('graphics.approximation_activate_tooltip')}}"></span>
                                        </span>

                                    </div>
                                </label>
                                <button id="btn-refresh" type="button" class='btn' data-toggle="tooltip" data-placement="bottom" title="{{app._('graphics.refresh')}}">
                                    <div class="fa-spin">
                                        <i class="shinkon-refresh"></i>
                                    </div>
                                </button>
                                <button id="btn-trending" type="button" class='btn {{_hide_trending}}' data-toggle="tooltip" data-placement="bottom" title="{{app._('graphics.trending')}}" onclick='trending_detail();'><i class="shinkon-stats"></i>
                                </button>
                            </div>
                            <div class="btn-group select_timerange" data-toggle="buttons-radio">
                                <button id="btn-1d" type="button" class='btn btn-timerange active' onclick='change_timerange_detail("-1d");'>1 {{app._('graphics.day')}}</button>
                                <button id="btn-1w" type="button" class='btn btn-timerange' onclick='change_timerange_detail("-1w");'>1 {{app._('graphics.week')}}</button>
                                <button id="btn-1month" type="button" class='btn btn-timerange' onclick='change_timerange_detail("-1month");'>1 {{app._('graphics.month')}}</button>
                                <button id="btn-1y" type="button" class='btn btn-timerange' onclick='change_timerange_detail("-1y");'>1 {{app._('graphics.year')}}</button>
                            </div>
                        </div>

                        <div id="container"
                             data-uuid='{{uuid}}'
                             data-hname='{{_host_name}}'
                             data-sdesc='{{sdesc}}'
                             data-metric='{{metric}}'></div>
                    </div>
                </td>
            </tr>
        </table>

        <div id="loading-frame-div">
            <div class="loading-frame-div-label">
                {{app._('graphics.recompute_datas')}}
                <br>
                <br>
                {{app._('graphics.precision_change')}}
                <br>
                <br>
                <span id="loading-frame-div-approximation">{{app._('graphics.approximation_activate')}}</span>

            </div>
        </div>
    </div>
    <div id="shi-tip" style="top: -500px; left: -500px;">
        <table>
            <tbody>
                <tr>
                    <td></td>
                    <td>
                        <table>
                            <tr>
                                <td style="width: 20px;">
                                    <div class="shi-tip-arrow" id="tooltip-arrow-top-left"></div>
                                </td>
                            </tr>
                        </table>
                    </td>
                    <td>
                        <table class="shinken-width-100">
                            <tr>
                                <td style="width: 20px;">
                                    <div class="shi-tip-arrow" id="tooltip-arrow-top-middle"></div>
                                </td>
                            </tr>
                        </table>
                    </td>
                    <td>
                        <table  class="shinken-width-100">
                            <tr>
                                <td></td>
                                <td></td>
                                <td style="width: 20px;">
                                    <div class="shi-tip-arrow" id="tooltip-arrow-top-right"></div>
                                </td>
                            </tr>
                        </table>
                    </td>
                    <td></td>
                </tr>
                <tr>
                    <td><div class="shi-tip-arrow" id="tooltip-arrow-left-middle"></div></td>
                    <td colspan="3"><div class="shi-tip-text"></div></td>
                    <td><div class="shi-tip-arrow" id="tooltip-arrow-right-middle"></div></td>
                </tr>
                <tr>
                    <td></td>
                    <td>
                        <table>
                            <tr>
                                <td style="width: 20px;">
                                    <div class="shi-tip-arrow" id="tooltip-arrow-bottom-left"></div>
                                </td>
                            </tr>
                        </table>
                    </td>
                    <td>
                        <table class="shinken-width-100">
                            <tr>
                                <td style="width: 20px;">
                                    <div class="shi-tip-arrow" id="tooltip-arrow-bottom-middle"></div>
                                </td>
                            </tr>
                        </table>
                    </td>
                    <td>
                        <table  class="shinken-width-100">
                            <tr>
                                <td></td>
                                <td></td>
                                <td style="width: 20px;">
                                    <div class="shi-tip-arrow" id="tooltip-arrow-bottom-right"></div>
                                </td>
                            </tr>
                        </table>
                    </td>
                    <td></td>
                </tr>
            </tbody>
        </table>
    </div>
</body>

%end
