%mode = 'sla' if current_search['data_type']=='history_sla' else current_search['data_type']
%item_ok_p = item_result[mode].get('ok',0)
<div class="daily-sla-table">
    <table>
        <tr>
            <th class="range-table-header date">{{app._('reporting.date')}}</th>
            %for mode in modes:
                <th class="range-table-header mode" colspan="{{len(ALL_STATES)}}" style="width: {{100/len(modes)}}%">
                    <div class="mode" >{{app._('reporting.overall') % app._('reporting.%s' % mode)}}</div>
                </th>
            %end
        </tr>
        <tr class="range-content">
            %include _report-element-range locals()
        </tr>
        <tr class="range-table-state-line">
            <th class="range-table-state-cell"></th>
            %for mode in modes:
                %for state in ALL_STATES:
                    %icon = app.helper.get_sla_state_icon(state)
                    %tooltip = 'data-toggle="tooltip" title="%s"' % app._('reporting.%s' % state)
                    %if mode == 'sla':
                        %state_text = app._('reporting.sla')
                        %if state == 'ok':
                            %state_text += '''<span class="sla-icon shinicon-arrow-up"></span>'''
                        %else:
                            %state_text += '''<span class="sla-icon shinicon-arrow-down"></span>'''
                        %end
                    %else:
                        %state_text = app._('reporting.%s' % state)
                    %end
                    <th class="range-table-state-cell col-{{state}}" {{tooltip}}>{{!icon}}
                        <span class="hide-if-under-600">{{!state_text}}</span>
                    </th>
                %end
            %end
        </tr>

        %_days = item['by_day']
        %_days.reverse()
        %rowspan_in_future = len([d for d in _days if d['result'].get('in_future', False)])
        %rowspan_in_past = len([d for d in _days if d['result'].get('in_past', False)])
        %first_in_future=True
        %first_in_past=True
        %for i, day in enumerate(_days):
            %day_result = day['result']
            %day_string = time.strftime('%Y-%m-%d', time.localtime(day['day']))
            %no_data_class= '-no-data' if day_result.get('in_future', False) or day_result.get('in_past', False) else ''
            <tr class="line-content{{no_data_class}}">
                <td class="date-cell">
                    %_class="arrow arrow-mid"
                    %_content=''
                    %if len(_days) == 1:
                        %_class=''
                        %_content=''
                    %elif i == 0:
                        %_class="arrow arrow-end"
                        %_content='<i class="shinkon shinkon-triangle"></i>'
                    %elif i == len(_days)-1:
                        %_class="arrow arrow-head"
                        %_content='<i class="shinkon shinkon-circle"></i>'
                    %end
                    <table class="arrow-table">
                        <tr>
                            <th class="{{_class}}"><div class="shinken-arrow-container">{{!_content}}</div></th>
                            <th class="inner-date">
                                <span class="date">{{day_string}}</span>
                                %if 'sla' in modes:
                                    %if day_result.get('in_future', False) or day_result.get('in_past', False):
                                        <div class="display-sla-percent-day">
                                            <div class="display-sla-percent-container">
                                                <p>-</p>
                                            </div>
                                        </div>
                                    %else:
                                        %include _report-info-sla app=app, _class="display-sla-percent-day", _type="sla-percent-day", item=day_result, last_day=None, current_search=current_search
                                    %end
                                %end
                            </th >
                        </tr>
                    </table>
                </td>
                %if day_result.get('in_future', False):
                    %if first_in_future:
                        <td colspan="{{len(modes) * len(ALL_STATES)}}" rowspan={{rowspan_in_future}} class="no-data-futur">
                            %no_data_img = '/static/%s/sla/img/no-data.png' % app.http_start_time
                            {{app._('reporting.in_future')}}&nbsp;<img src={{no_data_img}} width="30px"/>
                        </td>
                    %end
                    %first_in_future = False
                %elif day_result.get('in_past', False):
                    %if first_in_past:
                        <td colspan="{{len(modes) * len(ALL_STATES)}}" rowspan={{rowspan_in_past}} class="no-data-past">
                            %no_data_img = '/static/%s/sla/img/no-data.png' % app.http_start_time
                            {{app._('reporting.in_past')}}&nbsp;<img src={{no_data_img}} width="30px"/>
                        </td>
                    %end
                    %first_in_past = False
                %else:
                    %for mode in modes:
                        %_rows = ''
                        %for state in ALL_STATES:
                            %_value = day_result[mode].get( state, 0)
                            <td class="col-{{state}}">
                                %if _value:
                                   {{!app.helper.get_value_label(state, _value, False)}}
                                %end
                            </td>
                        %end
                    %end
                %end
            </tr>
        %end
    </table>
</div>