

/* We want to be able to add image hovering in perfdata
   so we need the position of the mouse and make apears a div with
   the image in it */

var mouse_abs_x = 0;
var mouse_abs_y = 0;

var mouse_rel_x = 0;
var mouse_rel_y = 0;

var current_img = '';

function create_img(src, alt){
    var img = $("<img/>");

    // If we got problem with the image, bail out the
    // print/ WARNING : BEFORE set src!
    img.onerror = function() {
	img.hide()
    };
    img.attr('src', src);
    img.attr('alt', alt);

    return img;
}

// First we look for the img_hover div and we add it
// the image, and we set it in the good place
function toggle_hover_img(src, hname, sdesc){
    if(src == current_img){
	hide_hover_img();
	return;
    }

    // Ok asking for a new load
    current_img = src;

    $('#img_hover').empty();
    $('#spinner_graph').show();
    $('#inner_graph').empty();
    get_spinner('spinner_graph');
    console.log('Spinner ADDED');
    //return;

    //var img = create_img(src, alt);
    var div = $('#img_hover');
    $('#img_hover').load(src, function() {
	    $('#spinner_graph').hide();
	    console.log('Load fini');
	    // give the title on the panel
	    if(sdesc != ''){
		$('#img_hover_title').html('<center>'+hname+'/'+sdesc+'</center>');
	    }else{
		$('#img_hover_title').html('<center>'+hname+'</center>');
	    }
    

	    div.show();
	});

    var pagesize = document.documentElement.clientWidth;
    var pagehigth = document.documentElement.clientHeight;

    // If we are too much on the left, put the image a bit
    // before so we are sure it fill on the page without
    // slide. same for hight
    var pos_x = mouse_abs_x+10;
    if(pagesize - pos_x < 640){
	pos_x = pagesize - 640;
    }

    // By default we are a bit lower than the mouse
    var pos_y = mouse_abs_y + 20;

    // If too low, go higher. We use the relative y position here
    if(pagehigth - mouse_rel_y < 480){
        pos_y = pos_y - 250;
	console.log('Too low, go higher '+pos_y);
    }



    // Ok, let apply our positions!
    div.css('left', pos_x +'px');
    div.css('top', pos_y +'px');

    // And add our image, then make the div appears
    // magically
    //div.append(img);
    div.show();
    console.log('THE SHOW MUST GO ON!');
}

// when we go out the hover item, we must hide the
// img div, and remove the image in it
function hide_hover_img(){
    $('#img_hover').hide();
    current_img = '';
}

// When we move, we save our mouse position, both
// absolute and relative
$(document).ready(function(){
    document.onmousemove = function(e){
	// Some fuck.. browser do not support pageX
	// or give the event... yes, I look at you IE!
	e = e || window.event;
	if (e.pageX || e.pageY){
            mouse_abs_x = e.pageX;
            mouse_abs_y = e.pageY;
	}else if (e.clientX || e.clientY) {
	    mouse_abs_x = e.clientX + document.body.scrollLeft + document.documentElement.scrollLeft;
            mouse_abs_y = e.clientY + document.body.scrollTop  + document.documentElement.scrollTop;
	}
	// Now the relative part.
	mouse_rel_x = e.clientX;
	mouse_rel_y = e.clientY;

    };
});
