#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.

from .massive_change_field import MassiveChangeField


class MassiveChangePlusProperty(MassiveChangeField):
    
    def __init__(self, prop_name, item_type, item_id, category, is_protected, action):
        super(MassiveChangePlusProperty, self).__init__(prop_name, item_type, item_id, category, is_protected, action)
    
    
    def set_previous_value(self, value, app, datamanagerV2):
        super(MassiveChangePlusProperty, self).set_previous_value(value, app, datamanagerV2)
        if value:
            self._html_previous_value = app.helper.helper_object.build_icon_plus('ON')
            self._previous_filter_value = 'ON'
        else:
            self._html_previous_value = app.helper.helper_object.build_icon_plus('OFF')
            self._previous_filter_value = 'OFF'
    
    
    def set_actual_value(self, value, modified, app, datamanagerV2):
        super(MassiveChangePlusProperty, self).set_actual_value(value, modified, app, datamanagerV2)
        if value:
            self._html_actual_value = app.helper.helper_object.build_icon_plus('ON')
            self._actual_filter_value = 'ON'
        else:
            self._html_actual_value = app.helper.helper_object.build_icon_plus('OFF')
            self._actual_filter_value = 'OFF'
    
    
    def get_uuid(self):
        return '%s-plus-%s' % (self.item_id, self.name)
