#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.


class ComponentSelectOptions:
    def __init__(self, component_helper):
        self.contents = []
        self.component_helper = component_helper
    
    
    def setContents(self, to_set):
        self.contents = to_set
    
    
    def addContent(self, to_add):
        self.contents.append(to_add)
    
    
    def insertContent(self, index, to_add):
        self.contents.insert(index, to_add)
    
    
    def removeContent(self, index):
        return self.contents.pop(index)
    
    def is_hidden_for_admin_si(self):
        return False
    
    def buildHTML(self):
        _to_return = self.component_helper.get_selector_html(entries=self.contents)
        return _to_return


class ComponentOptionSeparator:
    def __init__(self, label=""):
        self.label = label
    
    def is_hidden_for_admin_si(self):
        return False
    
    def buildHTML(self):
        _to_return = []
        if self.label:
            _to_return.append('''<div class="shinken-optgroup-title">''')
            _to_return.append('''%s''' % self.label)
            _to_return.append('''</div>''')
            return "".join(_to_return)
        return '<div class="shinken-option-separator"></div>'


class ComponentOptionGroup:
    def __init__(self, id, title):
        self.id = id
        self.title = ComponentOptionSeparator(title)
        self.contents = []
    
    
    def setContents(self, to_set):
        self.contents = to_set
        if self.title:
            self.insertContent(0, self.title)
    
    
    def addContent(self, to_add):
        self.contents.append(to_add)
    
    
    def insertContent(self, index, to_add):
        self.contents.insert(index, to_add)
    
    
    def removeContent(self, index):
        return self.contents.pop(index)
    
    def is_hidden_for_admin_si(self):
        return False
    
    
    def buildHTML(self):
        _to_return = []
        _to_return.append('''<div id="%s" class="shinken-optgroup" >''' % self.id)
        for _content in self.contents:
            _to_return.append('''%s''' % _content.buildHTML())
        _to_return.append('''</div>''')
        return "".join(_to_return)


class ComponentOption:
    def __init__(self, state, enable, value, selected, selected_order, state_element='', extra_content=False, force_to_null=False, _id='', label=False, text=False, item_type='', is_hidden_for_admin_si=False, always_visible=False, extra_class=''):
        self.state = state
        self.enable = enable
        self.value = value
        self.selected = selected
        self.selected_order = selected_order
        self.state_element = state_element
        self.force_to_null = force_to_null
        self.hidden_for_admin_si = is_hidden_for_admin_si
        self.extra_class = extra_class
        self.id = _id
        self.id_link = _id
        self.item_type = item_type
        self.always_visible = always_visible
        if self.state == 'new' and self.id:
            self.id_link = '%s%s' % (self.id_link, '?new=1')
        self.label = label or value
        self.extra_content = extra_content
        self.text = text or self.label
    
    
    def is_disable(self):
        return self.enable == '0'
    
    
    def is_forced_to_null(self):
        return self.force_to_null
    
    
    def is_hidden_for_admin_si(self):
        return self.hidden_for_admin_si
    
    
    def is_visible(self):
        return self.always_visible
    
    
    def buildHTML(self):
        _to_return = []
        _to_return.append('''<div class="shinken-option %s" ''' % self.extra_class)
        _to_return.append('''data-state="%s"''' % self.state)
        _to_return.append('''data-key-name="%s"''' % self.value)
        _to_return.append('''data-key-label="%s"''' % self.label)
        _to_return.append('''onclick="MANAGER.EventManager.clickOnItemSelector(event,'', this)" >''')
        _to_return.append('''   <span class="shinken-space">%s</span>''' % self.text)
        if self.extra_content:
            _to_return.append('''   %s''' % self.extra_content)
        _to_return.append('''</div>''')
        return " ".join(_to_return)
    
    
    @staticmethod
    def multiselect_option_builder(item_prop, name, state, _type, id='', label=None, text=None, class_to_add='', is_disabled='false', is_force_to_null='false', item_type='', is_hidden_for_admin_si='false', extra_content=""):
        if not extra_content:
            extra_content = ""
        if not label:
            label = name
        if label.startswith(u'--') and label.endswith(u'--') and name != "NONE":
            input_name = str(label)
        else:
            input_name = name
        if text is None:
            text = label
            if _type == 'inheritance':
                text = ' -- %s -- ' % text
        
        _to_return = '<div class="shinken-option %s" ' \
                     '      data-state="%s" ' \
                     '      data-key-name="%s" ' \
                     '      data-key-label="%s" ' \
                     '      data-type="%s" ' \
                     '      data-item-type="%s" ' \
                     '      data-is-disabled="%s"' \
                     '      data-force-to-null="%s"  ' \
                     '      data-is-hidden-for-admin-si="%s" ' \
                     '      data-uuid="%s" ' \
                     '      onmouseenter="MANAGER.EventManager.mouseEnter(event)"' \
                     '      onclick="MANAGER.EventManager.clickOnItemSelector(event,\'%s\', this)" >' \
                     '   <span class="shinken-space">%s</span>' \
                     '   %s' \
                     '</div>' \
                     % (
                         class_to_add,
                         state,
                         name,
                         label,
                         _type,
                         item_type,
                         is_disabled,
                         is_force_to_null,
                         is_hidden_for_admin_si,
                         id,
                         item_prop,
                         text,
                         extra_content
                     )
        
        return _to_return
