//__lib__ lib_external
MANAGER.DragNDropManager = (function ( self ) {
    "use strict";
    self.last_element_hovered = null;
    self.current_parent_name  = null;
    self.type_drag_start      = null;
    self.list_element         = null;
    self.single_element_drag  = null;
    
    self.dragStartSingle  = function ( event ) {
        self.single_element_drag = DOM.Service.findParentElementWithClass( event.target, "shinken-draggable", 50 );
        this.single_element_drag.classList.add("shinken-drag-active");
        self._bounding_origin = self.single_element_drag.getBoundingClientRect();
        self._mouse_x_origin  = parseInt( event.clientX );
        self._mouse_y_origin  = parseInt( event.clientY );
        var _computed         = DOM.Service.getComputedStyle( self.single_element_drag );
        self._left_origin = parseInt( _computed[ 'left' ] );
        self._top_origin  = parseInt( _computed[ 'top' ] );
    };
    self.dragSingle       = function ( event ) {
        if ( !self.single_element_drag ) {
            return;
        }
        var _delta_x = parseInt( event.clientX ) - self._mouse_x_origin + self._left_origin;
        var _delta_y = parseInt( event.clientY ) - self._mouse_y_origin + self._top_origin;
        DOM.Service.setStyles( self.single_element_drag, { "top": _delta_y, "left": _delta_x } );
    };
    self.dragEndSingle    = function ( event ) {
        this.single_element_drag.classList.remove("shinken-drag-active");
        self.single_element_drag = null;
    };
    self.dragStartShinken = function ( e, type, parent_name, key_name ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        if ( _object.is_disabled ) {
            return false;
        }
        // Fix pour firefox
        e.dataTransfer.setData( 'text', 'anything' );
        // end Fix
        self.type_drag_start      = type;
        self.current_parent_name  = parent_name;
        self.list_element         = _object.dragStartShinken( type, key_name );
        self.last_element_hovered = self.list_element.getDragged().getDomElement().parentNode;
        self.last_index           = self.last_element_hovered.dataset.index;
        self.last_element_hovered.classList.add( MANAGER.CONST.DRAG_N_DROP.CLASS.HOVER );
        
        var _list_droppable = _object.dom_element.querySelectorAll( '.droppable' );
        for ( var i = 0, _size_i = _list_droppable.length; i < _size_i; i++ ) {
            _list_droppable[ i ].style.width = _list_droppable[ i ].getBoundingClientRect().width - 2 + 'px';
        }
    };
    self.dragOverShinken  = function ( e, type, parent_name, dom_element ) {
        e.preventDefault();
        if ( self.current_parent_name !== parent_name ) {
            return false;
        }
        if ( self.type_drag_start !== type ) {
            return false;
        }
        var _current_index_hovered = dom_element.dataset.index;
        if ( _current_index_hovered === self.last_index ) {
            return false;
        }
        
        self.list_element.changeElementPosition( self.last_index, _current_index_hovered );
        self.last_index = _current_index_hovered;
        self.last_element_hovered.classList.remove( MANAGER.CONST.DRAG_N_DROP.CLASS.HOVER );
        self.last_element_hovered = dom_element;
        self.last_element_hovered.classList.add( MANAGER.CONST.DRAG_N_DROP.CLASS.HOVER );
    };
    self.dragEndShinken   = function ( e, type ) {
        var _list_droppable = MANAGER.__instance_property_distributor.last_element_focus.dom_element.querySelectorAll( '.droppable' );
        for ( var i = 0, _size_i = _list_droppable.length; i < _size_i; i++ ) {
            _list_droppable[ i ].style.width = '';
        }
        
        if ( MANAGER.__instance_property_distributor.last_element_focus.is_disabled ) {
            return false;
        }
        e.preventDefault();
        MANAGER.__instance_property_distributor.last_element_focus.resetDragging();
        
        if ( self.last_element_hovered ) {
            self.last_element_hovered.classList.remove( MANAGER.CONST.DRAG_N_DROP.CLASS.HOVER );
        }
        self.last_element_hovered = null;
        self.current_parent_name  = null;
        self.type_drag_start      = null;
        self.list_element         = null;
        self.pause_timeout        = null;
    };
    self.dropShinken      = function ( e, type, parent_name, dom_element ) {
        e.preventDefault();
    };
    return self;
})
( MANAGER.DragNDropManager || {} );
