SHINKEN.DOM = (function( self ) {
    "use strict";
    
    self.hide    = function( dom_element ) {
        if ( dom_element ) {
            dom_element.style.display = 'none';
        }
    };
    self.hideAll = function( dom_elements ) {
        if ( !dom_elements ) {
            return;
        }
        var _size = dom_elements.length;
        for ( var i = 0 ; i < _size; i++ )
            self.hide( dom_elements[i]);
    };
    self.show    = function( dom_element, display_type ) {
        if ( dom_element ) {
            dom_element.style.display = display_type || 'block';
        }
    };
    self.showAll = function( dom_elements ) {
        if ( !dom_elements ) {
            return;
        }
        var _size = dom_elements.length;
        for ( var i = 0 ; i < _size; i++ )
            self.show( dom_elements[i]);
    };
    
    self.remove_class_for = function( selector, class_to_remove ) {
        var _elements = document.querySelectorAll( selector );
        for ( var i = 0, _size = _elements.length; i < _size; i++ ) {
            _elements[ i ].classList.remove( class_to_remove );
        }
    };
    self.add_class_for = function( selector, class_to_add ) {
        var _elements = document.querySelectorAll( selector );
        
        for ( var i = 0, _size = _elements.length; i < _size; i++ ) {
            _elements[ i ].classList.add( class_to_add );
        }
    };
    
    self.set_inner_HTML_for = function( selector, html ) {
        var _elements = document.querySelectorAll( selector );
        for ( var i = 0, _size = _elements.length; i < _size; i++ ) {
            _elements[ i ].innerHTML = html;
        }
    };
    
    
    
    return self;
})( SHINKEN.DOM || {} );

