//priority 20
//__lib__ lib_external
SHINKEN.HIGHWAY = (function ( self ) {
    "use strict";
    self.goToParentUrl        = function () {
        var _floors        = location.pathname.split( '/' );
        var _new_path_name = "";
        var _size          = _floors.length;
        for ( var i = 1; i < _size - 1; i++ ) {
            _new_path_name += "/";
            _new_path_name += _floors[ i ];
        }
        switch ( _new_path_name ) {
            case "":
            case "/elements/my_working_area":
            case "/elements/working_area":
            case "/elements":
            case "/sources":
            case "/analyzers":
            case "/tagger":
            case "/elements/add":
                _new_path_name = "/main";
                break;
            case "/elements/add/working_area":
                _new_path_name = "/elements/working_area/hosts";
                break;
            case "/sources/server-analyzer/discovery":
                _new_path_name = "/sources/server-analyzer?tab=tab-network-scan";
                break;
            case "/sources/discovery/discovery":
                _new_path_name = "/sources/discovery?tab=tab-network-scan";
                break;
            case "/sources/server-analyzer/discovery/add":
                _new_path_name = "/sources/server-analyzer?tab=tab-network-scan";
                break;
            case "/sources/discovery/discovery/add":
                _new_path_name = "/sources/discovery?tab=tab-network-scan";
                break;
        }
        switch ( location.pathname ) {
            case "/elements/add/cluster":
            case "/elements/add/clustertpl":
            case "/elements/add/hosttpl":
            case "/elements/add/hostgroup":
            case "/elements/add/serviceshost":
            case "/elements/add/serviceshosttpl":
            case "/elements/add/servicescluster":
            case "/elements/add/servicesclustertpl":
            case "/elements/add/servicetpl":
            case "/elements/add/contact":
            case "/elements/add/contacttpl":
            case "/elements/add/contactgroup":
            case "/elements/add/escalation":
            case "/elements/add/notificationway":
            case "/elements/add/command":
            case "/elements/add/businessimpactmodulation":
            case "/elements/add/macromodulation":
            case "/elements/add/resultmodulation":
            case "/elements/add/timeperiod":
                _new_path_name = "/elements/" + _floors[ _size - 1 ] + 's';
                break;
        }
        window.location = location.origin + _new_path_name;
    };
    self.goToElementTab       = function ( tab_name ) {
        var _path     = self.getPath();
        var _params   = self.getParams();
        var _old_name = _params[ 'tab' ];
        if ( _old_name === tab_name ) {
            return;
        }
        _params[ 'tab' ]       = tab_name;
        var _new_params_string = self.buildParamsToUrl( _params );
        self.changeUrl( _path + _new_params_string );
    };
    self.changeUrl            = function ( new_url ) {
        window.history.pushState( "object or string", "Title", new_url );
    };
    self.getPath              = function () {
        return location.origin + location.pathname;
    };
    self.getPathWithoutOrigin = function () {
        return location.pathname + self.buildParamsToUrl( self.getParams() );
    };
    self.buildParamsToUrl     = function ( params ) {
        var _keys = Object.keys( params );
        var _size = _keys.length;
        if ( !_size ) {
            return '';
        }
        var _to_return = COMMUNICATION.QUERY.GET.SEPARATOR.GET_BEGINNER;
        for ( var i = 0; i < _size; i++ ) {
            if ( i ) {
                _to_return += COMMUNICATION.QUERY.GET.SEPARATOR.GET_ADD;
            }
            _to_return += _keys[ i ] + COMMUNICATION.QUERY.GET.SEPARATOR.PARAM_SETTER + params[ _keys[ i ] ];
        }
        return _to_return;
    };
    self.getParams            = function ( param ) {
        var vars = {};
        window.location.href.replace( location.hash, '' ).replace(
            /[?&]+([^=&]+)=?([^&]*)?/gi, // regexp
            function ( m, key, value ) { // callback
                vars[ key ] = value !== undefined ? value : '';
            }
        );
        
        if ( param ) {
            return vars[ param ] ? vars[ param ] : null;
        }
        return vars;
    };
    self.is     = function ( type ) {
        switch ( type ) {
            case COMMUNICATION.PAGE_TYPE.LIST_ALL_ELEMENT: //PATCH BUG 4022 TO REMOVE
                return location.pathname === "/elements/elements";
            case COMMUNICATION.PAGE_TYPE.LIST_WORKING_AREA:
                return location.pathname === "/elements/working_area/hosts" || location.pathname === "/elements/my_working_area/hosts";
        }
    };
    self.getListType     = function () {
        var _to_return = self.getPath().split("/");
        return _to_return[_to_return.length - 1];
    };
    self.goTo                 = function ( url, event ) {
        if ( event ) {
            event.stopPropagation();
            event.preventDefault();
        }
        if ( event && event.ctrlKey ) {
            window.open( url, '_blank' );
        }
        else {
            window.location = url;
        }
    };
    self.refreshCurrentPage   = function () {
        location.reload();
    };
    self.removeItemIdFromHistory    = function ( item_id ) {
        var histories = App.HistoryManager.histories();
        for ( var i = histories.length - 1; i >= 0; i-- ) {
            var _previousUrl = histories[ i ];
            if ( SHINKEN.TOOLS.STRING.contains( _previousUrl, item_id ) ) {
                histories.splice( i, 1 );
            }
        }
        App.HistoryManager.setHandlers();
    };
    return self;
})( SHINKEN.HIGHWAY || {} );
