%group_name = ""
%group_name_label = ""
%if 'is_mass_change' not in locals():
    %is_mass_change=False
%end
%if is_mass_change:
    %group_name = "mass-change"
    %group_name_label = "-mass-change"
    %list_tab_for_element = ['generic','authorization']
    %group_not_editable = False
%end

<form id="id-shinken-form-element" data-type={{item_type}} name='form-element' class='form-element no-margin form-inline gray-back '>
    <div class="shinken-form-container">
        %if is_mass_change:
        <table class="shinken-mass-change-navigation">
            <tr class="shinken-window-group" data-name="{{group_name}}" onclick="MANAGER.EventManager.clickOnWindowNavigation(event,'{{group_name}}')">
                %for current_tab in list_tab_for_element:
                %include( "__print_element_td_tab", app=app, name=current_tab , label=app._('element.%s' % current_tab), group_name=group_name )
                %end
            </tr>
        </table>
        %else:
            %include( "__print_element_li_tab", app=app, list=list_tab_for_element)
        %end
        <div class="shinken-tab-content tab-content tab-area">
            <div {{!helper.getWindowTargetDiv('generic', group_name_label, selected_tab)}} >
                %include( "__print_panel_top_th", app=app)
                <div class="shinken-scroll-auto">
                    <table class="shinken-prop-table">
                        %if not is_mass_change:
                            {{!helper.get_string_input(item, 'contact_name', item_type, is_disabled=is_disabled_name, required=True)}}
                        %end
                        {{!helper.get_string_input(item, 'display_name', item_type, is_disabled=is_disabled, mass_change=is_mass_change)}}
                        %if not is_mass_change:
                            {{!helper.get_string_input(item, 'password', item_type, is_disabled=is_disabled, password=True)}}
                        %end
                        {{!helper.get_string_input(item, 'email', item_type, is_disabled=is_disabled, mass_change=is_mass_change)}}
                        {{!helper.get_string_input(item, 'pager', item_type, is_disabled=is_disabled, mass_change=is_mass_change)}}
                        {{!helper.get_multiselect_input(item, 'use', item_type, ITEM_TYPE.CONTACTTPLS, is_disabled=group_not_editable, mass_change=is_mass_change )}}
                        {{!helper.get_multiselect_input(item, 'contactgroups', item_type, ITEM_TYPE.CONTACTGROUPS, is_disabled=group_not_editable, mass_change=is_mass_change)}}
                        %if is_admin:
                            {{!helper.get_bool_input(item, 'expert', item_type, is_disabled=is_disabled, default=False, mass_change=is_mass_change)}}
                            {{!helper.get_bool_input(item, 'is_admin', item_type, is_disabled=is_disabled, default=False, mass_change=is_mass_change)}}
                            {{!helper.get_bool_input(item, 'default_submit_to_staging', item_type, is_disabled=is_disabled, default=True, mass_change=is_mass_change)}}
                        %end
                        {{!helper.get_multiselect_input(item, 'notificationways',  item_type, ITEM_TYPE.NOTIFICATIONWAYS, is_disabled=is_disabled, mass_change=is_mass_change)}}

                        %if not is_mass_change:
                            %if is_admin:
                                {{!helper.get_bool_input(item, 'enabled', item_type, is_disabled=is_disabled, default=True)}}
                            %end
                        %end
                        {{!helper.get_string_input(item, 'pack', item_type, is_disabled=is_disabled, mass_change=is_mass_change)}}
                    </table>
                </div>
            </div>
            %if not is_mass_change:
                <div {{!helper.getWindowTargetDiv('datas', group_name_label, selected_tab)}} >
                    %include( "__print_data_part",item=item, app=app)
                </div>
            %end
            %if is_admin:
                <div {{!helper.getWindowTargetDiv('authorization', group_name_label, selected_tab)}} >
                    %include( "__print_authorization",item=item, app=app, is_disabled=is_disabled)
                </div>
            %end
            %if not is_mass_change:
                <div {{!helper.getWindowTargetDiv('direct', group_name_label, selected_tab)}} >
                    %include( "__print_panel_top_th", app=app)
                    <div class="shinken-scroll-auto">
                        <div id="deprecated-contact-bloc" class="span11">
                            {{!app._('element.contact_deprecated_direct_conf')}}
                        </div>
                        <table class="shinken-prop-table">
                            {{!helper.get_select_input(item, 'host_notification_period', item_type, ITEM_TYPE.TIMEPERIODS, is_disabled=is_disabled, default='%s' % app._('element.always'), none_text='%s'% app._('element.always'), mass_change=is_mass_change)}}
                            {{!helper.get_select_input(item, 'service_notification_period', item_type, ITEM_TYPE.TIMEPERIODS, is_disabled=is_disabled, default='%s' % app._('element.always'), none_text='%s' % app._('element.always'), mass_change=is_mass_change)}}
                            {{!helper.get_bool_input(item, 'host_notifications_enabled',  item_type, is_disabled=is_disabled, default=True, mass_change=is_mass_change)}}
                            {{!helper.get_bool_input(item, 'service_notifications_enabled', item_type, is_disabled=is_disabled, default=True, mass_change=is_mass_change)}}
                            {{!helper.get_multiselect_input(item, 'host_notification_commands', item_type, ITEM_TYPE.COMMANDS, is_disabled=is_disabled, mass_change=is_mass_change)}}
                            {{!helper.get_multiselect_input(item, 'service_notification_commands', item_type, ITEM_TYPE.COMMANDS, is_disabled=is_disabled, mass_change=is_mass_change)}}
                            {{!helper.get_string_input(item, 'host_notification_options', item_type, is_disabled=is_disabled, default='d,u,r,f,s', mass_change=is_mass_change)}}
                            {{!helper.get_string_input(item, 'service_notification_options', item_type, is_disabled=is_disabled, default='w,u,c,r,f,s', mass_change=is_mass_change)}}
                            {{!helper.get_slider_input(item, 'min_business_impact', item_type , is_disabled=is_disabled, default=0, data_min=0, data_max=5, data_type='range_business_impact', mass_change=is_mass_change)}}
                        </table>
                    </div>
                </div>
            %end
            %if not is_mass_change:
                %if display_changes:
                    <div {{!helper.getWindowTargetDiv('changes', group_name_label, selected_tab)}} >
                        %include("__print_pane_change", locals=locals())
                    </div>
                %end
            %end
        </div>
    </div>
</form>