#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2018
# This file is part of Shinken Enterprise, all rights reserved.

import pycurl
from StringIO import StringIO

from shinken.log import logger

try:
    import shinkensolutions.shinkenjson as json
except ImportError:
    # For old Python version, load
    # simple json (it can be hard json?! It's 2 functions guy!)
    try:
        import simplejson as json
    except ImportError:
        print "Error: you need the json or simplejson module"
        raise

### Will be populated by the UI with it's own value
app = None


def check_api_server(api_key):
    error = ''
    results = ''
    c = pycurl.Curl()
    url = "%s://%s:%d/checkkey/%s" % ('https' if app.use_ssl else 'http', app.host, app.port, api_key)
    logger.debug('[test_api] testing with key [%s] on url [%s]' % (api_key, url))
    
    # Oups, seems that url an unicode are BAD :)
    url = str(url)
    c.setopt(c.URL, url)
    c.setopt(c.VERBOSE, 1)
    
    response = StringIO()
    c.setopt(c.WRITEFUNCTION, response.write)
    r = c.perform()
    response.seek(0)
    status_code = c.getinfo(pycurl.HTTP_CODE)
    
    # We only parse the json if we got
    if status_code == 200:
        results = json.loads(response.read().replace('\\/', '/'))
    else:
        error = response.read().replace('\\/', '/')
    
    c.close()
    
    logger.debug('[test_api] testing result status code [%s] json loaded [%s]-[%s]' % (status_code, results, error))
    return (results, error)


# Our page. If the user call /dummy/TOTO arg1 will be TOTO.
# if it's /dummy/, it will be 'nothing'
def get_page():
    # First we look for the user sid
    # so we bail out if it's a false one
    user = app.get_user_auth()
    
    api_key = app.get_api_key()
    print "API KEY IS", api_key, type(api_key)
    api_error = ''
    results = ''
    if api_key:
        (results, api_error) = check_api_server(api_key)
    else:
        api_error = "You don't have configured your API KEY"
    
    # we return values for the template (view). But beware, theses values are the
    # only one the template will have, so we must give it an app link and the
    # user we are logged with (it's a contact object in fact)
    return {'app': app, 'user': user, 'results': results, 'api_error': api_error}


# This is the dict the webui will try to "load".
#  *here we register one page with both addresses /dummy/:arg1 and /dummy/, both addresses
#   will call the function get_page.
#  * we say that for this page, we are using the template file dummy (so view/dummy.tpl)
#  * we said this page got some static stuffs. So the webui will match /static/dummy/ to
#    the dummy/htdocs/ directory. Beware: it will take the plugin name to match.
#  * optional: you can add 'method': 'POST' so this address will be only available for
#    POST calls. By default it's GET. Look at the lookup module for sample about this.
pages = {get_page: {'routes': ['/testapi'], 'view': 'testapi', 'static': True}}
