#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2020:
# This file is part of Shinken Enterprise, all rights reserved

from shinkensolutions.api.synchronizer.source.route.route import AbstractRoute
from shinken.misc.type_hint import List, NoReturn


class RouteContainer(object):
    
    def __init__(self):
        self._routes = []  # type: List[AbstractRoute]
    
    
    def __iter__(self):
        return self._routes.__iter__()
    
    def add(self, route):
        # type: (AbstractRoute) -> NoReturn
        self._routes.append(route)
