#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2020:
# This file is part of Shinken Enterprise, all rights reserved

from shinkensolutions.api.synchronizer.source.tab.tab import AbstractTab
from shinkensolutions.api.synchronizer.source.route.route_container import RouteContainer
from shinken.misc.type_hint import List, NoReturn


class TabContainer(object):
    
    def __init__(self, route_container):
        # type: (RouteContainer) -> None
        self._tabs = []  # type: List[AbstractTab]
        self._route_container = route_container
    
    
    def __iter__(self):
        return self._tabs.__iter__()
    
    
    def add(self, tab):
        # type: (AbstractTab) -> NoReturn
        self._tabs.append(tab)
        self._route_container.add(tab)
