'use strict';

SHINKEN_METRIC.Serie           = function ( data, type ) {
    // uuid
    // uuid_host
    // name
    // host_name
    // check_name
    // critical
    // warning
    // is_valid
    // status
    //dom_element;
    //color;
    //id
    this.type      = type;
    this.is_active = false;
    this.init( data );
};
SHINKEN_METRIC.Serie.prototype = {
    init                     : function ( data ) {
        this.id                  = SHINKEN_METRIC.GET_UUID();
        this.is_valid            = false;
        this.check_uuid          = data.uuid;
        this.uuid_host           = data.uuid_host;
        this.metric              = data.metric;
        this.host_name           = data.host_name;
        this.service_description = data.service_description;
        this.computeColor();
    },
    updateLabel              : function ( host_name, service_description ) {
        this.host_name           = host_name;
        this.service_description = service_description;
        this.buildHTML();
    },
    setStatus                : function ( status ) {
        this.status = status;
        if ( !DETAIL_GRAPHS_CALL ) {
            this.buildHTML();
        }
    },
    computeColor             : function () {
        var _metric_name = DETAIL_GRAPHS_CALL ? this.metric : this.metric.name;
        this.color       = get_color( this.host_name + this.service_description + _metric_name )[ 'start' ][ 1 ];
    },
    getName                  : function () {
        var _to_return = DETAIL_GRAPHS_CALL ? this.metric : this.metric.name;
        switch ( this.type ) {
            case SHINKEN_METRIC.CONST.SERIE.CRITICAL.KEY:
                _to_return += SHINKEN_METRIC.CONST.SERIE.CRITICAL.LABEL;
                break;
            case SHINKEN_METRIC.CONST.SERIE.WARNING.KEY:
                _to_return += SHINKEN_METRIC.CONST.SERIE.WARNING.LABEL;
                break;
        }
        return _to_return;
    },
    getFullName              : function () {
        var _to_return = this.host_name + ' - ' + this.service_description + ' - ' + this.metric.name;
        switch ( this.type ) {
            case SHINKEN_METRIC.CONST.SERIE.CRITICAL.KEY:
                _to_return += SHINKEN_METRIC.CONST.SERIE.CRITICAL.LABEL;
                break;
            case SHINKEN_METRIC.CONST.SERIE.WARNING.KEY:
                _to_return += SHINKEN_METRIC.CONST.SERIE.WARNING.LABEL;
                break;
        }
        return _to_return;
    },
    getClass                 : function () {
        var _to_return = "shinken-serie";
        switch ( this.type ) {
            case SHINKEN_METRIC.CONST.SERIE.CRITICAL.KEY:
            case SHINKEN_METRIC.CONST.SERIE.WARNING.KEY:
                _to_return += " is-threshold-" + this.type;
                break;
        }
        if ( !this.is_valid ) {
            _to_return += ' shinken-invalid';
        }
        return _to_return;
    },
    buildHTML                : function () {
        this.getDomElement().innerHTML = this.createCellPanelMetric().innerHTML;
    },
    createCellPanelMetric    : function () {
        var onclick          = "openPanelDetail(\'" + this.buildUrlMetric() + "\')";
        var _to_return       = DOM.Service.createElement( 'td', {
            id: this.id
        } );
        var metric_container = DOM.Service.createElement( 'div', {
            class              : this.getClass(),
            onclick            : onclick,
            onmouseenter       : "SHINKEN_TOOLTIP.showTooltip(this)",
            onmouseleave       : "SHINKEN_TOOLTIP.hideTooltip()",
            'shi-tip-text'     : this.getTooltip(),
            'shi-tip-timer-pop': 500
        } );
        var _to_add;
        switch ( this.status ) {
            case 404:
            case 401:
            case 500:
            case 512:
            case 513:
                _to_add = DOM.Service.createElement( 'span', { class: 'line shinkon-warning' } );
                break;
            case 403:
                _to_add = DOM.Service.createElement( 'span', { class: 'line shinkon-lock' } );
                break;
            default:
                _to_add = DOM.Service.createElement( 'span', {
                    class: 'line',
                    style: "background-color:" + this.color + "; border-color: " + this.color + ";"
                } );
        }
        var _to_add2 = DOM.Service.createElement( 'div', {
            class: 'full-name-metric',
            style: "color:" + this.color
            
        }, this.getFullName() );
        
        DOM.Service.addElementTo( _to_add, metric_container );
        DOM.Service.addElementTo( _to_add2, metric_container );
        DOM.Service.addElementTo( metric_container, _to_return );
        return _to_return;
    },
    buildUrlMetric           : function () {
        var _to_return = window.location.origin;
        _to_return += "/static/ui/index.html#";
        _to_return += "/dashboard/" + __dashboard_uuid;
        _to_return += "/detail/" + this.uuid_host + "/graphics/" + this.check_uuid;
        
        var _metric = {
            "metric"    : DETAIL_GRAPHS_CALL ? this.metric : this.metric.name,
            "check_uuid": this.check_uuid
        };
        
        if ( this.type !== SHINKEN_METRIC.CONST.SERIE.MAIN.KEY ) {
            _metric.threshold_type = this.type;
        }
        _to_return += "&&" + b64Encode( JSON.stringify( _metric ) );
        return _to_return;
    },
    setDomElement            : function ( to_set ) {
        this.dom_element = to_set;
        var _dom_label   = this.dom_element.querySelector( '.shinken-metric-label' );
        if ( _dom_label ) {
            this.dom_label = _dom_label;
        }
    },
    getDomLabel              : function () {
        return this.dom_label;
    },
    getDomElement            : function () {
        if ( !this.dom_element ) {
            this.dom_element = document.getElementById( this.id );
        }
        return this.dom_element;
    },
    getTooltip               : function () {
        var _to_return = "";
        switch ( this.status ) {
            case 401:
                _to_return = _( "unauthorized.401_text" );
                break;
            case 404:
                _to_return = _( "unauthorized.404_text" );
                break;
            case 403:
                _to_return = _( "unauthorized.403_text" );
                break;
            case 500:
                _to_return = _( "unauthorized.500_text" );
                break;
            case 512:
                _to_return = _( "unauthorized.512_text" );
                break;
            case 513:
                _to_return = _( "unauthorized.513_text" );
                break;
            default:
                switch ( this.type ) {
                    case SHINKEN_METRIC.CONST.SERIE.CRITICAL.KEY:
                        if ( !this.is_valid ) {
                            _to_return = _( "graphics.no_critical_metric" );
                        }
                        break;
                    case SHINKEN_METRIC.CONST.SERIE.WARNING.KEY:
                        if ( !this.is_valid ) {
                            _to_return = _( "graphics.no_warning_metric" );
                        }
                        break;
                    case SHINKEN_METRIC.CONST.SERIE.MAIN.KEY:
                        _to_return = _( "graphics.open_detail" );
                        break;
                }
        }
        return _to_return;
    },
    setIsValid               : function ( to_set ) {
        if ( DETAIL_GRAPHS_CALL ) {
            return;
        }
        if ( to_set === this.is_valid ) {
            return;
        }
        this.is_valid = to_set;
        this.buildHTML();
    },
    setActive                : function ( to_set ) {
        this.is_active = to_set;
        this.computeStyleLabel();
        if ( !this.is_active ) {
            this.removeSerie();
        }
    },
    isActive                 : function () {
        return this.is_active;
    },
    computeStyleThresholdLine: function () {
        var _line         = this.getDomElement().querySelector( '.shinken-line' );
        _line.style.color = this.color;
    },
    computeStyleLabel        : function () {
        if ( this.is_active ) {
            var rgb_color = hexToRgb( this.color );
            this.getDomElement().classList.add( 'active-serie' );
            this.getDomLabel().style.backgroundColor = "rgba(" + rgb_color.r + "," + rgb_color.g + "," + rgb_color.b + ",0.2)";
            this.getDomLabel().style.border          = "1px solid " + this.color;
        }
        else {
            this.getDomElement().classList.remove( 'active-serie' );
            this.getDomLabel().style.backgroundColor = "transparent";
            this.getDomLabel().style.borderColor     = "transparent";
        }
    },
    removeSerie              : function () {
        remove_metric( this.host_name, this.service_description, this.getName(), true );
    }
    
};