/*Copyright (C) 2009-2011 :
 Gabes Jean, naparuba@gmail.com
 Gerhard Lausser, Gerhard.Lausser@consol.de
 Gregory Starck, g.starck@gmail.com
 Hartmut Goebel, h.goebel@goebel-consult.de
 Andreas Karfusehr, andreas@karfusehr.de
 
 This file is part of Shinken.
 
 Shinken is free software: you can redistribute it and/or modify
 it under the terms of the GNU Affero General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.
 
 Shinken is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU Affero General Public License for more details.
 
 You should have received a copy of the GNU Affero General Public License
 along with Shinken.  If not, see <http://www.gnu.org/licenses/>.
 */

/* We must avoid $$() call for IE, so call a standad way*/
var impacts;

var __mapping_impacts = {};

/* We must avoid $$() call for IE, so call a standad way*/
var problems;

/* Keep a pointer to the currently open problem*/
var old_problem = null;
/* Keep the currently click impact */
var old_impact = null;

function toggleBox ( id ) {
    var impact = get_impact( id );
    
    // And fidn the panel we will slide
    var el = $( '#problems-' + id );
    
    // If we got an open problem, close it
    if ( old_problem != null && old_problem.attr( 'id' ) !== el.attr( 'id' ) ) {
        old_problem.hide();
        // And clean the active impact class too
        old_impact.classList.remove( "impact-active" );
    }
    
    old_problem = el;
    old_impact  = impact;
    
    if ( el.is( ':hidden' ) ) {
        el.fadeIn();
        impact.classList.add( "impact-active" );
        display_depgraph( id );
        
    }
    else {
        hide_depgraph( id );
        el.fadeOut();
        impact.classList.remove( "impact-active" );
    }
    
}

/* The business rules toggle buttons*/
function toggleBusinessElt ( hid, name ) {
    var btnClicked = document.getElementById( 'togglelink-' + name ),
        btnImg     = btnClicked.getElementsByTagName( 'img' ),
        btnTitle   = btnClicked.getElementsByClassName( 'title' ),
        toc        = document.getElementById( 'business-parents-' + hid + name ),
        imgLink    = document.getElementById( 'business-parents-img-' + hid + name );
    
    var img_src     = '/static/' + http_start_time + '/images/',
        img_src_old = '/static/images/';
    
    if ( toc && toc.style.display == 'none' ) {
        toc.style.display = 'block';
        if ( imgLink != null ) {
            imgLink.src = img_src_old + 'reduce.png';
        }
        btnImg[ 0 ].setAttribute( 'src', img_src + 'reduce.png' );
        btnTitle[ 0 ].innerHTML = _( 'dep_tree.hide_dep_tree' );
    }
    else {
        toc.style.display = 'none';
        if ( imgLink != null ) {
            imgLink.src = img_src_old + 'expand.png';
        }
        btnImg[ 0 ].setAttribute( 'src', img_src + 'expand.png' );
        btnTitle[ 0 ].innerHTML = _( 'dep_tree.show_dep_tree' );
    }
}


function get_impact ( id ) {
    return __mapping_impacts[ id ];
}

function display_depgraph ( id ) {
    var $depgraph = $( '#inner_depgraph-' + id );
    var elt_id    = $depgraph.attr( 'data-elt-id' ); // NOTE: uuid can be a 0000number, so .data() will change to an int
    $depgraph.empty();
    $depgraph.append( $( '<p id="spinner-depgraph-' + id + '"/>' ) );
    get_spinner( 'spinner-depgraph-' + id );
    $depgraph.load( '/inner/depgraph/' + elt_id + '?only_graph=1' );
}

function hide_depgraph ( id ) {
    var _dom_depgraph       = document.getElementById( 'inner_depgraph-' + id );
    _dom_depgraph.innerText = '';
    if ( __depgraph_loop_interval ) { //stop depgraph loop interval define in eltdeps.js
        clearInterval( __depgraph_loop_interval );
    }
}

function init_mapping_impact () {
    var _impacts = document.querySelectorAll( '.shinken-impact' );
    var _current;
    for ( var i = 0, _size = _impacts.length; i < _size; i++ ) {
        _current                                           = _impacts[ i ];
        __mapping_impacts[ _current.getAttribute( 'id' ) ] = _current;
    }
}

$( document ).ready( function () {
    init_mapping_impact();
    
    // This values is filled by teh /impact page. By default ti's -1
    // and so it do not ask for a default expand. But it will ask for the first value if
    // it's an bad state
    if ( impact_to_expand !== -1 ) {
        toggleBox( impact_to_expand );
    }
} );