CLIPBOARD_SERVICE = (function ( self ) {
    "use strict";
    self.dom_textarea     = document.querySelector( "#id-shinken-copy-clipboard-container" );
    self.dom_parent       = null;
    self.dom_button       = null;
    self.dom_text_to_copy = null;
    
    self.TYPE      = {};
    self.TYPE.TEXT = 'text';
    self.TYPE.HTML = 'html';
    
    self.setContent = function ( dom_element, type ) {
        initDomElement( dom_element );
        if ( !self.dom_parent || !self.dom_text_to_copy ) {
            displayResult( false );
            return;
        }
        var _value;
        
        switch ( type ) {
            case self.TYPE.TEXT:
                _value = self.dom_text_to_copy.innerText;
                break;
            case self.TYPE.HTML:
                _value = self.dom_text_to_copy.outerHTML;
                break;
        }
        
        setValueTextArea( _value );
        self.dom_textarea.select();
        var status = false;
        try {
            status = document.execCommand( 'copy' );
            displayResult( status );
            setValueTextArea( '' );
        }
        catch ( err ) {
            console.log( 'Unable to copy.' );
        }
    };
    //private
    function initDomElement ( dom_element ) {
        setDomButton( dom_element );
        self.dom_parent = findParentElementWithClass( dom_element, "shinken-parent-text-to-copy", 5 );
        if ( !self.dom_parent ) {
            return;
        }
        self.dom_text_to_copy = self.dom_parent.querySelector( ".shinken-text-to-copy" );
    }
    
    function setDomButton ( to_set ) {
        self.dom_button = to_set;
    }
    
    function setValueTextArea ( to_set ) {
        if ( !self.dom_textarea ) {
            self.dom_textarea = document.querySelector( "#id-shinken-copy-clipboard-container" );
        }
        self.dom_textarea.value = to_set;
    }
    
    function getTextAreaFocus () {
        if ( !self.dom_textarea ) {
            self.dom_textarea = document.querySelector( "#id-shinken-copy-clipboard-container" );
        }
        //self.dom_textarea.focus();
    }
    
    function displayResult ( status ) {
        self.dom_button.dataset[ 'statusCopy' ] = status ? '1' : '2';
        self.dom_button.classList.toggle( "IE-PATCH" );
        
        var _tmp_button = self.dom_button;
        setTimeout( function () {
            _tmp_button.dataset[ 'statusCopy' ] = '0';
            _tmp_button.classList.toggle( "IE-PATCH" );
        }, 2000 );
    }
    
    function findParentElementWithClass ( element, class_to_find, deepLimit ) {
        if ( !element ) {
            return null;
        }
        if ( deepLimit < 0 ) {
            return null;
        }
        if ( element.classList.contains( class_to_find ) ) {
            return element;
        }
        deepLimit--;
        return findParentElementWithClass( element.parentElement, class_to_find, deepLimit );
    }
    
    return self;
    
})( {} );