#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.


from ....front_end.helper_object import COUNTER
from ....front_end.helper import natural_keys

class MassiveChangeDetail(object):
    
    def __init__(self, item_type, app):
        self.item_type = item_type
        self.app = app
        self.elements = []
        self.size_elements = 0
        self.error_counter = 0
        self.warning_counter = 0
    
    
    def add_element(self, to_add):
        self.elements.append(to_add)
        self.error_counter += to_add.error_counter
        self.warning_counter += to_add.warning_counter
        self.size_elements += 1
        
    def get_counter_content(self):
        counters_values = {COUNTER.ERROR: self.error_counter or "", COUNTER.WARNING: self.warning_counter or ""}
        counters_labels = {COUNTER.ERROR: self.app._('mass-change.input.counters.ERROR'), COUNTER.WARNING:  self.app._('mass-change.input.counters.WARNING')}
        return self.app.helper.helper_object.get_counters_html(counters=[COUNTER.ERROR, COUNTER.WARNING], counters_value=counters_values, counters_labels=counters_labels)

    def sort_by_name(self):
        self.elements.sort(key=lambda k: natural_keys(k.name))
    
