#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2013-2019:
#
# This file is part of Shinken Enterprise, all rights reserved.
from ..dao.def_items import METADATA, NO_HERITABLE_ATTR, ITEM_TYPE
from shinken.util import make_unicode
from shinken.log import logger

class EXTRA_CLASS_ON_PROPERTY:
    INHERIT_SERVICE_OVERRIDE = 'inherit-service-override'


class HelperProperty(object):
    app = None  # Will be filled in by Helper
    
    
    def __init__(self, app, helper):
        self.app = app
        self.helper = helper
    
    
    def _service_overrides_value_is_from_template(self, item_prop, shinken_element_original):
        return bool(METADATA.get_metadata(shinken_element_original, METADATA.FROM, {}).get(item_prop, False) if shinken_element_original else False)
    
    
    def _get_link_from_service_overrides(self, flat_value, item_prop, shinken_element_original):
        link = flat_value
        from_value = METADATA.get_metadata(shinken_element_original, METADATA.FROM, {}).get(item_prop, {}) if shinken_element_original else {}
        
        if from_value:
            link = '<span class="shinken-value-from-template">%s <br>%s <a href="/elements/%s/%s" draggable="false" class="title shinken-link" target="_blank" >%s</a></span><span class="shinken-value-from-check"></span>' % (
                flat_value, self.app._('element.from_template_so'), from_value['item_type'], from_value['item_id'], from_value['item_name'])
        return link
    
    
    def _get_service_overrides_from(self, item_prop, shinken_element_original, is_placeholder=False):
        form_value = METADATA.get_metadata(shinken_element_original, METADATA.FROM, {}).get(item_prop, {}) if shinken_element_original else {}
        if form_value:
            if is_placeholder:
                link = "%s" % self.app._('element.from_template_so')
            else:
                link = "<span class='shinken-overrided-in-template'>%s</span>" % self.app._('element.from_template_so')
        else:
            link = self.app._('element.in_check')
        return link
    
    
    def build_final_prop_name(self, item, item_prop, override=False):
        _to_return = item_prop
        if override:
            _to_return = 'override-%s-%s' % (METADATA.get_metadata(item, METADATA.WINDOW_UUID, METADATA.get_metadata(item, METADATA.NAME)), item_prop)
        return _to_return
    
    
    def get_template_html(self, extra_tooltip=''):
        return '<td class ="shinken-prop-cell-template" %s><div class=""><div class="from-template"></div></div></td>' % extra_tooltip
    
    
    def get_default_string_html(self, value, type):
        label = 'unknown'
        if type == 'default':
            label = self.app._('element.default')
        if type == 'forced':
            label = self.app._('element.forced_default')
        if type == 'inherited':
            label = self.app._('element.inherited_from_template')
        return '<span class="shinken-default-label shinken-type-%s">%s</span> %s' % (type, label, value)
    
    
    def get_override_flat_value_html(self, flat_value, item_prop, shinken_element_original, data_unit=""):
        return '<td class="shinken-override-cell-value"><div class="shinken-flat-check-value">%s%s</div></td>' % (self._get_link_from_service_overrides(flat_value, item_prop, shinken_element_original), data_unit)
    
    
    def get_root_property_html(self, item, item_type, item_prop, type, default, required, custom_selected, class_to_add, default_label=False, is_order_kept=False,
                               none_label=False, state_plus="-1", item_type_select=False, extra_class="", unit='', original=False, extra_attr='', link_id='', hide_import_key=0, is_set=None, mass_change=False):
        is_override = True if original else False
        
        item_prop_name_final = self.build_final_prop_name(original, item_prop, is_override)
        
        is_not_heritable_label = ""
        if not ITEM_TYPE.has_template(item_type) or item_prop in NO_HERITABLE_ATTR:
            is_not_heritable_label = "true"
        
        if is_override:
            extra_class = extra_class + ' ' + EXTRA_CLASS_ON_PROPERTY.INHERIT_SERVICE_OVERRIDE if self._service_overrides_value_is_from_template(item_prop, original) else extra_class
        
        _controller = "mass-change" if mass_change else "shinken-element"
        
        _to_return = []
        _to_return.append('''onmouseenter="MANAGER.EventManager.mouseEnter(event)"''')
        _to_return.append('''onmouseleave="MANAGER.EventManager.mouseLeave(event)"''')
        _to_return.append('''onclick="MANAGER.EventManager.onClick(event)"''')
        _to_return.append('''data-controller="%s"''' % _controller)
        _to_return.append('''class="shinken-element-property-line shinken-parent-event-listener %s %s"''' % (class_to_add, extra_class))
        _to_return.append('''data-type="%s"''' % type)
        if required:
            _to_return.append('''data-is-required="1"''')
        _to_return.append('''data-is-ordered="%s"''' % ("1" if is_order_kept else "0"))
        _to_return.append('''data-name="%s"''' % item_prop_name_final)
        if is_override:
            _to_return.append('''data-override-element-name="%s"''' % make_unicode(METADATA.get_metadata(original, METADATA.NAME)))
            _to_return.append('''data-override-dfe-name="%s"''' % make_unicode(METADATA.get_metadata(original, METADATA.DFE_NAME)))
            _to_return.append('''data-override-element-uuid="%s"''' % item['_id'])
            _to_return.append('''data-override-prop-name="%s"''' % item_prop)
            _to_return.append('''data-override="true"''')
        _to_return.append('''data-state="init"''')
        if mass_change:
            _to_return.append('''%s''' % self.helper.mass_change_helper.get_cell_mass_change_root_default_data())
        _to_return.append('''data-state-input=""''')
        _to_return.append('''data-unit="%s"''' % unit)
        if is_set is not None:
            _to_return.append('''data-is-set="%s"''' % is_set)
        _to_return.append('''data-is-prop-not-heritable="%s"''' % is_not_heritable_label)
        _to_return.append('''data-default-value="%s"''' % default)
        _to_return.append('''data-custom-selected="%s"''' % custom_selected)
        _to_return.append('''%s''' % extra_attr)
        if item_type_select:
            _to_return.append('''data-item-type="%s"''' % item_type_select)
        _to_return.append('''data-link-id="%s"''' % link_id)
        _to_return.append('''data-state-inheritance="-1"''')
        _to_return.append('''data-hide-import-key="%s"''' % hide_import_key)
        if default_label:
            _to_return.append('''data-default-label="%s"''' % default_label)
        if none_label:
            _to_return.append('''data-none-label="%s"''' % none_label)
        _to_return.append('''data-state-plus="%s"''' % state_plus)
        return ' '.join(_to_return)


    def get_cell_label_property_html(self, item_prop_label, required=False, has_delete_btn=False, mass_change=False, attribute_to_add="", class_to_add=""):
        delete_bpn = '''<td><span class="shinkon-times-bold shinken-delete-data-icon" onclick="MANAGER.EventManager.clickOnDeletePropertyBtn(this)"></span></td>''' if has_delete_btn else ''
        html_if_required = '''<span style="color:red">*</span>''' if required else ''
    
        _to_return = '''
            <td class="shinken-prop-cell-label %(class_to_add)s" %(attribute_to_add)s >
                <div class="shinken-div-inline-block shinken-prop-cell-label-container">
                    <table>
                        <tr>%(delete_bpn)s
                            <td class="shinken-property-label">
                                <span class="shinken-counter shinken-error-counter" data-number=""><span class="shinken-counter-label"></span></span>
                                <span class="shinken-counter shinken-warning-counter" data-number=""><span class="shinken-counter-label"></span></span>
                                <span class="shinken-label">%(item_prop_label)s %(html_if_required)s
                                </span>
                            </td>
                        </tr>
                        <tr><td>
                                <span class="shinken-information-tag" onmouseenter="SHINKEN_TOOLTIP.showTooltip(this)" onmouseleave="SHINKEN_TOOLTIP.hideTooltip()" shi-tip-html="">
                                    <span class="shinken-label-information"></span><span class="shinken-tag-mark">?</span>
                                </span>
                        </td></tr>
                    </table>
                </div>
                <span class="shinken-tag-help" onclick="MANAGER.EventManager.clickOnForcedHelpButton(event,this)">?</span>
            </td> ''' % locals()
        return _to_return
    
    
    def get_value_with_style(self, prop_value):
        extra_class = ""
        if prop_value == self.app._('element.password_protected'):
            extra_class = "protected-password"
        
        return '''<span class="%s">%s</span''' % (extra_class, prop_value)
