'use strict';
var SHINKEN = {};
SHINKEN.DOM = {};
SHINKEN.MODAL     = {};
SHINKEN.NAVIGATOR = {};
SHINKEN.PAGE      = {};
SHINKEN.TOOLS            = {};
SHINKEN.TOOLS.ARRAY      = {};
SHINKEN.TOOLS.ENCRYPTION = {};
SHINKEN.OBJECT           = {};
var DOM   = {};
DOM.CONST = {};
SHINKEN.CONST = {
    KEY_CODE : {
        TAB   : 9,
        ENTER : 13,
        ESCAPE: 27,
        SPACE : 32,
        LEFT  : 37,
        UP    : 38,
        RIGHT : 39,
        DOWN  : 40,
        F1    : 112
    },
    CLASS_CSS: {
        PULSATE: 'shinken-pulsate'
    }
};
SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin = function ( link, id, label, _class, tooltip ) {
    if ( MANAGER.__instance_element_distributor.current_user.is_admin && link && id ) {
        return SHINKEN.TOOLS.buildLinkDomElement( link, id, label, _class, tooltip );
    }
    if ( !_class ) {
        _class = "title shinken-space";
    }
    var _to_return = DOM.Service.createElement( 'span', { class: _class }, label );
    DOM.Service.addTooltip( _to_return, tooltip );
    return _to_return;
};
SHINKEN.TOOLS.buildLinkDomElement              = function ( link, id, label, _class, tooltip ) {
    var _href = "/elements/" + link + '/' + id;
    if ( !_class ) {
        _class = "title shinken-link shinken-space";
    }
    var _to_return = DOM.Service.createElement( 'a', { class: _class, href: _href, draggable: 'false', target: "_blank", onclick: "MANAGER.EventManager.mutePropagation(event)" }, '<span class="shinken-tag-label">' + label + '</span>' );
    DOM.Service.addTooltip( _to_return, tooltip );
    return _to_return;
};
SHINKEN.TOOLS.buildLinkShinkenElement          = function ( element, label, _class, tooltip ) {
    var _uuid = element.uuid;
    if ( element.isNew() ) {
        _uuid += '?new=1';
    }
    if ( !label ) {
        label = element.getName();
    }
    return SHINKEN.TOOLS.buildLinkDomElementDependIfAdmin( element.getType(), _uuid, label, _class, tooltip );
};
var COMMUNICATION               = {};
COMMUNICATION.MESSAGE           = {};
COMMUNICATION.QUERY             = {};
COMMUNICATION.MESSAGE.SUCCESS   = 'success';
COMMUNICATION.MESSAGE.ERROR     = 'error';
COMMUNICATION.MESSAGE.WARNING   = 'warning';
COMMUNICATION.CODE              = {};
COMMUNICATION.CODE.SUCCESS      = 200;
COMMUNICATION.CODE.WARNING      = 202;
COMMUNICATION.CODE.UNAUTHORIZED = 401;
COMMUNICATION.RETURN_CODE       = {
    ELEMENT_UNKNOWN: "element-unknown"
};
COMMUNICATION.QUERY.GET = {
    SEPARATOR  : {
        GET_BEGINNER: '?',
        GET_ADD     : '&',
        PARAM_SETTER: '=',
        SLASH       : '/'
    },
    SOURCE     : {
        LIST                 : {
            URL    : "/api/sources",
            OPTIONS: {
                TIMESTAMP: "?ts="
            }
        },
        SET_ORDER            : {
            URL    : "/api/sources/setorder",
            OPTIONS: {
                TIMESTAMP: "?ts=",
                ORDER    : "&order="
            }
        },
        REFRESH              : {
            URL    : "/api/sources",
            OPTIONS: {
                TIMESTAMP: "?ts="
            }
        },
        SET_ENABLED          : {
            URL    : "/api/sources/setenabled",
            OPTIONS: {
                TIMESTAMP  : "?ts=",
                SOURCE_NAME: "&sname=",
                ENABLED    : "&enabled="
            },
            CONST  : {
                ENABLED : '1',
                DISABLED: '0'
            }
        },
        SET_DISCOVERY_ENABLED: {
            URL    : "/api/sources/conf/setenabled",
            OPTIONS: {
                TIMESTAMP  : "?ts=",
                SOURCE_NAME: "&source_name=",
                CONF_ID    : "&conf_id=",
                ENABLED    : "&enabled="
            },
            CONST  : {
                ENABLED : '1',
                DISABLED: '0'
            }
        },
        FORCE_IMPORT         : {
            URL    : "/api/sources/forceimport/",
            OPTIONS: {
                TIMESTAMP: "?ts="
            }
        },
        CLEAN_IMPORT         : {
            URL    : "/api/sources/cleanimport/",
            OPTIONS: {
                TIMESTAMP: "?ts="
            }
        },
        REFRESH_UNIQUE       : {
            URL    : "/api/sources/unique_source/",
            OPTIONS: {
                TIMESTAMP: "?ts="
            }
        },
        ANALYZER             : {
            LAUNCH_BATCH      : "/api/analyzers/launch_analyze_batch",
            STOP_ANALYSE_BATCH: "/api/analyzers/stop_analyze_batch",
            GET_RESULTS       : "/api/analyzers/get_analyze_jobs_result"
        },
        REDIRECT_DETAIL      : {
            URL    : "/sources/",
            OPTIONS: {
                TAB_DETAIL         : "tab=tab-detail-last-run",
                TAB_SUMMARY_OLD_RUN: "tab=tab-summary-old-run",
                FILTER_STATUS      : "filter=status:"
            }
        }
    },
    OVERRIDE   : {
        BASE: '/elements/service_overrides/'
    },
    MASS_CHANGE: {
        BASE: "/elements/massive_change/",
        PROGRESS_BAR: "/elements/massive_change_progress/"
    }
};
COMMUNICATION.PAGE_TYPE = {
    LIST_ALL_ELEMENT : "list-all-element",
    LIST_WORKING_AREA: "list-working-area"
};
var COMPONENT = {};
COMPONENT.CONST = {
    NOT_FOUND               : -1,
    BTN_STATE               : {
        DISABLED: -1,
        OFF     : 0,
        ON      : 1,
        DISCREET: 2,
        INIT    : 3
    },
    AUTO_SELECT_ACTION_TYPE : {
        MOVE_DOWN : 'move_down',
        MOVE_UP   : 'move_up',
        MOUSE     : 'mouse',
        KEY_INPUT : 'key_input'
    },
    BTN_NAME                : {
        SAVE: 'save'
    },
    SELECT                  : {
        SELECTOR                    : 'shinken-select-selector',
        SELECTOR_TEXT               : 'shinken-selector-label',
        SELECTOR_LIST               : 'shinken-list-select',
        SELECTOR_LIST_OPTION        : 'shinken-option',
        OPTION_ACTIVE_STAGING       : 'shinken-active-option-staging',
        OPTION_ACTIVE_WORKING_AREA  : 'shinken-active-option-working-area',
        DATA_STATE_SELECTOR         : 'stateSelector',
        TIMER_DELAY_BUILD_HTML      : 100
    },
    BTN_INHERITANCE         : {
        TIMER_DELAY_BUILD_HTML: 100
    },
    INHERITANCE_ARBORESCENCE: {},
    TAG                     : {
        STATE: {
            WORKING         : 'working_area',
            NEW             : 'new',
            STAGGING        : 'stagging',
            DISABLED        : 'disabled',
            UNKNOWN         : 'unknown',
            HIDDEN          : 'hidden',
            INHERITED       : 'inherited',
            FORCE_TO_NULL   : 'force-to-null',
            OVERRIDE_NEW    : 'override-new',
            OVERRIDE_UNKNOWN: 'override-unknown'
        }
    },
    FILTER                  : {
        TYPES_VALIDATION: {
            HAS_FOCUS: "has_focus",
            NOT_FOCUS: "not_focus"
        }
    },
    INPUT                   : {
        TYPES: {
            SINGLE_SELECT: 'single-select'
        }
    },
    LIST_SELECT             : {
        CLASS: {
            NO_RESULT   : 'shinken-no-result',
            FILTERING_ON: 'shinken-filtering-on'
        }
    },
    LIST_SELECT_ELEMENT     : {
        CLASS: {
            HIDDEN: 'shinken-hidden'
        }
    },
    BTN_RADIO               : {
        CLASS: {
            SHINKEN_BUTTON_ACTIVE  : 'shinken-active',
            SHINKEN_BUTTON_DISABLED: 'shinken-disabled'
        }
    },
    STATUS                  : {
        NONE   : 'shinken-no-status',
        INFO   : 'shinken-info',
        ERROR  : 'shinken-error-status',
        WARNING: 'shinken-warning-status',
        BEWARE : 'shinken-beware-status'
    },
    TAG_INFORMATION         : {
        STATUS: {
            NONE                 : 'none',
            ALL_DISABLED         : 'all-disabled',
            ALL_DISABLED_OVERRIDE: 'all-disabled-override',
            NOT_VALID_FOR_ARBITER: 'not-arbiter-valid',
            USER_GROUP_COHERENCY : 'user-group-coherency',
            IN_SHELL             : 'in_shell',
            CHECK_DUPLICATE      : 'check_duplicate'
        }
    }
};
var SHINKEN_LIST = {};
SHINKEN_LIST.CONST = {
    MASS_ACTION: {
        NAME          : 'mass-action',
        WORK_AREA_NAME: 'mass-action-work-area'
    },
    TYPE       : {
        CHECK_IN_HOST       : "CHECK_IN_HOST",
        MASS_CHANGE_SUM_FULL: "MASS_CHANGE_SUM_FULL",
        DATA_PROP           : "DATA_PROP"
    },
    FILTER     : {
        HAS_CHILDREN: "**SHINKEN_HAS_CHILDREN**",
        ALL         : "___ALL___",
        EMPTY       : "___EMPTY___",
        NOT_EMPTY   : "___NOT_EMPTY___",
        STATUS      : {
            DISABLED    : -1,
            OFF         : 0,
            ON          : 1,
            HAS_CHILDREN: 2
        },
        TYPE        : {
            INPUT_STRING_ARRAY: "input_string_array"
        }
    },
    SELECTION  : {
        STATUS: {
            DISABLED: -1,
            OFF     : 0,
            ON      : 1
        }
    }
};
var MANAGER = {};
MANAGER.CONST = {
    STATE       : {
        WORK_FLOW: {
            STAGING     : 'save-direct-in-staging',
            WORKING_AREA: 'save-in-working-area'
        }
    },
    DRAG_N_DROP : {
        CLASS: {
            HOVER    : 'hover',
            DRAGGABLE: 'draggable',
            DRAGGING : 'shinken-dragging-on'
        }
    },
    HELP        : {
        STATUS: {
            INACTIVE: 1,
            ACTIVE  : 2,
            FORCED  : 3
        }
    },
    AFTER_ACTION: {
        CLICK_ON_SERVICE_OVERRIDE    : 0,
        CLICK_ON_WINDOW_DATA_OVERRIDE: 1
    },
    CONTROLLER  : {
        SHINKEN_ELEMENT: 'shinken-element',
        LIST_ALL       : 'list-all',
        MASS_CHANGE    : 'mass-change',
        SOURCES        : 'Sources'
    }
};
var OBJECT = {};
OBJECT.CONST = {
    TEMPLATE             : {
        FIELD : {
            UUID             : 'uuid',
            _ID              : '_id',
            _SYNC_KEYS       : '_SYNC_KEYS',
            NAME             : 'name',
            IS_TEMPLATE      : 'is_template',
            IS_TOP_LEVEL     : 'is_top_level',
            ITEM_TYPE        : 'item_type',
            LAST_MODIFICATION: 'last_modification',
            REGISTER         : 'register',
            SOURCES          : 'sources',
            USE              : 'use',
            ENABLED          : 'enabled',
            UNCONFIGURED     : 'unconfigured',
            STATUS           : 'template-status',
            IS_NEW           : 'is_new',
            LOOP             : 'loop',
            WORK_AREA_INFO   : 'work_area_info',
            METADATA         : '@metadata'
        },
        STATUS: {
            USEFUL  : 'useful-template',
            USELESS : 'useless-template',
            BADLOOP : 'badloop-template',
            NEW     : 'new-template',
            UNKNOWN : 'unknown-template',
            DISABLED: 'disabled-template'
        }
    },
    ELEMENT_LIST         : {
        TYPE: {
            USER       : 'user',
            INHERITANCE: 'inheritance',
            SEARCHING  : 'searching'
        }
    },
    MACRO                : {
        TYPE: {
            HOST_LOCAL        : '_HOST',
            SERVICE_LOCAL     : '_SERVICE',
            HOST_PROPERTY     : 'macros_host_properties',
            SERVICE_PROPERTY  : 'macros_service_properties',
            GLOBAL            : 'macros_global',
            GLOBAL_INTERPRETED: 'macros_global_interpreted',
            UNKNOWN           : 'unknown',
            VALUE_DFE         : 'VALUE_DFE',
            DFE_KEY           : '$KEY$'
        }
    },
    CHECK_IN_HOST        : {
        STATUS: {
            NONE                           : "",
            DFE_STRUCTURE                  : 'dfe-structure',
            ALREADY_EXISTING_NAME          : "already_existing_name",
            ALREADY_EXISTING_NAME_IN_SAME  : "already_existing_name_in_same_host",
            ALREADY_EXISTING_NAME_DUPLICATE: "already_existing_name_duplicate"
        }
    },
    ELEMENT              : {
        PHASE           : {
            INIT         : 0,
            VIEWING      : 1,
            EDITING      : 2,
            ON_SAVING    : 3,
            SAVING_FAILED: 4,
            RELOADING    : 5
        },
        FIELD           : {
            ID                    : '_id',
            UUID                  : 'uuid',
            SOURCES               : 'sources',
            IMPORT_DATE           : 'import_date',
            SERVICE_OVERRIDES     : 'service_overrides',
            SERVICE_EXCLUDES_BY_ID: 'service_excludes_by_id',
            WORK_AREA_INFO        : 'work_area_info',
            SYNC_KEYS             : '_SYNC_KEYS ',
            LAST_MODIFICATION     : 'last_modification',
            ENABLED               : 'enabled',
            STATUS                : 'status',
            ITEM_TYPE             : 'item_type'
        },
        MODULATION      : {
            TYPE: {
                NONE_FORCED: -1,
                NONE       : 0,
                PLUS       : 1,
                EXISTING   : 2,
                ERROR      : 3
            }
        },
        TYPE            : {
            CLUSTERS                  : 'clusters',
            CLUSTER_TPLS              : 'clustertpls',
            DISCOVERY                 : 'discovery',
            HOSTS                     : 'hosts',
            HOST_GROUPS               : 'hostgroups',
            HOST_TPLS                 : 'hosttpls',
            CHECK_ON_HOST             : 'serviceshosts',
            CHECK_ON_TPL_HOST         : 'serviceshosttpls',
            CHECK_ON_CLUSTER          : 'servicesclusters',
            CHECK_ON_TPL_CLUSTER      : 'servicesclustertpls',
            CHECK_TPLS                : 'servicetpls',
            COMMANDS                  : 'commands',
            CONTACT_GROUPS            : 'contactgroups',
            CONTACT_TPLS              : 'contacttpls',
            CONTACTS                  : 'contacts',
            ESCALATIONS               : 'escalations',
            MODULATION_BUSINESS_IMPACT: 'businessimpactmodulations',
            MODULATION_DATA           : 'macromodulations',
            MODULATION_RESULT         : 'resultmodulations',
            NOTIFICATION_WAYS         : 'notificationways',
            TIME_PERIODS              : 'timeperiods',
            SYNCHRONIZER_LINKER       : 'sync'
        },
        WORK_AREA_STATUS: {
            PROPOSED : 'PROPOSED',
            WORKING  : 'WORKING',
            REJECTED : 'REJECTED',
            VALIDATED: 'VALIDATED'
            
        },
        STATUS          : {
            NEW: 'new'
        },
        SAVE            : {
            TYPE: {
                LINK: "LINK"
            }
        }
    },
    OVERRIDE_STATUS      : {
        OFF: "0",
        ON : "1",
        DISABLED : "2"
    },
    MODE_OVERRIDE_EXCLUDE: {
        NORMAL  : "0",
        OVERRIDE: "1",
        EXCLUDE : "2"
    },
    EXCLUDE_STATUS       : {
        OFF    : "0",
        BY_ID  : "1",
        BY_NAME: "2"
    }
};
var PROPERTY = {};
PROPERTY.CONST = {
    NAME                  : {
        ACTIVE_CHECKS_ENABLED          : 'active_checks_enabled',
        ACL_MAKE_DOWNTIME              : 'acl_make_downtime',
        ACL_MAKE_ACKNOWLEDGE           : 'acl_make_acknowledge',
        ACL_FORCE_RESULT_CHECK         : 'acl_force_result_check',
        ACL_FORCE_RETRY_CHECK          : 'acl_force_retry_check',
        ACL_IN_TAB_HISTORY             : 'acl_in_tab_history',
        ACL_SHOW_HISTORY_RANGE         : 'acl_show_history_range',
        ACL_SHOW_SLA_RANGE             : 'acl_show_sla_range',
        ACL_TRY_CHECK_ON_SYNCHRONIZER  : 'acl_try_check_on_synchronizer',
        ACL_TRY_CHECK_ON_POLLER        : 'acl_try_check_on_poller',
        ADDRESS                        : 'address',
        ADVANCED_TIME_PERIODS          : 'advanced_time_periods',
        BP_RULE                        : 'bp_rule',
        BUSINESS_IMPACT                : 'business_impact',
        BUSINESS_IMPACT_MODULATIONS    : 'business_impact_modulations',
        BUSINESS_IMPACT_MODULATION_NAME: 'business_impact_modulation_name',
        CAN_SUBMIT_COMMANDS            : 'can_submit_commands',
        CHECK_COMMAND                  : 'check_command',
        CHECK_COMMAND_ARGS             : 'check_command_args',
        CHECK_INTERVAL                 : 'check_interval',
        CHECK_PERIOD                   : 'check_period',
        CHECK_RUNNING_TIMEOUT          : 'check_running_timeout',
        COMMAND_NAME                   : 'command_name',
        COMMAND_LINE                   : 'command_line',
        CONTACTS                       : 'contacts',
        CONTACT_NAME                   : 'contact_name',
        CONTACT_GROUPS                 : 'contact_groups',
        CONTACTGROUP_NAME              : 'contactgroup_name',
        CONTACTGROUPS                  : 'contactgroups',
        DEFAULT_VALUE                  : 'default_value',
        DEFINITION_ORDER               : 'definition_order',
        DISPLAY_NAME                   : 'display_name',
        DUPLICATE_FOREACH_NAME         : 'duplicate_foreach',
        ENABLED                        : 'enabled',
        ESCALATIONS                    : 'escalations',
        ESCALATION_NAME                : 'escalation_name',
        ESCALATION_OPTIONS             : 'escalation_options',
        EDITION_CONTACTS               : 'edition_contacts',
        EDITION_CONTACT_GROUPS         : 'edition_contact_groups',
        EVENT_HANDLER                  : 'event_handler',
        FIRST_NOTIFICATION_DELAY       : 'first_notification_delay',
        FIRST_NOTIFICATION_TIME        : 'first_notification_time',
        FLAP_DETECTION_OPTIONS         : 'flap_detection_options',
        FRESHNESS_THRESHOLD            : 'freshness_threshold',
        HOST_NAME                      : 'host_name',
        HOST_NOTIFICATION_OPTIONS      : 'host_notification_options',
        HOST_NOTIFICATION_PERIOD       : 'host_notification_period',
        HOSTGROUPS                     : 'hostgroups',
        HOSTGROUP_NAME                 : 'hostgroup_name',
        IP_RANGE                       : 'iprange',
        IS_CLUSTER                     : 'is_cluster',
        LOW_FLAP_THRESHOLD             : 'low_flap_threshold',
        LAST_NOTIFICATION_TIME         : 'last_notification_time',
        HIGH_FLAP_THRESHOLD            : 'high_flap_threshold',
        SLA_WARNING_THRESHOLD          : 'sla_warning_threshold',
        SLA_CRITICAL_THRESHOLD         : 'sla_critical_threshold',
        MACRO_MODULATIONS              : 'macromodulations',
        MACROMODULATION_NAME           : 'macromodulation_name',
        MAINTENANCE_PERIOD             : 'maintenance_period',
        MAX_CHECK_ATTEMPTS             : 'max_check_attempts',
        NAME                           : 'name',
        NOTE_URL                       : 'notes_url',
        NOTE_MULTI_URL                 : 'notes_multi_url',
        NOTIFICATIONS_ENABLED          : 'notifications_enabled',
        NOTIFICATION_PERIOD            : 'notification_period',
        NOTIFICATIONWAY_NAME           : 'notificationway_name',
        NOTIFICATIONWAYS               : 'notificationways',
        PACK                           : 'pack',
        PERIOD_ADVANCED_NAME           : 'period_advanced_type',
        PERIOD_DAY_NAME                : 'period_day_type',
        POLLER_TAG                     : 'poller_tag',
        PREFIX                         : 'prefix',
        REACTIONNER_TAG                : 'reactionner_tag',
        RESULTMODULATION_NAME          : 'resultmodulation_name',
        RETRY_INTERVAL                 : 'retry_interval',
        NOTIFICATION_OPTIONS           : 'notification_options',
        NOTIFICATION_CONTACTS          : 'notification_contacts',
        NOTIFICATION_CONTACT_GROUPS    : 'notification_contact_groups',
        NOTIFICATION_INTERVAL          : 'notification_interval',
        OUTPUT_RULES                   : 'output_rules',
        PARENTS                        : 'parents',
        PORT_RANGE                     : 'port_range',
        RESULT_MODULATIONS             : 'resultmodulations',
        SERVICE_NOTIFICATION_OPTIONS   : 'service_notification_options',
        SERVICE_DESCRIPTION            : 'service_description',
        SERVICE_EXCLUDES               : 'service_excludes',
        SHELL_EXECUTION                : 'shell_execution',
        SYNC_NAME                      : 'sync_name',
        TIMEPERIOD_NAME                : 'timeperiod_name',
        TIMEPERIODS                    : 'timeperiods',
        TIMEOUT                        : 'timeout',
        USE                            : 'use',
        VIEW_CONTACTS                  : 'view_contacts',
        VIEW_CONTACT_GROUPS            : 'view_contact_groups',
        WARNING_THRESHOLD_CPU_USAGE    : 'warning_threshold_cpu_usage',
        TIMEPERIOD_DAYS                : {
            MONDAY   : "monday",
            TUESDAY  : "tuesday",
            WEDNESDAY: "wednesday",
            THURSDAY : "thursday",
            FRIDAY   : "friday",
            SATURDAY : "saturday",
            SUNDAY   : "sunday"
        }
    },
    TYPES                 : {
        BOOLEAN                   : 'boolean',
        DATA                      : 'data',
        MULTI_SELECT              : 'select-multi',
        RANGE                     : 'range',
        RANGE_BUSINESS_IMPACT     : 'range_business_impact',
        RANGE_WITH_INPUT          : 'range_with_input',
        SINGLE_SELECT             : 'select-single',
        SINGLE_SELECT_WITH_INPUT  : 'select-single-with-input',
        STRING_INPUT              : 'input_string',
        STRING_INPUT_WITH_DROPDOWN: 'input-string-with-dropdown',
        CHECKBOX_SINGLE           : 'checkbox-single',
        CHECKBOX_MULTI            : 'checkbox-multi',
        MULTI_LINE_OBJECT         : 'multi-line-object'
    },
    CLASS                 : {
        SKINKEN_LINE: 'shinken-element-property-line'
    },
    DEFAULT_BUTTON_LABEL  : 'default_button',
    BUTTON_LABEL          : {
        DEFAULT          : 'default_button',
        NULL             : 'null_button',
        NO_OVERRIDE      : 'no_override_button',
        USER_SET         : 'user_set_button',
        COPY_TO_CLIPBOARD: 'copy_to_clipboard_button',
        SET_DOM_EDITABLE : 'set_dom_editable',
        INHERITANCE      : 'inheritance_button',
        ADD              : 'add_button',
        TARGET_URL       : 'target_url_button',
        REMOVE           : 'remove_button'
    },
    STATE_PROPERTY        : {
        INHERITANCE_AND_USER          : 'inheritance-and-user-and-plus',
        INHERITANCE                   : 'inheritance-only',
        USER_SET                      : 'user-set',
        USER_SET_NONE                 : 'user-set-none',
        USER_FORCED_DEFAULT           : 'user-default-forced',
        USER_SET_MASS_CHANGE_PLUS_ONLY: 'user-set-mass-change-plus-only',
        OVERRIDE                      : 'override-only',
        OVERRIDE_AND_PLUS             : 'override-and-plus',
        OVERRIDE_FORCED_DEFAULT       : 'override-default-forced'
    },
    STATE_PROBLEM_PROPERTY: {
        NONE       : 'none',
        HAS_ERROR  : 'has_error',
        HAS_WARNING: 'has_warning'
    },
    STATE_VALUE_PLUS      : {
        ON : '+',
        OFF: ''
    },
    STATE_IS_NULL_VALUE   : {
        TRUE : '1',
        FALSE: '0'
    },
    ACTIVE                : {
        TRUE : '1',
        FALSE: '0'
    },
    MAX_SELECTABLE_ITEMS  : {
        RESULT_MODULATIONS: '4'
    },
    CUSTOM_SELECT         : {
        PLUS_AND_INHERITANCE       : '__PLUS_AND_INHERITANCE__',
        PLUS_AND_OVERRIDE          : '__PLUS_AND_OVERRIDE__',
        NONE                       : 'null',
        INHERITANCE                : '__INHERITANCE__',
        DEFAULT                    : '__DEFAULT_NO_TEMPLATE__',
        DEFAULT_FORCED             : '__DEFAULT_NO_TEMPLATE_FORCED__',
        DEFAULT_OR_INHERITANCE     : '__DEFAULT_OR_INHERITANCE__',
        NO_OVERRIDE                : '__NO_OVERRIDE__',
        ENTER_VALUE_FOR_MASS_CHANGE: '__ENTER_VALUE_FOR_MASS_CHANGE__'
    },
    DRAG_N_DROP           : {
        TYPE: {
            SELECTED_ITEM: 'selected-item'
        }
    },
    BOOLEAN               : {
        STATE_INHERITANCE: {
            INHERITANCE: true,
            DEFAULT    : false
        }
    },
    DATA                  : {
        IDENTIFIER_DATA_LOCAL: "_",
        PROTECTED_PLACEHOLDER: '********',
        GROUP                : {
            LOCALE   : "local",
            INHERITED: "templates",
            DFE      : "foreach-dfe"
        },
        STATUS               : {
            NONE  : "",
            NEW   : "shinken-data-status-new",
            HIDDEN: "shinken-data-hidden"
        }
    },
    TIMEPERIOD            : {
        SEPARATOR   : {
            RANGES  : ",",
            HOURS   : "-",
            HOUR_MIN: ":"
        },
        FORMAT_LABEL: {
            FULL : 'full',
            RANGE: 'range',
            HOUR : 'hour'
        },
        NO_MONTH    : "None"
    },
    ACL_MULTI             : {
        NAME: {
            READ    : 'read',
            CREATE  : 'create',
            ORGANIZE: 'organize',
            MODIFY  : 'modify',
            DELETE  : 'delete',
            ALL     : 'all'
        }
    },
    ACL_TYPE              : {
        HISTORY_SLA: 'history_sla',
        HISTORY    : 'history',
        SLA        : 'sla'
    },
    OVERRIDE              : {
        SEPERATOR: {
            AFTER_NAME: ',',
            AFTER_PROP: ' ',
            BETWEEN   : '-=#=-'
        }
    },
    NOTES_URL             : {
        SEPERATOR: {
            ENTRY    : '~#~',
            KEY_VALUE: '~='
        }
    },
    CHECK_COMMAND         : {
        SEPERATOR: '!'
    },
    PROTECTED_STATUS      : {
        NONE              : 0,
        PROTECTED         : 1,
        PROTECTED_MODIFIED: 2
    },
    SELECTOR              : {
        MAIN: "main-selector"
    },
    MASS_CHANGE           : {
        ACTION      : {
            NONE             : 'NONE',
            ADD              : 'ADD',
            ADD_SYNCHRO      : 'ADD_SYNCHRO',
            MOVE             : 'MOVE',
            EMPTY            : 'EMPTY',
            FORCE_TO_DEFAULT : 'FORCE_TO_DEFAULT',
            REPLACE          : 'REPLACE',
            REMOVE           : 'REMOVE',
            REMOVE_SYNCHRO   : 'REMOVE_SYNCHRO',
            REMOVE_ALL_EXCEPT: 'REMOVE_ALL_EXCEPT',
            SET              : 'SET',
            SET_SYNCHRO      : 'SET_SYNCHRO',
            SET_OR_CREATE    : 'SET_OR_CREATE',
            SET_IF_EXIST     : 'SET_IF_EXIST'
        },
        ACTION_EXTRA: {
            NONE  : 'NONE',
            LAST  : 'LAST',
            FIRST : 'FIRST',
            BEFORE: 'BEFORE',
            AFTER : 'AFTER'
        },
        PLUS_ACTION : {
            NONE: 'NONE',
            OFF : 'OFF',
            ON  : 'ON'
        },
        SELECTOR    : {
            ACTION        : "mass_change_action",
            ACTION_EXTRA  : "mass_change_action_extra",
            ELEMENT_EXTRA : "mass_change_element_extra",
            ELEMENT_SINGLE: "mass_change_element_single",
            ACTION_PLUS   : "mass_change_plus_action"
        }
    },
    HIDDEN                : 'hidden'
};
PROPERTY.getTypeByName = function ( property_name, shinken_element_type ) {
    switch ( property_name ) {
        case PROPERTY.CONST.NAME.CHECK_INTERVAL:
        case PROPERTY.CONST.NAME.CHECK_RUNNING_TIMEOUT:
        case PROPERTY.CONST.NAME.FIRST_NOTIFICATION_DELAY:
        case PROPERTY.CONST.NAME.FLAP_DETECTION_OPTIONS:
        case PROPERTY.CONST.NAME.FRESHNESS_THRESHOLD:
        case PROPERTY.CONST.NAME.MAX_CHECK_ATTEMPTS:
        case PROPERTY.CONST.NAME.NOTE_URL:
        case PROPERTY.CONST.NAME.NOTIFICATION_INTERVAL:
        case PROPERTY.CONST.NAME.NOTIFICATION_OPTIONS:
        case PROPERTY.CONST.NAME.RETRY_INTERVAL:
            return PROPERTY.CONST.TYPES.STRING_INPUT;
        case PROPERTY.CONST.NAME.CHECK_PERIOD:
        case PROPERTY.CONST.NAME.MAINTENANCE_PERIOD:
        case PROPERTY.CONST.NAME.NOTIFICATION_PERIOD:
            return PROPERTY.CONST.TYPES.SINGLE_SELECT;
        case PROPERTY.CONST.NAME.USE:
        case PROPERTY.CONST.NAME.VIEW_CONTACTS:
        case PROPERTY.CONST.NAME.NOTIFICATION_CONTACTS:
        case PROPERTY.CONST.NAME.EDITION_CONTACTS:
        case PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS:
        case PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS:
        case PROPERTY.CONST.NAME.EDITION_CONTACT_GROUPS:
        case PROPERTY.CONST.NAME.BUSINESS_IMPACT_MODULATIONS:
        case PROPERTY.CONST.NAME.CONTACTS:
        case PROPERTY.CONST.NAME.CONTACT_GROUPS:
        case PROPERTY.CONST.NAME.ESCALATIONS:
        case PROPERTY.CONST.NAME.MACRO_MODULATIONS:
        case PROPERTY.CONST.NAME.RESULT_MODULATIONS:
        case PROPERTY.CONST.NAME.PARENTS:
        case PROPERTY.CONST.NAME.NOTIFICATIONWAYS:
        case PROPERTY.CONST.NAME.CONTACTGROUPS:
        case PROPERTY.CONST.NAME.HOSTGROUPS:
            return PROPERTY.CONST.TYPES.MULTI_SELECT;
        case PROPERTY.CONST.NAME.HOST_NAME:
            switch ( shinken_element_type ) {
                case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_HOST:
                case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_CLUSTER:
                    return PROPERTY.CONST.TYPES.MULTI_SELECT;
                case OBJECT.CONST.ELEMENT.TYPES.CHECK_ON_TPL_HOST:
                case OBJECT.CONST.ELEMENT.TYPES.CHECK_ON_TPL_CLUSTER:
                    return PROPERTY.CONST.TYPES.STRING_INPUT_WITH_DROPDOWN;
                default:
                    return PROPERTY.CONST.TYPES.STRING_INPUT;
            }
        case PROPERTY.CONST.NAME.LOW_FLAP_THRESHOLD:
        case PROPERTY.CONST.NAME.HIGH_FLAP_THRESHOLD:
            return PROPERTY.CONST.TYPES.RANGE;
        case PROPERTY.CONST.NAME.SLA_CRITICAL_THRESHOLD:
        case PROPERTY.CONST.NAME.SLA_WARNING_THRESHOLD:
            return PROPERTY.CONST.TYPES.RANGE_WITH_INPUT;
        case PROPERTY.CONST.NAME.NOTE_MULTI_URL:
            return PROPERTY.CONST.TYPES.MULTI_LINE_OBJECT;
        default:
            if ( SHINKEN.TOOLS.STRING.startsWith( property_name, PROPERTY.CONST.DATA.IDENTIFIER_DATA_LOCAL ) ) {
                return PROPERTY.CONST.TYPES.DATA;
            }
            return '';
        
    }
    
};
var SOURCE = {};
SOURCE.CONST = {
    ASK_IMPORT: {
        NONE     : 0,
        ASKED    : 1,
        CONFIRMED: 2
    },
    VIEW_TYPES: {
        DETAIL: 0,
        ALL   : 1
    },
    TYPES     : {
        ALL      : 'all',
        COLLECTOR: 'collector',
        LISTENER : 'listener',
        ANALYZER : 'analyzer'
    },
    FIELD     : {
        NAME               : 'source_name',
        TYPE               : 'type',
        ORDER              : 'order',
        STATE              : 'state',
        ENABLED            : 'enabled',
        NEXT_IMPORT        : 'next_import',
        NB_ELEMENTS_OK     : 'nb_elements_ok',
        NB_ELEMENTS_WARNING: 'nb_elements_warning',
        NB_ELEMENTS_ERROR  : 'nb_elements_error',
        OUTPUT             : 'output',
        LAST_IMPORT        : 'last_import',
        LAST_IMPORT_HTML   : 'last_import_html',
        NEXT_IMPORT_HTML   : 'next_import_html',
        IMPORT_INTERVAL    : 'import_interval',
        IMPORT_ENABLED     : 'import_enabled',
        ALREADY_IMPORT     : 'already_import',
        IP_RANGES          : 'ip_range',
        MODULE_TYPE        : 'module_type',
        FULLY_MERGED       : 'fully_merged'
    },
    STATE     : {
        OK                          : 'OK',
        PENDING                     : 'PENDING',
        WARNING                     : 'WARNING ',
        CRITICAL                    : 'CRITICAL',
        RUNNING                     : 'RUNNING',
        NOT_CONFIGURED              : 'not-configured',
        NOT_CONFIGURED_BEFORE_IMPORT: 'not-configured-before-import',
        IN_PROGRESS                 : 'difference-computing',
        NEVER_IMPORT                : 'never-import',
        READY_FOR_IMPORT            : 'ready-for-import'
    },
    RANGE     : {
        ID         : '_id',
        NAME       : 'discovery_name',
        STATE      : 'state',
        ENABLED    : 'discovery_enabled',
        DESCRIPTION: 'notes',
        IP_RANGE   : 'iprange',
        SOURCE_NAME: 'source_name'
    }
};
var WINDOW = {};
WINDOW.CONST = {
    ELEMENT: {
        GENERIC      : "generic",
        DATAS        : "datas",
        CHECKS       : "checks",
        MONITORING   : "monitoring",
        NOTIFICATIONS: "notifications",
        ADVANCED     : "advanced",
        USER_RIGHTS  : "user-rights",
        AUTHORIZATION: "authorization"
    },
    CLASS  : {
        WINDOW_GROUP: "shinken-window-group",
        WINDOW_TAB  : "shinken-window-element"
    },
    ID     : {
        WINDOW_TAB: "id-shinken-window-",
        TAB_PANE  : "tab-pane-"
    }
};
var CONTROLLER = {};
CONTROLLER.CONST = {
    MASS_CHANGE: {
        NAME      : "mass-change",
        TYPE      : {
            PROPERTIES     : 'properties',
            DATAS          : 'datas',
            LOCAL_DATAS    : 'local_datas',
            DFE_DATAS      : 'dfe_datas',
            CHECKS         : 'checks',
            CHECKS_OVERRIDE: 'overrides',
            CHECKS_EXCLUDE : 'excludes'
        },
        GROUP_DATA: {
            ALL  : "___ALL___",
            LOCAL: "___LocalData___"
        }
    },
    PHASE      : {
        ACTIVE: 1
    }
};
