var PROP_DEFAULT_VALUE = '__DEFAULT_NO_TEMPLATE__'; // Value of default properties in database

var is_edit_mode_on      = false; // global value to know if we did exit or not
var __list_image_for_tpl = {};


//********************************************  AJAX CALL   ******************************************************//
function getElementsData () {
    if ( !MANAGER.__instance_element_distributor.current_element.canHaveTemplate() ) {
        return;
    }
    var _value = MANAGER.__instance_property_distributor.findElement( PROPERTY.CONST.NAME.USE ).getDataToSave();
    if ( !_value || _value === PROPERTY.CONST.CUSTOM_SELECT.NONE ) {
        return;
    }
    if ( !_value.links.length ) {
        return;
    }
    var jqxhr = $.ajax( {
        type   : "POST",
        data   : {
            links     : JSON.stringify( _value ),
            my_name   : MANAGER.__instance_element_distributor.current_element.getName(),
            item_type : MANAGER.__instance_element_distributor.current_element.getType(),
            uuid      : item_id,
            is_cluster: MANAGER.__instance_element_distributor.current_element.isCluster() ? "1" : "0"
        },
        url    : '/elements/byname/' + shinken_link_tpl + '/?ts=' + Date.now(),
        success: _successHandler, error: _failureHandler
    } );
    
    return jqxhr;
}

function getChecksData () {
    if ( !MANAGER.__instance_element_distributor.current_element.canHaveCheck() ) {
        return;
    }
    var _value = MANAGER.__instance_property_distributor.findElement( PROPERTY.CONST.NAME.USE ).getDataToSave();
    if ( !_value || _value === PROPERTY.CONST.CUSTOM_SELECT.NONE ) {
        _value       = {};
        _value.links = [];
    }
    if ( !_value.links.length ) {
        _value       = {};
        _value.links = [];
    }
    var item_type = $( '.form-element' ).data( 'type' );
    var jqxhr     = $.ajax( {
        type   : "POST",
        data   : {
            links    : JSON.stringify( _value ),
            my_name  : MANAGER.__instance_element_distributor.current_element.getName(),
            uuid     : item_id,
            item_type: item_type
        },
        url    : '/elements/checksbytemplates/?ts=' + Date.now(),
        success: _successHandler, error: _failureHandler
    } );
    
    return jqxhr;
}

function _successHandler ( data, textStatus, xhr ) {
    // console.info( 'Ajax ::', textStatus, xhr.status, data );
}

function _failureHandler ( xhr, ajaxOptions, thrownError ) {
    console.error( 'Ajax ::', ajaxOptions, xhr.status, thrownError );
}

//********************************************  DOM IS READY   ******************************************************//
var doActionWhenDomReady           = function ( e ) {
    CONTROLLER.ShinkenElement.setType( CONTROLLER.CONST.PHASE.ACTIVE );
    MANAGER.__instance_loading.showLoading( _( 'element.load_in_progress' ) );
    initAllExistingTplImage();
    initAllShinkenElement();
    initAllWindowElement();
    initSpecificByElementType();
    addElementEditionEventListener();
    updateALLTemplateAndCheckDatas( true );
};
var initAllWindowElement           = function () {
    MANAGER.__instance_window_distributor.findParentWindow( MANAGER.__instance_element_distributor.current_element.uuid ).setParentCounter( MANAGER.__instance_button_distributor.findButton( "save" ) );
    var _datas = MANAGER.__instance_window_distributor.findWindow( WINDOW.CONST.ELEMENT.DATAS, false, MANAGER.__instance_element_distributor.current_element.uuid );
    if ( _datas ) {
        _datas.getCounterTotal()._askUpdateHTML();
    }
    var _checks = MANAGER.__instance_window_distributor.findWindow( WINDOW.CONST.ELEMENT.CHECKS, false, MANAGER.__instance_element_distributor.current_element.uuid );
    if ( _checks ) {
        _checks.getCounterTotal().has_animation = true;
        _checks.getCounterTotal()._askUpdateHTML();
    }
};
var initAllShinkenElement          = function () {
    if ( typeof shinken_elements_lists !== 'undefined' ) {
        var _shinken_elements_lists = JSON.parse( SHINKEN.TOOLS.STRING.b64Decode( shinken_elements_lists ) );
        var _keys                   = Object.keys( _shinken_elements_lists );
        var _current_key;
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            for ( var j = 0, _size_j = _shinken_elements_lists[ _current_key ].length; j < _size_j; j++ ) {
                _current = new OBJECT.ShinkenElement();
                _current.updateData( _shinken_elements_lists[ _current_key ][ j ] );
                MANAGER.__instance_element_distributor.addElement( _current );
            }
        }
    }
    
    var _shinken_element = new OBJECT.ShinkenElement();
    _shinken_element.updateData( JSON.parse( SHINKEN.TOOLS.STRING.b64Decode( current_shinken_element ) ) );
    MANAGER.__instance_element_distributor.setCurrentElement( _shinken_element );
    _shinken_element.setPhase( OBJECT.CONST.ELEMENT.PHASE.VIEWING );
    
    current_shinken_element = null;
    shinken_elements_lists  = null;
};
var initAllExistingTplImage        = function () {
    if ( typeof shinken_list_img_for_tpl !== 'undefined' ) {
        __list_image_for_tpl = {};
        var _list_img        = JSON.parse( SHINKEN.TOOLS.STRING.b64Decode( shinken_list_img_for_tpl ) );
        for ( var i = 0, _size_i = _list_img.length; i < _size_i; i++ ) {
            __list_image_for_tpl[ _list_img[ i ] ] = true;
        }
    }
    shinken_list_img_for_tpl = null;
};
var initSpecificByElementType      = function () {
    if ( MANAGER.__instance_element_distributor.current_element.canHaveCheck() ) {
        MANAGER.HelpManager.setTitle( 'help_title_try_checks', _( 'element.help_title_try_checks' ) );
        MANAGER.HelpManager.setContent( 'help_title_try_checks', 'element.help_text_try_checks' );
        MANAGER.HelpManager.setImportKey( 'help_title_try_checks', "<span></span>" );
    }
};
var initAllShinkenProperty         = function ( is_init ) {
    var _elements = document.querySelectorAll( '.' + PROPERTY.CONST.CLASS.SKINKEN_LINE );
    for ( var i = 0, _size = _elements.length; i < _size; i++ ) {
        var _current = _elements[ i ];
        var _name    = _current.dataset.name;
        var _element = MANAGER.__instance_property_distributor.findElement( _name );
        _element.updateWithTemplate( MANAGER.__instance_element_distributor.list_templates, !is_init );
    }
    if ( is_init ) {
        MANAGER.__instance_property_distributor.finalyzeModel();
    }
};
//var cleanDataFor_SEF_6475          = function ( elementsData ) {
//    if ( !elementsData ) {
//        return elementsData;
//    }
//    var _use_value = MANAGER.__instance_property_distributor.findElement( PROPERTY.CONST.NAME.USE )
//    if ( !_use_value ) {
//        return elementsData;
//    }
//    _use_value = _use_value.getValue();
//
//    if ( !_use_value ) {
//        return elementsData;
//    }
//    _use_value = _use_value.split( "," );
//    for ( var i = 0, _size_i = elementsData.length; i < _size_i; i++ ) {
//        if ( SHINKEN.TOOLS.ARRAY.contains(_use_value, elementsData[i]['name']) ){
//            if ( elementsData[ i ][ 'template-status' ] === OBJECT.CONST.TEMPLATE.STATUS.DISABLED ) {
//                if ( elementsData[ i ]['enabled'] !== '0' ) {
//                    elementsData[ i ][ 'template-status' ] = OBJECT.CONST.TEMPLATE.STATUS.USEFUL;
//                }
//            }
//        }
//    }
//    return elementsData;
//};
var updateALLTemplateAndCheckDatas = function ( firstTime ) {
    MANAGER.__instance_loading.showLoading( _( 'element.load_in_progress' ) );
    if ( App.Elements.DataTab ) {
        App.Elements.DataTab.reset();
    }
    if ( !firstTime ) {
        MANAGER.__instance_element_distributor.current_element.unSetOverrideCheckInPageHost();
        
    }
    if ( MANAGER.__instance_element_distributor.current_element.canHaveCheck() ) {
        MANAGER.__instance_element_distributor.setAllChecksElementsToObsolete();
    }
    MANAGER.__instance_loading.addDebug( 'Ajax call start', MANAGER.__instance_loading.getDebugTimer() );
    $.when( getElementsData(), getChecksData() ).done( function ( elementsData, checksData ) {
        MANAGER.__instance_loading.addDebug( 'Ajax call end', MANAGER.__instance_loading.getDebugTimer() );
        elementsData = elementsData ? elementsData[ 0 ] : {};
        checksData   = (checksData) ? checksData[ 0 ] : {};
        //elementsData = cleanDataFor_SEF_6475( elementsData );
        //console.log( "GREG", "[elementsData 2]", elementsData );
        //console.log( "GREG", "[checksData]", checksData );
        MANAGER.__instance_loading.addDebug( 'Build template start', MANAGER.__instance_loading.getDebugTimer() );
        MANAGER.__instance_element_distributor.list_templates = new OBJECT.ListTemplate( elementsData );
        MANAGER.__instance_loading.addDebug( 'Build template end', MANAGER.__instance_loading.getDebugTimer() );
        
        for ( var i = 0, _size_i = elementsData.length; i < _size_i; i++ ) {
            //BIDOUILLE RAJOUTER POUR L'OVERRIDE... A VIRER QUAND LA METHODE getElementsData SERA NETTOYEE
            if ( elementsData[ i ].item_type === "hosttpls" ) {
                elementsData[ i ][ "@metadata" ]           = {};
                elementsData[ i ][ "@metadata" ][ "type" ] = elementsData[ i ].item_type;
                MANAGER.__instance_element_distributor.findElement( "core-host-" + elementsData[ i ][ '_id' ], elementsData[ i ] );
            }
        }
        MANAGER.__instance_loading.addDebug( 'Build property start', MANAGER.__instance_loading.getDebugTimer() );
        initAllShinkenProperty( firstTime );
        MANAGER.__instance_loading.addDebug( 'Build property end', MANAGER.__instance_loading.getDebugTimer() );
        MANAGER.__instance_element_distributor.current_element.cleanChecks();
        var _keys = Object.keys( checksData );
        var _current_key;
        var _current_template;
        var _current;
        var _current_check;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            _current     = checksData[ _current_key ];
            for ( var j = 0, _size_check = _current.length; j < _size_check; j++ ) {
                _current_check = MANAGER.__instance_element_distributor.findElement( "core-service-" + _current[ j ][ '_id' ], _current[ j ] );
                if ( MANAGER.__instance_element_distributor.current_element.uuid === _current_check.host_uuid ) {
                    MANAGER.__instance_element_distributor.current_element.addCheck( _current_check );
                }
                else {
                    _current_template = MANAGER.__instance_element_distributor.list_templates.getTemplateByUuid( _current_check.host_uuid );
                    if ( _current_template ) {
                        _current_template.addCheck( _current_check );
                    }
                }
                _current_check.is_obsolete = false;
            }
        }
        if ( App.DFE ) {
            App.DFE.init();
        }
        
        if ( !firstTime && MANAGER.__instance_element_distributor.current_element.canHaveCheck() ) {
            MANAGER.__instance_window_distributor.findWindow( WINDOW.CONST.ELEMENT.CHECKS, false, MANAGER.__instance_element_distributor.current_element.uuid ).resetCounters();
        }
        MANAGER.__instance_loading.addDebug( 'Build data start', MANAGER.__instance_loading.getDebugTimer() );
        if ( App.Elements.DataTab ) {
            App.Elements.DataTab.init();
        }
        MANAGER.__instance_loading.addDebug( 'Build data end', MANAGER.__instance_loading.getDebugTimer() );
        if ( MANAGER.__instance_macro_distributor ) {
            MANAGER.__instance_macro_distributor.recomputeLabelForEachMacro();
        }
        MANAGER.__instance_loading.addDebug( 'Build check start', MANAGER.__instance_loading.getDebugTimer() );
        if ( App.Elements.ChecksTab ) {
            App.Elements.ChecksTab.init();
        }
        MANAGER.__instance_loading.addDebug( 'Build check end', MANAGER.__instance_loading.getDebugTimer() );
        MANAGER.__instance_property_distributor.finalyzeView();
        
        MANAGER.__instance_element_distributor.current_element.validateOverride();
        
        $( window ).trigger( 'resize' );
        
        MANAGER.__instance_loading.setIsReady( true );
        MANAGER.__instance_loading.removeLoading();
    } );
};
var addElementEditionEventListener = function () {
    var nb_max_btn = $( '.action-area-inside' ).children( ':not(#empty-separator)' ).size();
    $( '#left-column' ).addClass( "max-btn-" + nb_max_btn );
    
    /***********************
     * History Events
     **********************/
    var $btnCancel = $( '#element-btn-cancel' ),
        $btnSave   = $( '#element-btn-save' );
    
    // We clean the url to put the real one.
    $btnCancel.find( 'a' ).attr( 'href', App.HistoryManager.previous() );
    $btnCancel.on( 'click', function ( e ) {
        e.preventDefault();
        if ( is_edit_mode_on ) {
            var result = confirm( _( 'element.warn_unsave' ) );
            if ( result ) {
                window.onbeforeunload = function () {
                }; // Fix SEF-1712
                App.HistoryManager.back();     // Go to the previous page
                App.HistoryManager.rollback(); // Remove the page calling this action of the historical.
            }
        }
        else {
            App.HistoryManager.back();     // Go to the previous page
            App.HistoryManager.rollback(); // Remove the page calling this action of the historical.
        }
    } );
    $btnSave.on( 'click', function ( e ) {
        App.HistoryManager.rollback(); // Remove the page calling this action of the historical.
    } );
    
    document.addEventListener( 'keydown', function ( event ) {
        MANAGER.EventManager.keydown( event );
    } );
    document.addEventListener( "click", function ( e ) {
        MANAGER.__instance_property_distributor.hidePopups();
    } );
    window.onbeforeunload = function () {
        if ( is_edit_mode_on ) {
            return _( 'element.warn_unsave' );
        }
    };
};
