//__lib__ lib_external
'use strict';

COMPONENT.Input           = function ( dom_element, parent, no_auto_valid, extra_key_validation ) {
    // dom_element
    // current_value
    // original_value
    // placeholder
    // is_protected
    // is_resizable
    this.auto_valid = !no_auto_valid;
    this.init( dom_element, parent, extra_key_validation );
};
COMPONENT.Input.prototype = {
    init                    : function ( dom_element, parent, extra_key_validation ) {
        this.initCounters( parent );
        this.dom_element             = dom_element;
        this.uuid                    = SHINKEN.TOOLS.STRING.buildUUID();
        this.current_value           = this.dom_element.getAttribute( 'value' );
        this.type                    = this.dom_element.getAttribute( 'type' );
        this.original_value          = this.current_value;
        this.placeholder_no_template = this.dom_element.placeholder;
        this.placeholder             = this.dom_element.placeholder;
        this.is_resizable            = this.dom_element.tagName === 'TEXTAREA';
        this.need_validation         = true;
        this.key_validation          = {
            "prop_name"     : parent.getParentName(),
            "component_name": extra_key_validation || ''
        };
        //if ( this.auto_valid ) {
        //    var _self = this;
        //    setTimeout( function () {
        //        _self.validateValueInput();
        //        _self.askComputeAfterChange( _self.dom_element );
        //    }, 50 );
        //}
    },
    //********************************************  SETTER GETTER   **************************************************//
    getDomValue             : function () {
        return this.dom_element.value;
    },
    setValueFromJs          : function ( to_set ) {
        this.current_value = to_set;
        this.computeNeedValidation();
        if ( this.need_validation ) {
            this.updateView( false, true, true );
        }
    },
    setValue                : function ( keep_cursor_pos ) {
        this.computeNeedValidation();
        this.current_value = this.getDomValue();
        this.askComputeHeight();
    },
    setStatus               : function ( to_set ) {
        this.status = to_set;
        DOM.Service.setDataSet( this.dom_element, 'status', to_set );
    },
    getStatus               : function () {
        return this.status;
    },
    setIsProtected          : function ( to_set ) {
        this.is_protected = to_set;
        this.dom_element.setAttribute( "type", (this.is_protected && SHINKEN.TOOLS.ENCRYPTION.isProtectedFieldsActivated()) ? SHINKEN.NAVIGATOR.isNavigator( 'isIE' ) ? "password" : "shinken-password" : this.type );
    },
    setPlaceholder          : function ( to_set ) {
        if ( !to_set ) {
            to_set = this.placeholder_no_template || '';
        }
        this.placeholder             = to_set;
        this.dom_element.placeholder = this.placeholder;
    },
    getValue                : function () {
        return this.current_value;
    },
    hasBeenChanged          : function () {
        return this.current_value !== this.original_value;
    },
    //********************************************  MESSAGES   **************************************************//
    setTooltip              : function ( to_set ) {
        this.dom_element.setAttribute( 'shi-tip-html', to_set );
    },
    setExtraTooltip         : function ( to_set ) {
        this.extra_tooltip = to_set;
    },
    addShinkenTooltip       : function ( type, message ) {
        if ( this.extra_tooltip && this.hasBeenChanged() ) {
            if ( message ) {
                message += "<br>";
            }
            
            message += this.extra_tooltip;
            if ( type === "shinken-success-border" ) {
                type = SHINKEN_TOOLTIP.TYPE.BEWARE_BORDER;
            }
            SHINKEN_TOOLTIP.showTooltip( this.dom_element );
        }
        this.dom_element.setAttribute( 'onmouseenter', "SHINKEN_TOOLTIP.showTooltip(this)" );
        this.dom_element.setAttribute( 'onmouseleave', "SHINKEN_TOOLTIP.hideTooltip()" );
        this.dom_element.setAttribute( 'shi-tip-type', type );
        this.dom_element.setAttribute( 'shi-tip-text', message );
        
        message ? SHINKEN_TOOLTIP.showTooltip( this.dom_element ) : SHINKEN_TOOLTIP.hideTooltip();
        
    },
    setMessage              : function ( message ) {
        var _status  = COMPONENT.CONST.STATUS.NONE;
        this.message = message;
        if ( message ) {
            _status = message.getStatus();
        }
        var _counter = [ 0, 0 ];
        this.setStatus( _status );
        switch ( _status ) {
            case COMPONENT.CONST.STATUS.ERROR:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.ERROR_BORDER, message.buildMessage() );
                _counter[ 0 ] = 1;
                break;
            case COMPONENT.CONST.STATUS.BEWARE:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.BEWARE_BORDER, message.buildMessage() );
                break;
            case COMPONENT.CONST.STATUS.WARNING:
                this.addShinkenTooltip( SHINKEN_TOOLTIP.TYPE.WARNING_BORDER, message.buildMessage() );
                _counter[ 1 ] = 1;
                break;
            case COMPONENT.CONST.STATUS.NONE:
                this.addShinkenTooltip( "shinken-success-border", message ? message.buildMessage() : "" );
                break;
        }
        this.setError( this.uuid, _counter[ 0 ] );
        this.setWarning( this.uuid, _counter[ 1 ] );
    },
    //********************************************  UPDATE VIEW  **************************************************//
    restoreCursorLocation   : function ( location ) {
        this.dom_element.focus();
        if ( location ) {
            this.last_cursor_location = location;
        }
        if ( !this.last_cursor_location ) {
            this.last_cursor_location = this.current_value.length;
        }
        this.dom_element.selectionStart = this.last_cursor_location;
        this.dom_element.selectionEnd   = this.last_cursor_location;
    },
    saveCursorLocation      : function () {
        this.last_cursor_location = this.getCursorLocation();
    },
    getCursorLocation       : function () {
        return this.dom_element.selectionStart;
    },
    updateView              : function ( is_inherited, update, keep_cursor_pos, has_inheritance ) {
        if ( has_inheritance !== undefined ) {
            this.has_inheritance = !!has_inheritance;
        }
        var _to_write = this.current_value;
        if ( this.current_value === 'null' && this.has_inheritance ) {
            _to_write = '';
        }
        //SEF-4379 Sous IE et chrome 56 le curseur se mettait à la fin après saisie, car n'aime pas dom_element.value = laValeur
        // Les textarea ne fonctionne pas avec un setAttribut
        // La mise à jour du champ par changement d'attribut ne doit se faire que lors d'une modification du champ
        
        if ( is_inherited ) {
            this.setStatus( COMPONENT.CONST.STATUS.NONE );
            this.resetCounters();
        }
        else {
            this.validateValueInput();
        }
        if ( keep_cursor_pos ) {
            this.saveCursorLocation();
        }
        
        if ( update ) {
            this.computeNeedValidation();
            DOM.Service.setInputValue( this.dom_element, is_inherited ? '' : _to_write );
        }
        else {
            this.current_value = this.getDomValue();
        }
        
        if ( this.dom_element.value ) {
            this.dom_element.classList.remove( 'shinken-empty-input' );
        }
        else {
            this.dom_element.classList.add( 'shinken-empty-input' );
        }
        this.askComputeHeight();
        if ( keep_cursor_pos ) {
            this.restoreCursorLocation();
        }
    },
    askComputeHeight : function () {
        var self = this;
        if ( self.timeout_ask_compute_height ) {
            clearTimeout( self.timeout_ask_compute_height );
        }
        self.timeout_ask_compute_height = setTimeout( function () {
            if ( self.is_resizable && DOM.Service.hasScrollHeight( self.dom_element ) && DOM.Service.getBoundingClientRect( self.dom_element, 'height' ) < 150 ) {
                self.dom_element.style.height = Math.min( 150, self.dom_element.scrollHeight + 6 ) + 'px';
            }
        }, 200 );
    },
    //********************************************  EVENT LISTENER   **************************************************//
    askComputeAfterChange   : function ( dom_element, parent, arg ) {
        var self = this;
        if ( self.timeout_ask_compute_after_change ) {
            clearTimeout( self.timeout_ask_compute_after_change );
        }
        self.timeout_ask_compute_after_change = setTimeout( function () {
            self.computeAfterChange( dom_element, parent, arg );
        }, 200 );
    },
    finishActionBeforeReload: function () {
        if ( this.timeout_ask_compute_after_change ) {
            this.computeAfterChange();
        }
    },
    computeAfterChange      : function ( dom_element, parent, args ) {
        this.setValue();
        if (!args ){
            args = {};
        }
        args['validation_done'] = this.validateValueInput();
        if ( parent ) {
            parent.doActionAfterChange( args );
        }
    },
    //********************************************  VALIDATION  **************************************************//
    validateValueInput      : function ( forced, ignore_focus ) {
        if ( !SHINKEN.TOOLS.SHINKEN_VALIDATOR ) {
            return false;
        }
        if ( this.need_validation || forced ) {
            var _validation_rules = this.getValidationRules( ignore_focus );
            var _validator;
            if ( _validation_rules ) {
                _validator = SHINKEN.TOOLS.SHINKEN_VALIDATOR._compute_validation( _validation_rules, SHINKEN.TOOLS.STRING.trimExtented( this.getValue() ) );
            }
            else {
                _validator = SHINKEN.TOOLS.SHINKEN_VALIDATOR.init_with_name( this.key_validation, this.getValue() );
            }
            this.setMessage( _validator );
            this.need_validation = false;
            return true;
        }
        return false;
    },
    addValidationRule       : function ( to_add, type ) {
        switch ( type ) {
            case COMPONENT.CONST.FILTER.TYPES_VALIDATION.HAS_FOCUS:
                if ( !this.validation_rules ) {
                    this.validation_rules = [];
                }
                this.validation_rules.push( to_add );
                break;
            case COMPONENT.CONST.FILTER.TYPES_VALIDATION.NOT_FOCUS:
                if ( !this.validation_rules_not_focus ) {
                    this.validation_rules_not_focus = [];
                }
                this.validation_rules_not_focus.push( to_add );
                break;
        }
        
    },
    setValidationRules      : function ( to_set, type ) {
        switch ( type ) {
            case COMPONENT.CONST.FILTER.TYPES_VALIDATION.HAS_FOCUS:
                this.validation_rules = to_set;
                break;
            case COMPONENT.CONST.FILTER.TYPES_VALIDATION.NOT_FOCUS:
                this.validation_rules_not_focus = to_set;
                break;
        }
    },
    computeNeedValidation   : function () {
        if ( this.need_validation ) {
            return;
        }
        if ( this.current_value !== this.getDomValue() ) {
            this.need_validation = true;
        }
    },
    getValidationRules      : function ( ignore_focus ) {
        if ( !this.validation_rules && !this.validation_rules_not_focus ) {
            return null;
        }
        if ( ignore_focus ) {
            return this.validation_rules_not_focus || this.validation_rules;
        }
        if ( !this.hasFocus() && this.validation_rules_not_focus ) {
            return this.validation_rules_not_focus;
        }
        return this.validation_rules;
    },
    hasFocus                : function () {
        return DOM.Service.hasFocus( this.dom_element );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.Input, SHINKEN.OBJECT.CounterInterface );