'use strict';

MANAGER.DistributorFilterManager           = function () {
    this.filters            = {};
    this.last_element_focus = null;
};
MANAGER.DistributorFilterManager.prototype = {
    createElement       : function ( dom_element ) {
        if ( !dom_element ) {
            return;
        }
        var _filter = new SHINKEN_LIST.Filter( dom_element );
        if ( _filter.isValid() ) {
            this.setElement( _filter.getParentName(), _filter );
            return _filter;
        }
    },
    findElement         : function ( name, focusing, selector, dom_element ) {
        var _to_return = this.getElement( name );
        if ( !_to_return ) {
            _to_return = this.createElement( dom_element );
        }
        if ( focusing ) {
            this.setLastInstanceFocus( _to_return );
        }
        return _to_return;
    },
    setElement          : function ( name, filter ) {
        this.filters[ name ] = filter;
    },
    getElement          : function ( name ) {
        return this.filters[ name ];
    },
    getAllElements      : function () {
        return SHINKEN.TOOLS.ARRAY.parseToArray( this.filters );
    },
    setLastInstanceFocus: function ( _to_set ) {
        if ( _to_set === null || typeof (_to_set) === "undefined" ) {
            return;
        }
        
        if ( this.last_element_focus && this.last_element_focus !== _to_set ) {
            this.hidePopups();
        }
        this.last_element_focus = _to_set;
        this.last_element_focus.dom_element.classList.add( "shinken-focus" );
        this.last_element_focus.validateValueInput();
    },
    getLastInstanceFocus: function () {
        return this.last_element_focus;
    },
    hidePopups          : function () {
        if ( this.last_element_focus !== null && typeof (this.last_element_focus) !== "undefined" ) {
            this.last_element_focus.dom_element.classList.remove( "shinken-focus" );
            this.last_element_focus.component.input.validateValueInput();
            this.last_element_focus.component.doActionAfterChange( { 'dom_element': this.last_element_focus } );
            this.last_element_focus.hidePopup();
            this.last_element_focus = null;
        }
    }
};
MANAGER.__instance_filter_distributor      = new MANAGER.DistributorFilterManager();
