'use strict';

MANAGER.HelpManager = {
    status                : MANAGER.CONST.HELP.STATUS.INACTIVE,
    active_name           : null,
    forced_name           : null,
    title                 : "",
    content               : "",
    mapping_label         : {},
    dom_element           : null,
    dom_element_title     : null,
    dom_element_content   : null,
    dom_element_import_key: null,
    dom_button_forced     : null,
    default_content       : _( 'element.help_hover' ),
    timer_set_inactive    : null,
    setStatus             : function ( to_set ) {
        this.status = to_set;
        this.initDomElement();
        this.buildHtml();
    },
    setActive             : function ( name, label, key_content, import_key ) {
        if ( this.timer_set_inactive ) {
            clearTimeout( this.timer_set_inactive );
        }
        if ( this.active_name === name ) {
            return;
        }
        this.active_name = name;
        this.createTextsIfMissing( name, label, key_content, import_key );
        this.setStatus( MANAGER.CONST.HELP.STATUS.ACTIVE );
        
        if ( CONTROLLER.MassChange ) {
            CONTROLLER.MassChange.computeSizesHelp();
        }
        else {
            CONTROLLER.ShinkenElement.computeSizesHelp();
        }
    },
    askSetInactive        : function ( name ) {
        if ( this.timer_set_inactive ) {
            clearTimeout( this.timer_set_inactive );
        }
        var _self               = this;
        this.timer_set_inactive = setTimeout( function () {
            _self.setInactive( name );
        }, 400 );
    },
    setInactive           : function ( name ) {
        if ( this.active_name !== name ) {
            return;
        }
        this.active_name = null;
        this.setStatus( this.forced_name ? MANAGER.CONST.HELP.STATUS.FORCED : MANAGER.CONST.HELP.STATUS.INACTIVE );
        this.timer_set_inactive = null;
        if ( CONTROLLER.MassChange ) {
            CONTROLLER.MassChange.computeSizesHelp();
        }
        else {
            CONTROLLER.ShinkenElement.computeSizesHelp();
        }
    },
    setForced             : function ( name, dom_element, forced ) {
        if ( this.forced_name === name && (name !== 'help_title_try_checks' || forced) ) {
            this.forced_name = false;
            this.dom_tag_help_button.classList.remove( 'shinken-active' );
        }
        else {
            if ( this.dom_tag_help_button ) {
                this.dom_tag_help_button.classList.remove( 'shinken-active' );
            }
            
            this.dom_tag_help_button = dom_element;
            this.forced_name         = name;
            if ( this.dom_tag_help_button ) {
                this.dom_tag_help_button.classList.add( 'shinken-active' );
            }
        }
        this.buildHtml();
    },
    cloneMapping              : function ( name_to_clone, new_mapping ) {
        if ( !this.mapping_label[ name_to_clone ] ) {
            this.setTitle(name_to_clone);
            this.setContent(name_to_clone);
            this.setImportKey(name_to_clone);
        }
        this.mapping_label[ new_mapping ] = this.mapping_label[ name_to_clone ];
    },
    setTitle              : function ( name_property, to_set ) {
        if ( !this.mapping_label[ name_property ] ) {
            this.mapping_label[ name_property ] = {};
        }
        if ( !to_set ) {
            to_set = _( 'help-' + MANAGER.__instance_element_distributor.current_element.getHelpType() + '.' + name_property + "-title" );
        }
        this.mapping_label[ name_property ].title = to_set;
    },
    setContent            : function ( name_property, to_set ) {
        //if ( !MANAGER.__instance_element_distributor.current_element ){
        //    return;
        //}
        if ( !this.mapping_label[ name_property ] ) {
            this.mapping_label[ name_property ] = {};
        }
        if ( !to_set ) {
            to_set = 'help-' + MANAGER.__instance_element_distributor.current_element.getHelpType() + '.' + name_property + "-content";
        }
        this.mapping_label[ name_property ].content = _( to_set );
        switch ( name_property ) {
            case PROPERTY.CONST.NAME.TIMEPERIOD_DAYS.MONDAY:
            case PROPERTY.CONST.NAME.TIMEPERIOD_DAYS.TUESDAY:
            case PROPERTY.CONST.NAME.TIMEPERIOD_DAYS.WEDNESDAY:
            case PROPERTY.CONST.NAME.TIMEPERIOD_DAYS.THURSDAY:
            case PROPERTY.CONST.NAME.TIMEPERIOD_DAYS.FRIDAY:
            case PROPERTY.CONST.NAME.TIMEPERIOD_DAYS.SATURDAY:
            case PROPERTY.CONST.NAME.TIMEPERIOD_DAYS.SUNDAY:
            case PROPERTY.CONST.NAME.ADVANCED_TIME_PERIODS:
                this.mapping_label[ name_property ].content += _( "help-timeperiods.day-specific-content" );
                break;
        }
    },
    setImportKey          : function ( name_property, to_set ) {
        if ( !this.mapping_label[ name_property ] ) {
            this.mapping_label[ name_property ] = {};
        }
        if ( !to_set ) {
            to_set = _( 'element.import_key' ) + ' : ' + name_property;
        }
        var _prop = MANAGER.__instance_property_distributor.getElement( name_property );
        if ( _prop && _prop.hide_import_key ) {
            to_set = "";
        }
        this.mapping_label[ name_property ].import_key = to_set;
    },
    clean                 : function () {
        DOM.Service.setHtmlOrHide( this.dom_element_title, '' );
        DOM.Service.setHtmlOrHide( this.dom_element_import_key, '' );
        DOM.Service.setHtmlOrHide( this.dom_element_content, '' );
    },
    buildHtml             : function () {
        var _texts = this.getTexts();
        if ( _texts ) {
            DOM.Service.setHtmlOrHide( this.dom_element_title, _texts.title );
            DOM.Service.setHtmlOrHide( this.dom_element_import_key, _texts.import_key );
            DOM.Service.setHtmlOrHide( this.dom_element_content, _texts.content );
        }
    },
    getHelpToDisplay      : function () {
        switch ( this.status ) {
            case MANAGER.CONST.HELP.STATUS.ACTIVE:
                return this.active_name;
            case MANAGER.CONST.HELP.STATUS.FORCED:
                return this.forced_name;
        }
        return false;
    },
    resetDomElement       : function () {
        this.dom_element            = null;
        this.dom_element_title      = null;
        this.dom_element_content    = null;
        this.dom_element_import_key = null;
        this.forced_name            = null;
        this.active_name            = null;
    },
    initDomElement        : function ( dom_element ) {
        if ( !dom_element && this.dom_element ) {
            return;
        }
        if ( !dom_element ) {
            dom_element = document;
        }
        this.dom_element = dom_element.querySelector( '#id-shinken-help-container' );
        if ( this.dom_element ) {
            this.dom_element_title      = this.dom_element.querySelector( '.shinken-help-name' );
            this.dom_element_content    = this.dom_element.querySelector( '.shinken-help-content-container' );
            this.dom_element_import_key = this.dom_element.querySelector( '.shinken-help-import-key' );
        }
    },
    createTextsIfMissing  : function ( name_property, title, key_translate_content, import_key ) {
        if ( this.mapping_label[ name_property ] ) {
            return;
        }
        this.setTitle( name_property, title );
        this.setContent( name_property, key_translate_content );
        this.setImportKey( name_property, import_key );
    },
    getTexts              : function () {
        var _name_property = this.getHelpToDisplay();
        var _to_return;
        if ( _name_property ) {
            _to_return = this.mapping_label[ _name_property ];
        }
        else {
            _to_return            = {};
            _to_return.title      = '';
            _to_return.import_key = '';
            _to_return.content    = this.default_content;
            
        }
        return _to_return;
    }
    
};