'use strict';

OBJECT.ServiceExcludes           = function ( datas ) {
    this.datas    = datas;
    this.excludes = [];
    this.size     = 0;
    this.init();
};
OBJECT.ServiceExcludes.prototype = {
    init               : function () {
        if ( this.datas ) {
            this.raw_value = this.datas.raw_value;
            this.initExcludeElement();
        }
    },
    initExcludeElement : function () {
        var _size = this.datas.links.length;
        for ( var i = 0; i < _size; i++ ) {
            this.addExclude( null, this.datas.links[ i ] );
        }
    },
    changeExcludeStatus: function ( check_in_page_host ) {
        var _existing = false;
        for ( var i = 0; i < this.size; i++ ) {
            if ( this.excludes[ i ].is( check_in_page_host ) ) {
                _existing = i;
                break;
            }
        }
        if ( _existing !== false ) {
            this.excludes.splice( _existing, 1 );
            this.size = this.excludes.length;
            return OBJECT.CONST.EXCLUDE_STATUS.OFF;
        }
        else {
            this.addExclude( check_in_page_host );
            return OBJECT.CONST.EXCLUDE_STATUS.BY_ID;
        }
    },
    addExclude         : function ( check_in_page_host, data ) {
        var _to_return = new OBJECT.ServiceExclude( check_in_page_host, data );
        this.excludes.push( _to_return );
        this.size = this.excludes.length;
        return _to_return;
    },
    getExcludeStatus   : function ( check_in_page_host ) {
        for ( var i = 0; i < this.size; i++ ) {
            if ( this.excludes[ i ].is( check_in_page_host ) ) {
                return OBJECT.CONST.EXCLUDE_STATUS.BY_ID;
            }
        }
        return OBJECT.CONST.EXCLUDE_STATUS.OFF;
    },
    getDataToSave      : function () {
        var _to_return = {};
        
        _to_return.has_plus  = false;
        _to_return.raw_value = '';
        _to_return.links     = [];
        
        for ( var i = 0; i < this.size; i++ ) {
            _to_return.links.push( this.excludes[ i ].getDataToSave() );
        }
        return _to_return;
    }
};

OBJECT.ServiceExclude           = function ( check_in_page_host, data ) {
    this.check_in_page_host = check_in_page_host;
    this.data               = data;
    if ( data ) {
        this.check_uuid = data._id;
    }
    this.init();
};
OBJECT.ServiceExclude.prototype = {
    init         : function ( check_in_page_host ) {
    },
    getDataToSave: function () {
        if ( !this.check_in_page_host ) {
            console.warn( "An exclude will be lost ==> ", this.data );
            return this.data;
        }
        var _to_return       = {};
        _to_return.name      = this.check_in_page_host.name;
        _to_return.exists    = true;
        _to_return._id       = this.check_in_page_host.uuid;
        _to_return.item_type = this.check_in_page_host.element.getType();
        if ( this.check_in_page_host.is_dfe ) {
            _to_return.dfe_key = this.check_in_page_host.key_dfe;
        }
        return _to_return;
    },
    is           : function ( check_in_host ) {
        var _to_return = false;
        if ( this.check_in_page_host ) {
            return check_in_host.getDomUUID() === this.check_in_page_host.getDomUUID();
        }
        if ( check_in_host.is_dfe && this.check_name === check_in_host.name ) {
            _to_return = true;
        }
        else if ( this.check_uuid === check_in_host.uuid ) {
            if ( check_in_host.is_dfe ) {
                _to_return = this.dfe_key === check_in_host.key_dfe;
            }
            else {
                _to_return = true;
            }
        }
        else if ( this.check_name && this.check_name === check_in_host.name ) {
            _to_return = true;
        }
        if ( _to_return ) {
            this.check_in_page_host = check_in_host;
        }
        return _to_return;
    }
};

