'use strict';

PROPERTY.SingleSelectWithInput           = function ( dom_element ) {
    // dom_element
    // name
    // value
    // inherited_value
    // custom_selected
    // type
    // component_select
    // component_btn_default
    // component_btn_inheritance
    // state
    // state_inheritance
    // state_arg_input
    // tab_parent_id
    this.init( dom_element );
};
PROPERTY.SingleSelectWithInput.prototype = {
    init                  : function ( dom_element ) {
        this.initDomElement( dom_element );
        this.initMainSelector();
        this.component_input           = new COMPONENT.Input( dom_element.querySelector( ".shinken-input" ), this );
        this.component_btn_inheritance = new COMPONENT.BtnInheritance( this.name, dom_element, this.type );
        this.getSelector().buildLinkOpenNewTab( this.item_type, this.link_id );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    computeErrorsSpecifics: function ( force_mass_change ) {
        //if ( this.is_mass_change ) {
        //    if ( !force_mass_change ) {
        //        this.component_select.setMessage();
        //        return;
        //    }
        //    var _need_value = false;
        //    var _action     = this.component_select_action_mass_change.getLastSelectedElement().element.name;
        //    switch ( _action ) {
        //        case PROPERTY.CONST.MASS_CHANGE.ACTION.SET:
        //            _need_value = true;
        //            break;
        //    }
        //    if ( _need_value && !this.getValue() ) {
        //        var _validator = SHINKEN.TOOLS.SHINKEN_VALIDATOR._compute_validation( [ PROPERTY.CONST.VALIDATOR.TYPE.NOT_EMPTY ], this.getValue() );
        //        this.component_select.setMessage( _validator );
        //        return;
        //    }
        //    return;
        //}
    },
    setErrorsSpecific     : function () {
        var _selected_element;
        switch ( this.state ) {
            case PROPERTY.CONST.STATE_PROPERTY.INHERITANCE:
                break;
            default:
                _selected_element = this.getSelector().getLastSelectedElement();
                break;
        }
        if ( _selected_element ) {
            this.counter_temp_error = _selected_element.element.getError();
        }
        this.tag_information.setStatus( this.counter_temp_error ? COMPONENT.CONST.TAG_INFORMATION.STATUS.NOT_VALID_FOR_ARBITER : COMPONENT.CONST.TAG_INFORMATION.STATUS.NONE );
        if ( !this.counter_temp_error && this.is_required ) {
            var _message            = SHINKEN.TOOLS.SHINKEN_VALIDATOR.init( this, this.last_list_element_selected );
            this.counter_temp_error = _message.messages_error.length;
            if ( this.counter_temp_error ) {
                this.counter_error_tooltip = _message.buildMessage();
            }
        }
    },
    askComputeAfterChange : function ( dom_element ) {
        this.component_input.askComputeAfterChange( dom_element, this );
    },
    doActionAfterChange   : function () {
        this.component_input.setValue();
        if ( this.state_inheritance && !this.is_override ) {
            this.clickOnItemSelector( this.inherited_cmd_name, null, this.getSelector() );
        }
        else {
            this._computeState();
        }
        if ( this.override_prop_name === PROPERTY.CONST.NAME.CHECK_COMMAND ) {
            App.Elements.ChecksTab.askInit( { override_command_change: true, property: this } );
        }
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    //********************************************  COMPUTE  (PRIVATE) ***********************************************//
    _computeBtnInheritance: function () {
        var _value        = this.getSelector().getValue();
        var _is_inherited = (this.custom_selected === PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_OR_INHERITANCE && !_value);
        if ( _is_inherited ) {
            this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.ON );
        }
        else {
            this.component_btn_inheritance.setState( COMPONENT.CONST.BTN_STATE.OFF );
        }
        
        this.setStateInheritance( _is_inherited );
        this.component_input.updateView( _is_inherited );
        var _state_property = _is_inherited ? PROPERTY.CONST.STATE_PROPERTY.INHERITANCE : PROPERTY.CONST.STATE_PROPERTY.USER_SET;
        this.setState( _state_property );
    },
    _computeState         : function () {
        this.state_inheritance = (this.component_btn_inheritance.getState() === COMPONENT.CONST.BTN_STATE.ON);
        var _to_set            = this.is_override ? PROPERTY.CONST.STATE_PROPERTY.OVERRIDE : PROPERTY.CONST.STATE_PROPERTY.USER_SET;
        switch ( this.last_list_element_selected ) {
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_SET_NONE;
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
                _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE:
                _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                if ( this.component_input.getValue() ) {
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.USER_SET;
                }
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                _to_set = this.is_mass_change ? PROPERTY.CONST.STATE_PROPERTY.USER_SET : PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                if ( this.is_override && this.override_prop_name === PROPERTY.CONST.NAME.CHECK_COMMAND && this.component_input.getValue() ) {
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.OVERRIDE;
                }
                else {
                    _to_set = PROPERTY.CONST.STATE_PROPERTY.INHERITANCE;
                }
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                _to_set = this.is_override ? PROPERTY.CONST.STATE_PROPERTY.OVERRIDE_FORCED_DEFAULT : PROPERTY.CONST.STATE_PROPERTY.USER_FORCED_DEFAULT;
                break;
        }
        this.setState( _to_set );
        this._computeLabelSelect();
        this._computeStateInput();
    },
    _computeStateInput    : function () {
        var _state = 1;
        switch ( this.last_list_element_selected ) {
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
            case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                _state = 0;
                break;
        }
        DOM.Service.setDataSet( this.dom_element, 'stateInput', _state );
    },
    //********************************************  GET / SET    **********************************************************//
    
    setValueFromUser  : function ( value, arg_value ) {
        arg_value = arg_value || '';
        if ( this.is_override ) {
            arg_value = value;
            value     = "";
        }
        this.component_input.dom_element.value = arg_value;
        this.doActionAfterChange();
        if ( !value ) {
            if ( this.is_mass_change ) {
                value = PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE;
            }
            else if ( this.component_btn_inheritance.isSet() ) {
                value = PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE;
            }
            else {
                value = this.is_override ? PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE : PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
            }
        }
        this.clickOnItemSelector( value, null, this.getSelector() );
        MANAGER.ListenerEventManager.askAfterActionProperty( this );
    },
    //********************************************  SAVE     *********************************************************//
    getDataToSaveFinal: function () {
        var _args_value;
        var _need_value = true;
        switch ( this.last_list_element_selected ) {
            case PROPERTY.CONST.CUSTOM_SELECT.NONE:
                return PROPERTY.CONST.CUSTOM_SELECT.NONE;
            case PROPERTY.CONST.CUSTOM_SELECT.INHERITANCE:
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT:
                return '';
            case PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE:
                if ( !this.component_input.getValue() ) {
                    return PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE;
                }
                _need_value = false;
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.NO_OVERRIDE:
                _args_value = this.component_input.getValue();
                if ( this.override_prop_name === PROPERTY.CONST.NAME.CHECK_COMMAND ) {
                    return _args_value;
                }
                if ( this.override_prop_name === PROPERTY.CONST.NAME.EVENT_HANDLER ) {
                    return '';
                }
                break;
            case PROPERTY.CONST.CUSTOM_SELECT.DEFAULT_FORCED:
                return PROPERTY.CONST.CUSTOM_SELECT.DEFAULT;
            
        }
        var _to_return       = {};
        _to_return.node      = {};
        _to_return.node.args = this.component_input.getValue();
        if ( _need_value ) {
            _to_return.node.link = this.getSelector().getValueToSave();
            _to_return.raw_value = _to_return.node.args ? this.getSelector().getValue() + PROPERTY.CONST.CHECK_COMMAND.SEPERATOR + _to_return.node.args : this.getSelector().getValue();
        }
        if ( this.is_mass_change && this.is_override_mass_change ) {
            _to_return = this.component_input.getValue() ? this.component_input.getValue() : PROPERTY.CONST.CUSTOM_SELECT.ENTER_VALUE_FOR_MASS_CHANGE;
        }
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.SingleSelectWithInput, PROPERTY.InterfaceSelect );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.SingleSelectWithInput, PROPERTY.Interface );