%from ...dao.def_items import DEF_ITEMS, PROP_DEFAULT_VALUE
%from ...dao.helpers import get_property_def
% import json
%properties_name = changes.keys() if changes else []
<script>
    var shinken_property_changes_list = [];
    %for property_name in properties_name:
        shinken_property_changes_list['{{property_name}}'] = true;
    %end
</script>

<div class="prop-line span12 hide"></div>
<div class="shinken-scroll-auto shinken-scroll-without-header">
    <span id="changes-table" class="span12 no-margin">
        <table class="change-pane">
            <thead style="background-color: #C2C2C2;" >
                <tr>
                    <th class="shinken-change-import-key-cell">{{app._('element.import_key')}}</th>
                    <th class="shinken-change-property-name-cell">{{app._('element.property')}}</th>
                    <th>{{app._('element.current_value')}}</th>
                    <th>{{app._('element.new_value')}}</th>
                    <th class="change_from_source">{{app._('element.from_source')}}</th>
                    <th class="change_action">{{app._('element.action_for_diff')}}</th>
                </tr>
            </thead>

            <tbody class="">
                %properties_name.sort()
                %for property_name in properties_name:
                    %old_value = changes[property_name][0]
                    %new_value = changes[property_name][1]
                    %source_info_property = changes[property_name][2]
                    %from_source = source_info_property.as_string(user, True)
                    %if isinstance(new_value, basestring):
                        %new_value = new_value.replace("'","&#39;")
                    %else:
                        %new_value = app.datamanagerV2.flatten_value(new_value, item_type, property_name)
                    %end

                    %item_property_display_name = app.helper.get_item_property_display_name(item_type, property_name)
                    %old_value_display, new_value_display, _is_protected_field = app.helper.diff_to_display(property_name, item_type, old_value, new_value)

                    %prop_def = get_property_def(item_type, property_name)
                    %prop_type =  prop_def.merging if prop_def else 'uniq'
                    %list_class = ''
                    %if property_name == 'use' or prop_type in ('join', 'ordered','duplicate'):
                        %old_value_display='<ul>%s</ul>'%''.join(['<li>%s</li>'%v for v in old_value_display.split(prop_def.separator) ])
                        %new_value_display='<ul>%s</ul>'%''.join(['<li>%s</li>'%v for v in new_value_display.split(prop_def.separator) ])
                        %list_class='list'
                    %end

                    <tr id='tr-change-{{property_name}}' class="shinken-element-property-line-difference">
                        <td class="shinken-value-cell shinken-change-import-key-cell">{{property_name}}</td>
                        %if item_property_display_name == app._('element.unknown_import_key'):
                            <td class="shinken-value-cell">
                                <span class="circle" style="display: inline-block;vertical-align: middle;"> <i class="shinkon-question"></i></span><span style="display: inline-block;vertical-align: middle;width: 70%;">{{!item_property_display_name}}</span>
                            </td>
                        %else:
                            <td class="shinken-value-cell shinken-property-name-cell">{{!item_property_display_name}}</td>
                        %end

                        %if _is_protected_field:
                            <td class="shinken-value-cell shinken-protected-password {{list_class}}" colspan="2">
                                {{!old_value_display}}
                            </td>
                        %else:
                            <td class="shinken-value-cell change-old-value {{list_class}}">{{!old_value_display}}</td>
                            <td class="shinken-value-cell change-new-value {{list_class}}">{{!new_value_display}}</td>
                        %end
                        <td class="shinken-value-cell change-source"><div>{{!from_source}}</div></td>
                        <td class="change-action">
                            <span onclick="shinken_toggle_change_diff_state('{{property_name}}')">
                                <div class="shinken-difference-btn shinken-ignore"><span class="shinkon shinkon-broom"></span>{{app._('element.ignore')}}</div>
                                <div class="shinken-difference-btn shinken-apply"><span class="shinkon shinkon-plus"></span>{{app._('element.apply')}}</div>
                            </span>
                        </td>
                    </tr>
                    <input type='text' id='change-input-{{property_name}}' class="shinken-hidden hide" value='{{!new_value}}'>
                %end
            </tbody>
        </table>
    </span>
</div>