%sname = source.get_name()
%stype = source.type
<div class="container-fluid">
    <div class="row">
        <div id="run-times" class="col-xs-5 col-sm-3">
            %title = app._('source.old_runs')
            %if stype == 'listener':
                %title = app._('source.old_requests')
            %end
            <h3 class="title">{{title}}:</h3>
            <ul class="content">
                %if last_runs:
                    %is_lastest_run = 1
                    %for r in last_runs:
                        %_st = r['synchronization_time']
                        %if is_lastest_run == 1:
                            <li id="run-{{_st}}" class="item-run-js active" data-stime="{{_st}}">
                        %else:
                            <li id="run-{{_st}}" class="item-run-js" data-stime="{{_st}}">
                        %end
                            %state = r['state'].replace('/ /g', '-' ).lower()
                            %state_txt = 'main.state-%s' %state
                            <div class="shinken-item-run" data-name="{{sname}}" data-type="{{stype}}" data-time="{{_st}}" data-is-lastest-run="{{is_lastest_run}}" draggable="false" onclick="getOldRun(this)">
                                <span>{{app.helper.print_date(_st)}}</span>
                                <span class="tag-state {{state.replace(' ', '-')}}">{{app._(state_txt.replace(' ','_'))}}</span>
                                <div class="shinken-run-detail">{{r.get('run_detail', '')}}</div>
                            </div>

                        </li>
                        %is_lastest_run = 0
                    %end
                %else:
                    <p>{{app.sync_history_lifespan_text}}</p>
                %end
            </ul>
        </div>
        <div id="run-results" class="col-xs-7 col-sm-9"></div>
    </div>
</div>