%if 'app' not in locals():
%app = None
%end
%if 'user' not in locals():
%user = {}
%end
%_class_btn_back = "shinken-disabled" if page_id == 'main' else ""
%error = configuration_stats['error']

%debug_mode = app.request.GET.get('shinken_debug', False)

%expert = user.is_expert()
%is_admin = user.is_admin()
%from ..dao.def_items import WORKING_AREA_STATUS

<table class="shinken-menu-top-bar" data-responsive="0">
    <tr class="shinken-menu">
        <td class="shinken-logo-cell">
            <a href="/main" class="menu-block logo-shinken-block">
                <span class="brand">
                    <img src="/static/{{app.http_start_time}}/img/enterprise-white.png">
                </span>
                %if app:
                <div class="shinken-version-number">{{ app.CURRENT_VERSION[0:8] if app.CURRENT_VERSION[9:12] == 'rel' else app.CURRENT_VERSION[0:12]}}</div>
                %end
            </a>
        </td>
        <td class="shinken-arrow-back-block-cell">
            <div class="shinken-arrow-back-border-edge-1">
                <div class="shinken-arrow-back-border-edge-2">
                    <div class="shinken-arrow-back-border">
                        <div class="arrow-back-background {{_class_btn_back}}" onclick="SHINKEN.HIGHWAY.goToParentUrl()">
                            <div class="shinkon shinkon-arrow-left arrow-back"></div>
                        </div>
                    </div>
                </div>
            </div>
        </td>
        <td class="navigation">
            %include( "header-top-bar/navigation_table" )
        </td>
        <td class="shinken-quit-cell">
            <button onclick="MANAGER.EventManager.logout()" class="btn-logout">
                <span class="username text-ellipsis"
                      onmouseenter="SHINKEN_TOOLTIP.showTooltip(this)"
                      onmouseleave="SHINKEN_TOOLTIP.hideTooltip()"
                      shi-tip-condition="shinken-ellipsis"
                      shi-tip-placement="bottom"
                      shi-tip-text="{{user.get('contact_name', 'unknown')}}">
                    {{user.get('contact_name', 'unknown')}}
                </span>
                <i class="shinkon shinkon-power icon"></i>
            </button>
        </td>
    </tr>
</table>

%if debug_mode:
<link href="/static/{{app.http_start_time}}/css/shinken-debug.css" rel="stylesheet">
<div id="id-shinken-debug-frame" data-tab-debug-mode="{{debug_mode}}">
    <table id="id-shinken-debug-table"></table>
</div>
%end



