#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.log import PartLogger
try:
    from collections import OrderedDict
except ImportError:
    from ordereddict import OrderedDict


class ComponentManager(object):
    
    def __init__(self, logger):
        # type: (PartLogger) -> None
        self.logger = logger
        self.components = OrderedDict()
    
    
    def reset(self):
        self.components = OrderedDict()
    
    
    def add_to_manager(self, component):
        component_class = type(component)
        self.components[component_class] = component
    
    
    def init(self):
        for component_type, component in self.components.iteritems():
            self._call_component(component_type, component, 'init')
    
    
    def tick(self):
        for component_type, component in self.components.iteritems():
            self._call_component(component_type, component, 'tick')
    
    
    def _call_component(self, component_type, component, call):
        try:
            return getattr(component, call)()
        except Exception, e:
            self.logger.error('Fail to call [%s] in [%s]. Error:[%s]' % (call, component_type, e))
            self.logger.print_stack()
            raise
