var __synchronizer_id    = window.parent.window.SHINKEN.HIGHWAY.getParams( 'synchronizer-id' );
var __source_name        = window.parent.window.SHINKEN.HIGHWAY.getParams( 'source-name' );
var __number_active_conf = 0;

function editSynchronizerLinker ( source_name, id_synchronizer ) {
    configurePlageIp( source_name, id_synchronizer );
}

function addNewSynchronizerLinker ( source_name ) {
    configurePlageIp( source_name, 'new' );
}

function init () {
    if ( __synchronizer_id && __source_name ) {
        var _url = __synchronizer_id === 'new' ? '/sources/' + __source_name + '/synchronizer-linker/add/?no_menu_if_unknown=1' : '/sources/' + __source_name + '/synchronizer-linker/' + __synchronizer_id + "?no_menu_if_unknown=1";
        window.parent.window.MANAGER.EventManager.openIframeModal( _url );
    }
    __number_active_conf = parseInt( window.parent.document.querySelector( '#wrapper .shinken-number-active-conf' ).innerHTML );
}

function configurePlageIp ( source_name, synchronizer_id ) {
    var _current_source = parent.window.MANAGER.__instance_source_distributor.findSource( source_name );
    _current_source.askUpdateBeforeAnyAction();
    var self = this;
    setTimeout( function () {
        self.ask_for_configure_interval = setInterval( function () {
            var _current_params                  = window.parent.window.SHINKEN.HIGHWAY.getParams();
            _current_params[ 'source-name' ]     = source_name;
            _current_params[ 'synchronizer-id' ] = synchronizer_id;
            window.parent.location.href          = window.parent.window.SHINKEN.HIGHWAY.getPath() + window.parent.window.SHINKEN.HIGHWAY.buildParamsToUrl( _current_params );
        }, 300 );
    }, 100 );
}

function clickOnActivatedSynchronizer ( source_name, synchronizer_id ) {
    var dom_synchronizer_row = document.querySelector( ".shinken-synchronizer-row[data-id='" + synchronizer_id + "']" );
    var to_send              = {};
    to_send.isEnabled        = !(dom_synchronizer_row.dataset.isActive === '1');
    $.post( '/sources/' + source_name + '/synchronizer-list/enabled/' + synchronizer_id, to_send ).success( form_success_activated_synchronizer ).error( form_error_activated_synchronizer );
}

function form_success_activated_synchronizer ( args ) {
    var dom_synchronizer_row = document.querySelector( ".shinken-synchronizer-row[data-id='" + args.synchronizer_id + "']" );
    if ( args.isEnabled ) {
        window.parent.window.DOM.Service.setDataSet( dom_synchronizer_row, 'isActive', "1" );
        updateNumberActiveConf( 1 );
    }
    else {
        window.parent.window.DOM.Service.setDataSet( dom_synchronizer_row, 'isActive', "0" );
        updateNumberActiveConf( -1 );
    }
    var _source = window.parent.window.MANAGER.__instance_source_distributor.findSource( args.source_name );
    _source.askForRefresh();
}

function updateNumberActiveConf ( to_set ) {
    __number_active_conf += to_set;
    window.parent.document.querySelector( '#wrapper .shinken-number-active-conf' ).innerHTML = __number_active_conf;
}

function form_error_activated_synchronizer ( args ) {
    console.error( args.responseText );
}

var doActionWhenDomReady = function ( e ) {
    init();
    document.addEventListener( "click", function () {
        window.parent.document.querySelector( "body" ).click();
    } );
};

document.addEventListener( "DOMContentLoaded", function ( e ) {
    doActionWhenDomReady();
} );
