<!DOCTYPE html>
<html id="whole-page" lang="fr">
    <head>
         <style type="text/css">
            @font-face {
                font-family : "shinkon";
                src         : url("/static/{{app.http_start_time}}/font/shinkenicons.woff") format("woff"),
                url("/static/{{app.http_start_time}}/font/shinkenicons.ttf") format("truetype"),
                url("/static/{{app.http_start_time}}/font/shinkon.svg#shinkon") format("svg");
                font-weight : normal;
                font-style  : normal;
            }
            @font-face {
                font-family : 'FontAwesome';
                src         : url('/static/{{app.http_start_time}}/font/fontawesome-webfont.eot?v=3.0.1');
                src         : url('/static/{{app.http_start_time}}/font/fontawesome-webfont.eot?#iefix&v=3.0.1') format('embedded-opentype'),
                url('/static/{{app.http_start_time}}/font/fontawesome-webfont.woff?v=3.0.1') format('woff'),
                url('/static/{{app.http_start_time}}/font/fontawesome-webfont.ttf?v=3.0.1') format('truetype');
                font-weight : normal;
                font-style  : normal;
            }
            @font-face {
                font-family : "Lato";
                src         : url("/static/{{app.http_start_time}}/font/lato-regular.ttf") format("truetype");
                font-weight : normal;
                font-style  : normal;
            }
         </style>
        <link rel="stylesheet" href="/static/{{app.http_start_time}}/synchronizer-collector-linker/css/vendor/bootstrap.min.css" />
        <link rel="stylesheet" href="/static/{{app.http_start_time}}/synchronizer-collector-linker/css/vendor/bootstrap-dropdown.css" />
        <link rel="stylesheet" href="/static/{{app.http_start_time}}/synchronizer-collector-linker/css/shinken_lib.css" />
        <link rel="stylesheet" href="/static/{{app.http_start_time}}/synchronizer-collector-linker/css/synchronizer-linker.css" />

        <script src="/static/{{app.http_start_time}}/synchronizer-collector-linker/js/shinken_lib/jquery.js"></script>
        <script src="/static/{{app.http_start_time}}/synchronizer-collector-linker/js/js_specific/synchronizer-collector-list-controller.js"></script>

        <title>{{translate_service._('common.sync_list_title')}}</title>
    </head>
    <body>
        <div class="table-head-js scroll-head content responsive">
            <table class="sync-linker-list table striped bordered" role="grid">
                <thead>
                    <tr role="row">
                        <th>
                            <span>{{translate_service._('common.import_status')}}</span>
                            <span class="shinken-between-space-parathensis shinken-linker-last-import-label">
                                {{translate_service._('common.last_import')}}
                            </span>
                        </th>
                        <th>
                            <span>{{translate_service._('common.import_message')}}</span>
                            <span class="shinken-between-space-parathensis shinken-linker-last-import-label">
                                {{translate_service._('common.last_import')}}
                            </span>
                        </th>
                        <th>{{translate_service._('common.sync_name')}}</th>
                        <th>{{translate_service._('common.address')}}</th>
                        <th>{{translate_service._('common.prefix')}}</th>
                        <th>{{translate_service._('sync.notes')}}</th>
                        <th>
                            <span class="col-md-3s">{{translate_service._('common.enabled')}}</span>
                            <span class="col-md-9s">
                                <a class="btn-shinken btn-blue text-ellipsis pull-right shinken-button-new-sync" title="{{translate_service._('common.add_new_sync')}}" onclick="addNewSynchronizerLinker('{{sname}}')">
                                    <span class="icon-plus"></span>
                                    &nbsp;{{translate_service._('common.add')}}
                                </a>
                            </span>

                        </th>
                    </tr>
                </thead>
            </table>
        </div>


        <div class="table-body-js scroll-body content responsive scroll-without-filter ">
            <table class="table striped bordered sync-linker-list" role="grid">
                <tbody>
                %for conf in sync_linker_confs:
                    %hname = conf.get('sync_name', 'unknown')
                    %_identif = conf.get('_id', '')
                    %_status = conf.get('last_import', 'never-import')
                    %_import_text = conf.get('last_import_text', translate_service._('sync.never-import'))
                    %_conf_id = conf.get('_id', 'unknown')
                    %_enabled = conf.get('enabled', 'false')
                    %is_enabled = "1" if _enabled else "0"
                    <tr class="shinken-synchronizer-row" data-id="{{_identif}}" data-is-active="{{is_enabled}}" data-status="{{_status}}">
                        <td class='last_import'>
                            <div class="shinken-last-import-status">{{translate_service._('sync.%s' % _status)}}</div>
                        </td>
                        <td class='last_import_text'>
                            <div class="shinken-last-import-text">{{_import_text}}</div>
                        </td>
                        <td class='sync_name cut-long'>
                            <span onclick="editSynchronizerLinker('{{sname}}', '{{_identif}}')">
                                <span class="shinken-label">{{hname}}</span>
                                <span class="shinkon-cog"></span>
                            </span>
                        </td>
                        <td class='ip cut-long '>{{conf.get('address','')}}</td>
                        <td class='port cut-long '>{{conf.get('prefix', '')}}</td>
                        <td class='notes cut-long '>{{conf.get('notes', "")}}</td>
                        <td class='enabled cut-long '>
                            <div class="content">
                                <table class = "column-enabled-table">
                                    <tr class="table-background-grey">
                                        <td >
                                            <div class="switch-button-wrapper" data-source-name="{{hname}}" onclick="clickOnActivatedSynchronizer('{{sname}}', '{{_identif}}')">
                                                <div class="switch-button" ></div >
                                            </div >
                                        </td >
                                        <td class="column-enabled-label show-if-discovery-activated disable-selection" >
                                            {{translate_service._('common.enabled')}}
                                        </td >
                                        <td class="column-enabled-label hide-if-discovery-activated disable-selection" >
                                            {{translate_service._('common.disabled')}}
                                        </td >
                                    </tr>
                                </table>
                            </div>
                        </td >
                        <!--TODO TCLE ADD A SWITCH BUTTON (ACTIVATE OR DEACTIVATE THE SYNCHRONIZER)-->
                        </td>
                    </tr>
                %end
                </tbody>
            </table>
        </div>
    </body>
</html>