DETAIL_GRAPH.GraphContainer = function () {
    //this.dom_element
    //has_metric
    this.has_metric = false;
    this.init();
};

DETAIL_GRAPH.GraphContainer.prototype = {
    init        : function () {
        this.dom_element = document.querySelector( '.shinken-detail-graph-container' );
    },
    setWidth    : function ( _width ) {
        this.dom_element.style.width = "calc(100vw - " + (_width + 50) + "px";
        var self = this;
        setTimeout( function (  ) {
            if ( self.dom_element.getBoundingClientRect().width < 400 ){
                self.dom_element.querySelector(".block_right_header .option").classList.add("shinken-hidden");
            }
            else {
                self.dom_element.querySelector(".block_right_header .option").classList.remove("shinken-hidden");
            }
        }, 100 )
    },
    setHasMetric: function ( to_set ) {
        this.has_metric = to_set;
        this.updateHtml();
    },
    updateHtml  : function () {
        if ( this.has_metric ) {
            this.dom_element.classList.add( 'shinken-has-active-metrics' );
        }
        else {
            this.dom_element.classList.remove( 'shinken-has-active-metrics' );
        }
    }
};

var __instance_detail_graph_container = new DETAIL_GRAPH.GraphContainer();