var DOM = {};

DOM.Service = (function( self ) {
    "use strict";
    
    var __previous_scrollLeft = 0;
    
    self.findParentElementWithDataSet    = function( element, key, deepLimit ) {
        if ( deepLimit < 0 ) {
            return null;
        }
        if ( element.dataset[ key ] ) {
            return element;
        }
        deepLimit--;
        return this.findParentElementWithDataSet( element.parentElement, key, deepLimit );
    };
    self.findParentElementWithClass    = function( element, class_tag, deepLimit ) {
        if ( deepLimit < 0 ) {
            return null;
        }
        if ( element.classList.contains( class_tag ) ) {
            return element;
        }
        deepLimit--;
        return this.findParentElementWithClass( element.parentElement, class_tag, deepLimit );
    };
    self.createElement                   = function( tag, attributes, innerHTML ) {
        var toReturn = document.createElement( tag );
        if ( attributes ) {
            var keys = Object.keys( attributes );
            var size = keys.length;
            for ( var i = 0; i < size; i++ ) {
                toReturn.setAttribute( keys[ i ], attributes[ keys[ i ] ] );
            }
        }
        if ( innerHTML ) {
            toReturn.innerHTML = innerHTML;
        }
        return toReturn;
    };
    self.bindElementOnScroll             = function( elementScrolled, elementToBind, name_property, callback ) {
        elementScrolled.addEventListener( DOM_CONSTANT.SCROLL.EVENT, function() {
            var scrollPos         = elementScrolled.getData( name_property );
            var _do_callback      = scrollPos !== __previous_scrollLeft;
            __previous_scrollLeft = scrollPos;
            elementToBind.setData( name_property, scrollPos );
            if ( _do_callback && callback ) {
                callback();
            }
        } );
    };
    self.removeElement                   = function( element ) {
        if ( !element ) {
            return;
        }
        var parent = element.parentNode;
        return parent.removeChild( element );
    };
    self.removeParentIfHasClassOrElement = function( element, class_to_test ) {
        if ( !element ) {
            return;
        }
        var parent = element.parentNode;
        if ( !parent ) {
            return;
        }
        
        if ( parent.classList.contains( class_to_test ) ) {
            var _grand_parent = parent.parentNode;
            if ( !_grand_parent ) {
                return;
            }
            _grand_parent.removeChild( parent );
        }
        
        return parent.removeChild( element );
    };
    self.setDataSet                      = function( element, attr, value ) {
        element.dataset[ attr ] = value;
        element.classList.toggle( "IE-PATCH" );
    };
    self.removeElementIfHasClass         = function( element, class_to_test ) {
        if ( !element ) {
            return;
        }
        if ( !element.classList.contains( class_to_test ) ) {
            return false;
        }
        var parent = element.parentNode;
        return parent.removeChild( element );
    };
    self.addElementTo                    = function( element, parent ) {
        if ( parent && element ) {
            parent.appendChild( element );
        }
    };
    self.switchElement                   = function( element_1, element_2 ) {
        if ( !element_1 || !element_2 ) {
            return;
        }
        var parent_1 = element_1.parentNode;
        var parent_2 = element_2.parentNode;
        
        parent_1.removeChild( element_1 );
        parent_2.removeChild( element_2 );
        
        parent_1.appendChild( element_2 );
        parent_2.appendChild( element_1 );
    };
    self.insertElementBefore             = function( element_1, element_2 ) {
        if ( !element_1 || !element_2 ) {
            return;
        }
        var _parent = element_1.parentNode;
        _parent.insertBefore( element_1, element_2 );
    };
    self.getValueDataSet                 = function( dom_element, key ) {
        return dom_element.dataset[ key ];
    };
    
    return self;
})( DOM.Service || {} );