﻿
function Point(x, y, z)
{
    this.x = x;
    this.y = y;
    this.z = z;
}

Point.prototype.distance = function(a, b)
{
    return(Math.sqrt( (b.x-a.x)*(b.x-a.x) + (b.y-a.y)*(b.y-a.y) + (b.z-a.z)*(b.z-a.z)));
}
Point.prototype.distance2D = function(a, b)
{
    return(Math.sqrt( (b.x-a.x)*(b.x-a.x) + (b.y-a.y)*(b.y-a.y)));
}


function Vertex (x, y, z)
{
    this.x = x;
    this.y = y;
    this.z = z;
    this.f = new Point(0, 0, 0);
    this.v = new Point(0, 0, 0);
    
    this.px = 0;
    this.py = 0;
}



/*
  Abstract unoriented mathematical graph
  
  E. g. when you have a "triangle", V={0, 1, 2}; E={{0,1}, {1,2}, {2,0}}}
  
  basic properties:
  n = 3;
  edgesl = [0, 1, 2];
  edgesr = [1, 2, 0];
  
  redundant properties:
  neibs = [[1,2], [2,0], [0,1]];	// neighbours of zero-th, first and second vertex
  comps = [[0,1,2]];	// there is only one component that contains all the vertices
  
  As you see, there are no "class" for vertices. There are only "indices" of vertices (from 0 to n-1)
  Your vertex can be anything, you will probably have them externally in an array 
  and these indices used in this class can be indices into your array.
*/
function Graph()
{
    //	basic properties
    this.n              = 0;	// number of vertices
    this.edgesl		= [];	// left indices of edges
    this.edgesr		= [];	// right indices of edges
    
    //	redundant properties, can be computed from basic properties
    this.neibs		= [];	// neighbours of each vertex (array of arrays)
    this.comps		= [];	// components of graph (array of arrays), each vertex belongs to one component
}

Graph.prototype.find_node = function ( id ) {
    for ( var i = 0; i < this.nodes.length; i++ ) {
        n = this.nodes[ i ];
        if ( n.id == id ) {
            return n;
        }
    }
    return null;
}

Graph.prototype.Build = function ()
{
    /*this.nodes = all_nodes;*/
    this.nodes = data_graph;
    
    var nb = this.nodes.length;
    //console.log('Creating Nodes :' + nb);
    
    this.MakeEmpty(nb);
    
    var a, b, e, n;
    for(var i=0; i<this.nodes.length; i++){
	n = this.nodes[i];
	a = i;
	// Now loop over links of this node
	for(var j=0; j<n.links.length; j++){
	    b = n.links[j];
	    this.AddEdge(a, b);
	}
    }
}

// returns index of component containing k. vertex
Graph.prototype.GetComp = function(k){
    for(var i=0; i<this.comps.length; i++) if(this.comps[i].indexOf(k) > -1) return i;
    return -1;
}

Graph.prototype.MakeEmpty = function(n){
    this.n = n;
    this.edgesl = [];
    this.edgesr = [];
    this.neibs	= [];
    this.comps	= [];
    
    for(var i=0; i<n; i++) { this.neibs.push([]); this.comps.push([i]);}
}

Graph.prototype.AddEdge = function(a, b){
    this.edgesl.push(a);
    this.edgesr.push(b);
    this.neibs[a].push(b);
    this.neibs[b].push(a);
    
    var ca = this.GetComp(a);
    var cb = this.GetComp(b);
    var cs = this.comps;
    if(ca != cb)
    {
	cs[ca] = cs[ca].concat(cs[cb]);
	cs.splice(cb, 1);
    }
}





var colors = ["#E30613", "#008ef1", "#f1b900", "#4b9700", "#970051", "#69058b", "#4f2e00", "#000547"];
//				red,		blue,	  yellow,	green,		 pink,		purple,		brown, 	dark blue

function Grapher2D()
{
    this.vertices	= [];	// 3D vertices
    this.positions  = [];   // Computed 3D positions
    this.vcolors	= [];
    this.repulsion	= 200;//200;
    this.attraction	= 0.06;//0.06;
    this.damping	= 0.9;//0.9;
    this.stable		= false;
    this.physics	= true;//true;
    this.is3D		= true;//false;
    this.noc		= 0;		// number of used colors
    this.dragged	= null;
    this.graph		= new Graph();
    this.max_link_size  = 150;
    var min = -500;//Number.NEGATIVE_INFINITY;
    var max = 500;//Number.POSITIVE_INFINITY;
    this.bounds		= {l:min, r:max, u:min, d:max, f:min, b:max};
    
    
    this.nb_iterations  = 0;

}

Grapher2D.prototype.MakeGraph = function () {
    this.graph.Build ();
    this.vertices = [];
    
    var rx, ry, rz;
    var r;
    var theta;
    var alpha;
    var v;
    for ( var i = 0, size = this.graph.n; i < size; i++ ) {
        r     = (i * 500) / this.graph.n;
        theta = (i / this.graph.n) * 2 * Math.PI;
        alpha = (i / this.graph.n) * 2 * Math.PI;
        rx        = -250 + Math.random () * 500;
        ry        = -250 + Math.random () * 500;
        rz        = -250 + Math.random () * 500;
        v         = new Vertex ( rx, ry, this.is3D ? rz : 0 );
        this.vertices.push ( v );
    }
    this.stable = false;
}

Grapher2D.prototype.SetBounds = function (lt, rt, up, dn, ft, bk)
{
    with(this.bounds) {l=lt; r=rt; u=up; d=dn; f=ft; b=bk;}
}

Grapher2D.prototype.MinColoring = function()
{
    var n = this.graph.n;
    this.vcolors = [];
    
    for(var i=0; i<n; i++) this.vcolors[i] = -1;
    
    for(var i=0; i<n; i++) this.Color(i);	// start recursive coloring on each vertex
}

Grapher2D.prototype.Color = function(k)	// coloring k-th vertex
{
    if(this.vcolors[k] >-1) return;
    var g = this.graph;
    var nb = this.graph.neibs[k];
    var cols = this.vcolors;
    var i, col = 0;
    var cbu = false; // can be used
    
    while(!cbu)
    {
	cbu = true;
	for(i=0; i<nb.length; i++)
	    if(cols[nb[i]] == col) {cbu = false; ++col; break;}
    }
    cols[k] = col;
    
    for(i=0; i<nb.length; i++) this.Color(nb[i]);
}



Grapher2D.prototype.Iterate = function()
{
    if(this.stable)		return this.stable;
    if(!this.physics)	{this.stable = true; return false;}
    
    var u, v, i, j, k, com, dsq;
    for(k=0; k < this.graph.comps.length; k++)
    {
	com = this.graph.comps[k];
	for(i=0; i < com.length; i++) // loop through vertices
	{
	    v = this.vertices[com[i]];
	    v.f.x = v.f.y = v.f.z = 0;
	    for(j=0; j < com.length; j++) // loop through other vertices
	    {
		if(i==j)continue;
		u = this.vertices[com[j]];
		//	coulomb's repulsion
		dsq = ((v.x-u.x)*(v.x-u.x)+(v.y-u.y)*(v.y-u.y)+(v.z-u.z)*(v.z-u.z)); // distance squared
		if(dsq==0) dsq = 0.001;
		var coul = this.repulsion / dsq;
		
		// We want a quick down of values near this.max_link_size, but a smooth way around it
		// So the atan is the perfect "fast down to 0 with smooth" function for this
		if(dsq > this.max_link_size*this.max_link_size){
		    coul = 0;
		}
		
		if(dsq < 50*50){
		    coul *= 2;
		}
		
		// But at least 0, no negative value please
		coul = Math.max(0, coul)
		v.f.x += coul * (v.x-u.x);
		v.f.y += coul * (v.y-u.y);
		v.f.z += coul * (v.z-u.z);
	    }
	}
    }
    
    
    for(i=0; i < this.graph.edgesl.length; i++) // loop through edges
    {
	u = this.vertices[this.graph.edgesl[i]];
	v = this.vertices[this.graph.edgesr[i]];
	
	//	hook's attraction
	v.f.x += this.attraction*(u.x - v.x);
	v.f.y += this.attraction*(u.y - v.y);
	v.f.z += this.attraction*(u.z - v.z);
	u.f.x += this.attraction*(v.x - u.x);
	u.f.y += this.attraction*(v.y - u.y);
	u.f.z += this.attraction*(v.z - u.z);
	
	
    }
    
    var dis = 0;
    var bs = this.bounds;
    for(i=0; i < this.graph.n; i++) // set new positions
    {
	v = this.vertices[i];
	if(v == this.dragged) continue;
	v.v.x = (v.v.x + v.f.x)*this.damping;
	v.v.y = (v.v.y + v.f.y)*this.damping;
	v.v.z = (v.v.z + v.f.z)*this.damping;

	v.x += v.v.x;
	v.y += v.v.y;
	v.z += v.v.z;
    }

    // Be sure 2 nodes are not too close
    for(i=0; i < this.graph.n; i++) // set new positions
    {
	v = this.vertices[i];
	for(j=0; j < this.graph.n; j++) // set new positions
	{
	    if(i != j){
		v2 = this.vertices[j];
		var gen_dsq = ((v.x-v2.x)*(v.x-v2.x)+(v.y-v2.y)*(v.y-v2.y)+(v.z-v2.z)*(v.z-v2.z)); // distance squared
		
		if(gen_dsq < 50*50){
		    v.x += (v.x - v2.x)/2;
		    v.y += (v.y - v2.y)/2;
		    v.z += (v.z - v2.z)/2;
		    v2.x += -(v.x - v2.x)/2;
		    v2.y += -(v.y - v2.y)/2;
		    v2.z += -(v.z - v2.z)/2;
		}
	    }
	}
    }
	
    // Do not go outside the world
    for(i=0; i < this.graph.n; i++) // set new positions
    {
	v.x = nmlz(bs.l, v.x, bs.r);
	v.y = nmlz(bs.u, v.y, bs.d);
	v.z = nmlz(bs.f, v.z, bs.b);
    }

    // Compute the distance sum
    for(i=0; i < this.graph.n; i++) // set new positions
    {
	v = this.vertices[i];
	if(v == this.dragged) continue;
	dis += Math.abs(v.v.x) + Math.abs(v.v.y) + Math.abs(v.v.z);
    }

    //console.log('Current dis '+dis+ ' an size' + this.graph.n);
    this.stable = dis < 10*this.graph.n;
    /*if(min_dis < 0.2){
	this.stable = false;
    }*/
    
    this.nb_iterations += 1;
    
    //console.log( 'Is stable? ' + this.stable + ' after ' + this.nb_iterations );
    // if too much iterations, stop it, but allowed time must scale with number of nodes
    var max_iter = Math.max( 60, this.graph.n * 3 );
    if ( this.nb_iterations >= max_iter ) {
        this.stable = true;
    }
    
    return this.stable && (this.dragged == null);
}


function nmlz(l, x, r)
{
    if(x<l) return l;
    if(x>r) return r;
    return x;
}


Grapher2D.prototype.SetDragged = function(x, y, r)
{
    var u = new Point(x, y, 0);
    var v;
    for(i=0; i < this.graph.n; i++) // set new positions
    {
	v = this.vertices[i];
	if(u.distance2D(u, v)<r)
	{
	    this.dragged = v;
	    this.stable = false;
	    break;
	}
    }
}

Grapher2D.prototype.MoveDragged = function(x, y)
{
    if(!this.dragged) return;
    this.dragged.x = x;
    this.dragged.y = y;
    this.stable = false;
}

Grapher2D.prototype.StopDragging = function()
{
    this.dragged = null;
}

Grapher2D.prototype.SwitchPhysics = function()
{
    this.physics = !this.physics;
    if(this.physics) this.stable = false;
}

Grapher2D.prototype.Switch3D = function()
{
    this.is3D = !this.is3D;
    if(this.is3D){
	for(i=0; i < this.graph.n; i++) // set new positions
	    this.vertices[i].z = -80 + Math.random()*160;
	this.stable = false;
    }else {
	for(i=0; i < this.graph.n; i++){// set new positions
	    this.vertices[i].z = 0;
	    this.vertices[i].f.z = 0;
	    this.vertices[i].v.z = 0;
	}
	this.stable = false;
    }
}

