var img_bar           = document.createElement ( 'img' );
var is_img_bar_loaded = false;

$ ( function () {

    function update_bar ( name, value ) {
        var c   = document.getElementById ( name );
        var ctx = c.getContext ( "2d" );
        var idx = 1;

        try {
            ctx.drawImage ( img_bar, 0, 0, 70, 18, 0, 0, 70, 18 );
            var offset = (value / 100) * 70;

            ctx.drawImage ( img_bar, 0, 18 * idx, offset, 18, 0, 0, offset, 18 );
        }
        catch ( err ) {
        }

    }

    img_bar.onload = function () {
        is_img_bar_loaded = true;
        //console.log ( 'LOADED IMAGE' );
        update_bar ( "bar_null", 0 );
        update_bar ( "bar_pan", 0 );
        update_bar ( "bar_rotate", 0 );
        update_bar ( "bar_zoom", 0 );
    };
    // Always set src AFTER the onload...
    img_bar.src = static_pth + '/threed/img/bar_horizontal.png';
    //console.log ( 'GOGO LOADING' );

    function refresh_bars () {
        if ( !is_img_bar_loaded ) {
            return;
        }
        //console.log(controls.nb_null);
        $ ( '#txt_null' ).html ( '' + controls.nb_null + ' ' + 100 * controls.nb_null / controls.history_size );
        update_bar ( "bar_null", 100 * controls.nb_null / controls.history_size )
        update_bar ( "bar_rotate", 100 * controls.nb_rotate / controls.history_size )
        update_bar ( "bar_pan", 100 * controls.nb_pan / controls.history_size )
        update_bar ( "bar_zoom", 100 * controls.nb_zoom / controls.history_size )

    }

    setInterval ( refresh_bars, 1000 / 12 );

} );
